<div class="page-content">
    <div class="page-container">
        <div class="row">
            <div class="col-12">
                
                <!-- Exchange Rate Management -->
                <div class="card">
                    <div class="card-header">
                        <h4>Bank Exchange Rate Management</h4>
                    </div>
                    <div class="card-body">
                        
                        <!-- Date and Currency Selection -->
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <label>Select Date</label>
                                <input type="date" id="exchange_date" class="form-control" 
                                       value="<?= htmlspecialchars($selectedDate) ?>" max="<?= date('Y-m-d') ?>">
                            </div>
                            <div class="col-md-3">
                                <label>BCC Rate  <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" id="bcc_rate" class="form-control" 
                                       value="<?= htmlspecialchars($bccRate ?? '') ?>" placeholder="0.00">
                                <small class="text-muted">
                                    <?= htmlspecialchars($currencies[$currencyId-1]['currency_short_name'] ?? 'USD') ?>
                                </small>
                            </div>
                            <!-- <div class="col-md-3">
                                <label>Currency</label>
                                <select id="currency_id" class="form-select">
                                    <?php foreach($currencies as $currency): ?>
                                        <option value="<?= $currency['id'] ?>" 
                                                <?= $currency['id'] == $currencyId ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($currency['currency_short_name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div> -->
                            <div class="col-md-3 d-flex align-items-end">
                                <button id="loadRatesBtn" class="btn btn-info me-2">
                                    <i class="ti ti-refresh"></i> Load
                                </button>
                                <button id="saveRatesBtn" class="btn btn-success me-2">
                                    <i class="ti ti-device-floppy"></i> Save
                                </button>
                            </div>
                        </div>
                        
                        <!-- Exchange Rates Table - Horizontal Layout -->
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th width="10%" class="text-center">Date</th>
                                        <th width="12%" class="text-center">BCC Rate</th>
                                        <?php if(!empty($banks)): ?>
                                            <?php foreach($banks as $bank): ?>
                                                <th class="text-center bank-column" data-bank-id="<?= $bank['id'] ?>">
                                                    <?= htmlspecialchars($bank['bank_name']) ?>
                                                    <br><small class="text-muted">Bank Rate</small>
                                                </th>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody id="ratesTableBody">
                                    <tr>
                                        <td class="text-center align-middle">
                                            <span id="display_date"><?= date('d-m-Y', strtotime($selectedDate)) ?></span>
                                        </td>
                                        <td class="text-center align-middle">
                                            <strong id="display_bcc_rate" class="text-primary">
                                                <?= $bccRate ? number_format($bccRate, 2) : '-' ?>
                                            </strong>
                                            <br><small class="text-muted">
                                                <?= htmlspecialchars($currencies[$currencyId-1]['currency_short_name'] ?? 'USD') ?>
                                            </small>
                                        </td>
                                        <?php if(!empty($banks)): ?>
                                            <?php foreach($banks as $bank): ?>
                                                <?php $rate = $exchangeRates[$bank['id']] ?? null; ?>
                                                <td class="text-center">
                                                    <input type="number" step="0.01" 
                                                           class="form-control form-control-sm bank-rate text-center" 
                                                           data-bank-id="<?= $bank['id'] ?>"
                                                           value="<?= $rate ? number_format($rate['bank_rate'], 2, '.', '') : '' ?>"
                                                           placeholder="0.00">
                                                    <small class="text-muted">
                                                        <?= htmlspecialchars($currencies[$currencyId-1]['currency_short_name'] ?? 'USD') ?>
                                                    </small>
                                                </td>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <td colspan="2" class="text-center">
                                                No banks configured for exchange rates.
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Quick Actions -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button id="copyPreviousBtn" class="btn btn-warning me-2">
                                    <i class="ti ti-copy"></i> Copy Previous Day
                                </button>
                                <button id="clearAllBtn" class="btn btn-danger me-2">
                                    <i class="ti ti-trash"></i> Clear All
                                </button>
                                <button id="exportRatesBtn" class="btn btn-secondary">
                                    <i class="ti ti-download"></i> Export
                                </button>
                            </div>
                        </div>
                        
                    </div>
                </div>
                
                <!-- Recent Exchange Rates History -->
                <div class="card mt-3">
                    <div class="card-header">
                        <h4>Exchange Rate History</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="history-table" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th width="10%">Date</th>
                                        <th width="10%">BCC Rate</th>
                                        <?php if(!empty($banks)): ?>
                                            <?php foreach($banks as $bank): ?>
                                                <th class="text-center">
                                                    <?= htmlspecialchars(substr($bank['bank_name'], 0, 15)) ?>
                                                </th>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                        <th width="10%">Updated</th>
                                    </tr>
                                </thead>
                                <tbody id="historyTableBody">
                                    <!-- Will be populated via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
    <?php include(VIEW_PATH . 'layouts/partials/footer.php'); ?>
</div>

<!-- Success Modal -->
<div class="modal fade" id="successModal" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">Success</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p id="successMessage"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" data-bs-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>

<!-- Error Modal -->
<div class="modal fade" id="errorModal" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Error</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p id="errorMessage"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    
    // Helper function to show success modal
    function showSuccess(message) {
        $('#successMessage').text(message);
        $('#successModal').modal('show');
    }
    
    // Helper function to show error modal
    function showError(message) {
        $('#errorMessage').text(message);
        $('#errorModal').modal('show');
    }
    
    // Update display when exchange date changes
    $('#exchange_date').change(function() {
        let date = new Date($(this).val());
        $('#display_date').text(formatDate(date));
        loadRates();
    });
    
    // Update display when BCC rate changes
    $('#bcc_rate').on('input', function() {
        let value = $(this).val();
        if (value) {
            $('#display_bcc_rate').text(parseFloat(value).toFixed(2));
        } else {
            $('#display_bcc_rate').text('-');
        }
    });
    
    // Format date to DD-MM-YYYY
    function formatDate(date) {
        let day = String(date.getDate()).padStart(2, '0');
        let month = String(date.getMonth() + 1).padStart(2, '0');
        let year = date.getFullYear();
        return `${day}-${month}-${year}`;
    }
    
    // Load rates for selected date
    function loadRates() {
        let date = $('#exchange_date').val();
        let currency_id = $('#currency_id').val();
        
        if (!date) return;
        
        $.ajax({
            url: '<?= APP_URL ?>bankExchangeRate/getRatesForDate',
            type: 'GET',
            data: { date: date, currency_id: currency_id },
            dataType: 'json',
            success: function(res) {
                if (res.success) {
                    // Clear all inputs
                    $('.bank-rate').val('');
                    
                    // Fill with loaded rates
                    $.each(res.rates, function(bankId, rate) {
                        $(`.bank-rate[data-bank-id="${bankId}"]`).val(
                            rate.bank_rate ? parseFloat(rate.bank_rate).toFixed(2) : ''
                        );
                    });
                    
                    // Update BCC rate if available
                    if (res.bcc_rate) {
                        $('#bcc_rate').val(parseFloat(res.bcc_rate).toFixed(2));
                        $('#display_bcc_rate').text(parseFloat(res.bcc_rate).toFixed(2));
                    } else {
                        $('#bcc_rate').val('');
                        $('#display_bcc_rate').text('-');
                    }
                }
            }
        });
    }
    
    $('#loadRatesBtn').click(function() {
        loadRates();
        loadHistory();
    });
    
    // Save all rates
    $('#saveRatesBtn').click(function() {
        let date = $('#exchange_date').val();
        let bcc_rate = $('#bcc_rate').val();
        let currency_id = $('#currency_id').val();
        
        if (!date) {
            showError('Please select a date');
            return;
        }
        
        if (!bcc_rate) {
            showError('Please enter BCC Rate');
            return;
        }
        
        let rates = {};
        $('.bank-rate').each(function() {
            let bankId = $(this).data('bank-id');
            let value = $(this).val();
            if (value) {
                rates[bankId] = {
                    bank_rate: value
                };
            }
        });
        
        if (Object.keys(rates).length === 0) {
            showError('Please enter at least one bank exchange rate');
            return;
        }
        
        $.ajax({
            url: '<?= APP_URL ?>bankExchangeRate/saveRates',
            type: 'POST',
            data: {
                exchange_date: date,
                bcc_rate: bcc_rate,
                currency_id: currency_id,
                rates: rates
            },
            dataType: 'json',
            success: function(res) {
                if (res.success) {
                    showSuccess(res.message);
                    loadHistory();
                } else {
                    showError(res.message);
                }
            },
            error: function() {
                showError('Error saving rates');
            }
        });
    });
    
    // Load history
    function loadHistory() {
        let currency_id = $('#currency_id').val();
        
        $.ajax({
            url: '<?= APP_URL ?>bankExchangeRate/getHistoryHorizontal',
            type: 'GET',
            data: { 
                currency_id: currency_id,
                limit: 10
            },
            dataType: 'json',
            success: function(res) {
                if (res.success) {
                    let tbody = $('#historyTableBody');
                    tbody.empty();
                    
                    if (res.data && res.data.length > 0) {
                        $.each(res.data, function(i, row) {
                            let tr = '<tr>';
                            tr += '<td>' + row.exchange_date + '</td>';
                            tr += '<td class="text-center"><strong class="text-primary">' + row.bcc_rate + '</strong></td>';
                            
                            // Add bank rates
                            $.each(row.banks, function(bankId, rate) {
                                tr += '<td class="text-center">' + 
                                      (rate || '-') + 
                                      '</td>';
                            });
                            
                            tr += '<td>' + row.updated_at + '</td>';
                            tr += '</tr>';
                            tbody.append(tr);
                        });
                    } else {
                        tbody.append('<tr><td colspan="100%" class="text-center">No history found</td></tr>');
                    }
                }
            }
        });
    }
    
    // Copy previous day rates
    $('#copyPreviousBtn').click(function() {
        let currentDate = $('#exchange_date').val();
        if (!currentDate) {
            showError('Please select a date first');
            return;
        }
        
        let previousDate = new Date(currentDate);
        previousDate.setDate(previousDate.getDate() - 1);
        let prevDateStr = previousDate.toISOString().split('T')[0];
        
        if (confirm(`Copy rates from ${formatDate(previousDate)} to current form?`)) {
            $.ajax({
                url: '<?= APP_URL ?>bankExchangeRate/getRatesForDate',
                type: 'GET',
                data: { 
                    date: prevDateStr, 
                    currency_id: $('#currency_id').val() 
                },
                dataType: 'json',
                success: function(res) {
                    if (res.success && Object.keys(res.rates).length > 0) {
                        // Copy BCC rate
                        if (res.bcc_rate) {
                            $('#bcc_rate').val(parseFloat(res.bcc_rate).toFixed(2));
                            $('#display_bcc_rate').text(parseFloat(res.bcc_rate).toFixed(2));
                        }
                        
                        // Copy bank rates
                        $.each(res.rates, function(bankId, rate) {
                            $(`.bank-rate[data-bank-id="${bankId}"]`).val(
                                rate.bank_rate ? parseFloat(rate.bank_rate).toFixed(2) : ''
                            );
                        });
                        showSuccess('Previous day rates copied successfully');
                    } else {
                        showError('No rates found for previous day');
                    }
                }
            });
        }
    });
    
    // Clear all rates
    $('#clearAllBtn').click(function() {
        if (confirm('Clear all rates in the form?')) {
            $('.bank-rate').val('');
            $('#bcc_rate').val('');
            $('#display_bcc_rate').text('-');
            showSuccess('All rates cleared');
        }
    });
    
    // Export rates
    $('#exportRatesBtn').click(function() {
        let date = $('#exchange_date').val();
        let currency_id = $('#currency_id').val();
        window.location.href = `<?= APP_URL ?>bankExchangeRate/exportRatesHorizontal?date=${date}&currency_id=${currency_id}`;
    });
    
    // Currency change handler
    $('#currency_id').change(function() {
        loadRates();
        loadHistory();
    });
    
    // Initial load
    loadRates();
    loadHistory();
    
});
</script>

<style>
.table input[type="number"] {
    min-width: 100px;
    max-width: 150px;
    margin: 0 auto;
}
.bank-column {
    min-width: 120px;
    font-size: 0.9rem;
}
.table-responsive {
    overflow-x: auto;
}
#history-table {
    font-size: 0.9rem;
}
#history-table th {
    white-space: nowrap;
}
.form-control-sm {
    height: calc(1.5em + .5rem + 2px);
    padding: .25rem .5rem;
    font-size: .875rem;
}
#bcc_rate {
    font-weight: 600;
    border: 2px solid #0d6efd;
}
#display_bcc_rate {
    font-size: 1.1rem;
}
</style>