<?php
// app/views/invoices/importinvoice.php
?>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">

<style>
  .form-label { font-size: 0.8rem; font-weight: 600; margin-bottom: 0.25rem; color: #2c3e50; }
  .form-control, .form-select { font-size: 0.85rem; padding: 0.4rem 0.6rem; height: auto; }
  .mb-2 { margin-bottom: 0.5rem !important; }
  
  .stats-card {
    border: none;
    border-radius: 12px;
    transition: all 0.3s ease;
    overflow: hidden;
    cursor: pointer;
    background: white;
    border: 2px solid transparent;
    position: relative;
  }
  
  .stats-card:hover { transform: translateY(-5px); box-shadow: 0 12px 24px rgba(0,0,0,0.15); }
  .stats-card.active-filter { border-color: #667eea; box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3); transform: scale(1.02); }
  .stats-card .card-body { padding: 18px; position: relative; }
  
  .stats-card-icon {
    width: 50px;
    height: 50px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 12px;
  }
  
  .stats-card-icon i { font-size: 22px; color: white; }
  .icon-purple { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
  .icon-green { background: linear-gradient(135deg, #2ECC71 0%, #27AE60 100%); }
  .icon-orange { background: linear-gradient(135deg, #F39C12 0%, #E67E22 100%); }
  .icon-maroon { background: linear-gradient(135deg, #800000 0%, #A52A2A 100%); }
  
  .stats-value { font-size: 2rem; font-weight: 700; color: #2C3E50; margin-bottom: 5px; line-height: 1; }
  .stats-label { font-size: 0.8rem; color: #7F8C8D; font-weight: 500; text-transform: uppercase; letter-spacing: 0.5px; }
  
  .filter-indicator {
    position: absolute;
    top: 10px;
    right: 10px;
    background: #667eea;
    color: white;
    border-radius: 50%;
    width: 24px;
    height: 24px;
    display: none;
    align-items: center;
    justify-content: center;
    font-size: 12px;
    font-weight: bold;
  }
  
  .stats-card.active-filter .filter-indicator { display: flex; }
  
  .accordion-button {
    font-weight: 600;
    background-color: #f8f9fa !important;
    color: #333 !important;
    padding: 1rem 1.25rem;
    border: none;
    display: flex !important;
    align-items: center !important;
    justify-content: space-between !important;
  }
  
  .accordion-button:not(.collapsed) {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    color: white !important;
    box-shadow: none !important;
  }
  
  .accordion-button::after { margin-left: 0 !important; }
  .accordion-button:not(.collapsed)::after { filter: brightness(0) invert(1); }
  .accordion-button:focus { box-shadow: none !important; border-color: rgba(0,0,0,.125) !important; }
  .accordion-button:hover { background-color: #e9ecef !important; }
  .accordion-button:not(.collapsed):hover { background: linear-gradient(135deg, #5568d3 0%, #6a4893 100%) !important; }
  
  .accordion-title-section { display: flex; align-items: center; gap: 10px; flex: 1; }
  
  .accordion-item {
    border: none;
    border-radius: 12px !important;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
  }
  
  .accordion-body { background: #ffffff; padding: 1.5rem; }
  
  .datatable-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
    padding: 15px 20px;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 8px;
  }
  
  .datatable-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: #2c3e50;
    display: flex;
    align-items: center;
    gap: 10px;
  }
  
  .datatable-actions { display: flex; align-items: center; gap: 10px; }
  
  .custom-search-box { position: relative; width: 250px; }
  
  .custom-search-box input {
    width: 100%;
    padding: 0.5rem 2.5rem 0.5rem 1rem;
    border: 2px solid #e9ecef;
    border-radius: 0.375rem;
    font-size: 0.875rem;
    transition: all 0.3s;
  }
  
  .custom-search-box input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
  }
  
  .custom-search-box i {
    position: absolute;
    right: 12px;
    top: 50%;
    transform: translateY(-50%);
    color: #7f8c8d;
    pointer-events: none;
  }
  
  .btn-export-all {
    background: #28a745 !important;
    border: none !important;
    color: white !important;
    font-weight: 600 !important;
    padding: 0.5rem 1.25rem !important;
    font-size: 0.875rem !important;
    border-radius: 0.375rem !important;
    cursor: pointer !important;
    display: flex !important;
    align-items: center !important;
    gap: 0.5rem !important;
    transition: all 0.3s !important;
  }
  
  .btn-export-all:hover {
    background: #218838 !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
  }
  
  .text-danger { color: #dc3545; font-weight: bold; }
  .is-invalid { border-color: #dc3545 !important; }
  .invalid-feedback { display: block; color: #dc3545; font-size: 0.75rem; margin-top: 0.15rem; }
  .readonly-field { background-color: #e9ecef; cursor: not-allowed; }
  .calculated-field { background-color: #d1ecf1; cursor: not-allowed; font-weight: 600; }
  .auto-generated-field { background-color: #f8f9fa; cursor: not-allowed; }
  .hidden-field { display: none !important; }
  
  .invoice-layout { display: flex; gap: 20px; margin-top: 15px; }
  .invoice-left-panel { flex: 0 0 25%; max-width: 25%; }
  .invoice-right-panel { flex: 0 0 75%; max-width: 75%; }
  
  .panel-header {
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
    color: white;
    padding: 8px 12px;
    font-weight: 600;
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-radius: 8px 8px 0 0;
  }
  
  .panel-body {
    background: white;
    border: 1px solid #e9ecef;
    border-top: none;
    border-radius: 0 0 8px 8px;
    padding: 12px;
  }
  
  .section-header {
    background: linear-gradient(135deg, #34495e 0%, #2c3e50 100%);
    color: white;
    padding: 6px 10px;
    font-weight: 600;
    font-size: 0.7rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 0;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: space-between;
  }
  
  .financial-table { width: 100%; margin-bottom: 10px; }
  
  .financial-table td {
    padding: 4px 8px;
    border-bottom: 1px solid #ecf0f1;
    font-size: 0.7rem;
  }
  
  .financial-table td:first-child {
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
    color: white;
    font-weight: 600;
    font-size: 0.65rem;
    text-transform: uppercase;
    width: 130px;
    border-radius: 4px;
  }
  
  .financial-table td:last-child { padding-left: 10px; }
  
  .financial-table input,
  .financial-table select {
    width: 100%;
    padding: 4px 8px;
    border: 1px solid #bdc3c7;
    border-radius: 4px;
    font-size: 0.7rem;
  }
  
  .financial-table .input-group { display: flex; gap: 4px; }
  .financial-table .input-group select { width: 60px; flex-shrink: 0; }
  .financial-table .input-group input { flex: 1; }
  
  #quotationSelector {
    width: 100%;
    padding: 8px 12px;
    border: 2px solid #e9ecef;
    border-radius: 6px;
    font-size: 0.85rem;
    transition: all 0.3s;
    background: white;
  }
  
  #quotationSelector:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
  }
  
  #quotationSelector option { padding: 8px; }
  
  .summary-totals {
    background: #f8f9fa;
    border-radius: 8px;
    padding: 18px 20px;
    margin-top: 20px;
    border: 1px solid #dee2e6;
  }
  
  .summary-totals table { width: 100%; }
  .summary-totals td { padding: 8px 0; font-size: 0.95rem; }
  .summary-totals td:first-child { color: #495057; font-weight: 500; }
  .summary-totals td:last-child { text-align: right; font-weight: 600; color: #212529; font-size: 1rem; }
  
  .summary-totals .grand-total td {
    font-size: 1.1rem;
    padding-top: 12px;
    border-top: 2px solid #adb5bd;
    font-weight: 700;
  }
  
  .summary-totals .grand-total td:last-child { color: #28a745; }
  
  .validation-badge {
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
    display: inline-block;
  }
  
  .validation-not-validated {
    background: linear-gradient(135deg, #fee 0%, #fcc 100%);
    color: #c00;
    border: 1px solid #fcc;
  }
  
  .validation-validated {
    background: linear-gradient(135deg, #cfe2ff 0%, #9ec5fe 100%);
    color: #084298;
    border: 1px solid #9ec5fe;
  }
  
  .validation-dgi-verified {
    background: linear-gradient(135deg, #d1e7dd 0%, #a3cfbb 100%);
    color: #0f5132;
    border: 1px solid #a3cfbb;
    font-weight: 700;
  }
  
  .bank-card {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    border: 2px solid #e9ecef;
    border-radius: 8px;
    padding: 12px;
    margin-top: 8px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
  }
  
  .bank-card-header {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-bottom: 10px;
    padding-bottom: 8px;
    border-bottom: 2px solid #dee2e6;
  }
  
  .bank-icon {
    width: 32px;
    height: 32px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 16px;
  }
  
  .bank-name {
    font-weight: 700;
    font-size: 0.8rem;
    color: #2c3e50;
    text-transform: uppercase;
    letter-spacing: 0.5px;
  }
  
  .bank-detail-row {
    display: flex;
    justify-content: space-between;
    padding: 4px 0;
    font-size: 0.7rem;
  }
  
  .bank-detail-label { color: #7f8c8d; font-weight: 500; }
  
  .bank-detail-value {
    color: #2c3e50;
    font-weight: 600;
    text-align: right;
    font-family: 'Courier New', monospace;
  }
  
  .bank-alert {
    background: #f8f9fa;
    border: 1px solid #dee2e6;
    border-radius: 8px;
    padding: 10px;
    text-align: center;
    color: #6c757d;
    font-size: 0.7rem;
    margin-top: 8px;
  }
  
  .btn-sm { padding: 0.35rem 0.65rem; font-size: 0.875rem; }
  
  .btn-pdf {
    background: #dc3545 !important;
    color: white !important;
    border: none !important;
  }
  
  .btn-pdf:hover {
    background: #c82333 !important;
    color: white !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(220, 53, 69, 0.3);
  }
  
  .btn-export {
    background: #28a745 !important;
    color: white !important;
    border: none !important;
  }
  
  .btn-export:hover {
    background: #218838 !important;
    color: white !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(40, 167, 69, 0.3);
  }
  
  .btn-validate {
    background: #17a2b8 !important;
    color: white !important;
    border: none !important;
  }
  
  .btn-validate:hover {
    background: #138496 !important;
    color: white !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(23, 162, 184, 0.3);
  }
  
  .btn-dgi {
    background: #800000 !important;
    color: white !important;
    border: none !important;
  }
  
  .btn-dgi:hover {
    background: #600000 !important;
    color: white !important;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(128, 0, 0, 0.3);
  }
  
  .card {
    box-shadow: 0 2px 12px rgba(0,0,0,0.08);
    border: none;
    border-radius: 12px;
  }
  
  .quotation-content {
    padding: 15px;
    background: #f8f9fa;
    border-radius: 6px;
    text-align: center;
    color: #7f8c8d;
    font-size: 0.9rem;
  }
  
  .quotation-panel {
    background: white;
    border: 1px solid #e9ecef;
    border-top: none;
    border-radius: 0 0 8px 8px;
    padding: 12px;
  }
  
  #quotationItemsContainer { margin-bottom: 15px; }
  
  .quotation-category-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 10px 15px;
    font-weight: 700;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-top: 15px;
    margin-bottom: 0;
    border-radius: 6px 6px 0 0;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    display: flex;
    justify-content: space-between;
    align-items: center;
  }
  
  .quotation-category-header:first-child { margin-top: 0; }
  
  .category-toggle-btn {
    background: rgba(255, 255, 255, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.4);
    color: white;
    padding: 4px 10px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 0.7rem;
    font-weight: 600;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    gap: 5px;
  }
  
  .category-toggle-btn:hover {
    background: rgba(255, 255, 255, 0.3);
    border-color: rgba(255, 255, 255, 0.6);
  }
  
  .category-toggle-btn i {
    font-size: 0.85rem;
    transition: transform 0.3s;
  }
  
  .category-toggle-btn.collapsed i { transform: rotate(-180deg); }
  
  .category-items-display {
    background: white;
    border: 1px solid #dee2e6;
    border-top: none;
    border-radius: 0 0 6px 6px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    transition: all 0.3s;
  }
  
  .category-items-display.collapsed { display: none; }
  
  .quotation-items-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 0.8rem;
  }
  
  .quotation-items-table thead {
    background: linear-gradient(135deg, #34495e 0%, #2c3e50 100%);
    color: white;
  }
  
  .quotation-items-table thead th {
    padding: 10px 12px;
    text-align: left;
    font-weight: 600;
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #667eea;
  }
  
  .quotation-items-table tbody tr {
    border-bottom: 1px solid #e9ecef;
    transition: background-color 0.2s;
  }
  
  .quotation-items-table tbody tr:hover { background-color: #f8f9fa; }
  .quotation-items-table tbody tr:last-child { border-bottom: none; }
  .quotation-items-table tbody td { padding: 10px 12px; vertical-align: middle; }
  .quotation-items-table .text-center { text-align: center; }
  .quotation-items-table .text-right { text-align: right; }
  .quotation-items-table .item-description { font-weight: 500; color: #2c3e50; }
  
  .quotation-items-table .item-unit,
  .quotation-items-table .item-currency {
    text-transform: uppercase;
    font-size: 0.7rem;
    color: #7f8c8d;
    font-weight: 500;
  }
  
  .quotation-items-table .item-total {
    font-weight: 700;
    color: #2c3e50;
    font-family: 'Courier New', monospace;
    font-size: 0.85rem;
  }
  
  .quotation-items-table .item-input {
    width: 100%;
    padding: 6px 10px;
    border: 1px solid #d1d5db;
    border-radius: 4px;
    font-size: 0.75rem;
    font-family: 'Courier New', monospace;
    transition: all 0.2s;
  }
  
  .quotation-items-table .item-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
  }
  
  .quotation-items-table .tva-display {
    width: 18px;
    height: 18px;
    pointer-events: none;
    opacity: 0.7;
  }
  
  .delete-item-btn {
    padding: 6px 12px;
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    border: none;
    color: white;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.2s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 0.75rem;
    font-weight: 600;
  }
  
  .delete-item-btn:hover {
    background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.4);
  }
  
  .delete-item-btn i { font-size: 0.9rem; }
  
  @media (max-width: 1400px) {
    .stats-card .card-body { padding: 15px; }
    .stats-value { font-size: 1.8rem; }
  }
  
  @media (max-width: 992px) {
    .invoice-layout { flex-direction: column; }
    .invoice-left-panel { flex: 1; max-width: 100%; }
    .invoice-right-panel { flex: 1; max-width: 100%; }
    .datatable-header { flex-direction: column; gap: 10px; align-items: flex-start; }
    .datatable-actions { width: 100%; flex-direction: column; }
    .custom-search-box { width: 100%; }
    .btn-export-all { width: 100%; justify-content: center !important; }
  }
  
  @media (max-width: 768px) {
    .stats-card .card-body { padding: 12px; }
    .stats-value { font-size: 1.5rem; }
    .stats-label { font-size: 0.7rem; }
    .quotation-items-table { font-size: 0.7rem; }
    .quotation-items-table thead th { padding: 8px 6px; font-size: 0.65rem; }
    .quotation-items-table tbody td { padding: 8px 6px; }
  }
</style>

<div class="page-content">
  <div class="page-container">
    <div class="row">
      <div class="col-12">
        
        <!-- VALIDATION-BASED STATISTICS CARDS -->
        <div class="row mb-4">
          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-3">
            <div class="card stats-card filter-card" data-filter="all">
              <div class="card-body">
                <div class="stats-card-icon icon-purple">
                  <i class="ti ti-file-invoice"></i>
                </div>
                <div class="stats-value" id="totalInvoices">0</div>
                <div class="stats-label">Total Invoices</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-3">
            <div class="card stats-card filter-card" data-filter="validated">
              <div class="card-body">
                <div class="stats-card-icon icon-green">
                  <i class="ti ti-circle-check"></i>
                </div>
                <div class="stats-value" id="totalValidated">0</div>
                <div class="stats-label">Validated</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-3">
            <div class="card stats-card filter-card" data-filter="not-validated">
              <div class="card-body">
                <div class="stats-card-icon icon-orange">
                  <i class="ti ti-alert-triangle"></i>
                </div>
                <div class="stats-value" id="totalNotValidated">0</div>
                <div class="stats-label">Not Validated</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 mb-3">
            <div class="card stats-card filter-card" data-filter="dgi-verified">
              <div class="card-body">
                <div class="stats-card-icon icon-maroon">
                  <i class="ti ti-file-check"></i>
                </div>
                <div class="stats-value" id="totalDGIVerified">0</div>
                <div class="stats-label">DGI Verified</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
        </div>

        <!-- ACCORDION WITH FORM -->
        <div class="accordion mb-4" id="invoiceAccordion">
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingInvoice">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseInvoice" aria-expanded="false" aria-controls="collapseInvoice">
                <div class="accordion-title-section">
                  <i class="ti ti-file-invoice"></i>
                  <span id="formTitle">Add New Import Invoice</span>
                </div>
              </button>
            </h2>
            <div id="collapseInvoice" class="accordion-collapse collapse" aria-labelledby="headingInvoice" data-bs-parent="#invoiceAccordion">
              <div class="accordion-body">
                
                <form id="invoiceForm" method="post" novalidate data-csrf-token="<?= htmlspecialchars($csrf_token, ENT_QUOTES, 'UTF-8') ?>">
                  <input type="hidden" name="invoice_id" id="invoice_id" value="">
                  <input type="hidden" name="action" id="formAction" value="insert">
                  <input type="hidden" name="kind_id" id="kind_id" value="">
                  <input type="hidden" name="goods_type_id" id="goods_type_id" value="">
                  <input type="hidden" name="transport_mode_id" id="transport_mode_id" value="">
                  <input type="hidden" name="quotation_id" id="quotation_id" value="">
                  <input type="hidden" name="quotation_items" id="quotation_items" value="">
                  <input type="hidden" name="hidden_categories" id="hidden_categories" value="[]">
                  <input type="hidden" name="bank_exchange_rate_id" id="bank_exchange_rate_id" value="">

                  <!-- Basic Info -->
                  <div class="row mb-2">
                    <div class="col-md-2 mb-2">
                      <label class="form-label">Client <span class="text-danger">*</span></label>
                      <select name="client_id" id="client_id" class="form-select" required>
                        <option value="">-- Select --</option>
                        <?php foreach ($clients as $client): ?>
                          <option value="<?= $client['id'] ?>"><?= htmlspecialchars($client['short_name']) ?></option>
                        <?php endforeach; ?>
                      </select>
                      <div class="invalid-feedback" id="client_id_error"></div>
                    </div>

                    <div class="col-md-2 mb-2">
                      <label class="form-label">License Number <span class="text-danger">*</span></label>
                      <select name="license_id" id="license_id" class="form-select" required>
                        <option value="">-- Select --</option>
                      </select>
                      <div class="invalid-feedback" id="license_id_error"></div>
                    </div>

                    <div class="col-md-3 mb-2">
                      <label class="form-label">MCA Reference <span class="text-danger">*</span></label>
                      <select name="mca_id" id="mca_id" class="form-select" required>
                        <option value="">Select MCA Reference</option>
                      </select>
                      <div class="invalid-feedback" id="mca_id_error"></div>
                    </div>

                    <div class="col-md-3 mb-2">
                      <label class="form-label">Invoice Ref <span class="text-danger">*</span></label>
                      <input type="text" name="invoice_ref" id="invoice_ref" class="form-control auto-generated-field" required maxlength="100" readonly placeholder="Select Client First">
                      <div class="invalid-feedback" id="invoice_ref_error"></div>
                    </div>

                    <div class="col-md-2 mb-2">
                      <label class="form-label">Tax & Duty Part:</label>
                      <select name="tax_duty_part" id="tax_duty_part" class="form-select">
                        <option value="Include">Include</option>
                        <option value="Exclude">Exclude</option>
                      </select>
                    </div>
                  </div>

                  <!-- Row 2 -->
                  <div class="row mb-2">
                    <div class="col-md-2 mb-2">
                      <label class="form-label">Kind <span class="text-danger">*</span></label>
                      <input type="text" name="kind" id="kind" class="form-control readonly-field" readonly placeholder="From MCA">
                    </div>

                    <div class="col-md-3 mb-2">
                      <label class="form-label">Type of Goods <span class="text-danger">*</span></label>
                      <input type="text" name="type_of_goods" id="type_of_goods" class="form-control readonly-field" readonly placeholder="From MCA">
                    </div>

                    <div class="col-md-2 mb-2">
                      <label class="form-label">Transport Mode <span class="text-danger">*</span></label>
                      <input type="text" name="transport_mode" id="transport_mode" class="form-control readonly-field" readonly placeholder="From MCA">
                    </div>

                    <div class="col-md-3 mb-2">
                      <label class="form-label">Invoice Template:</label>
                      <select name="invoice_template" id="invoice_template" required class="form-select">
                        <option value="">Select Template</option>
                        <option value="I">Include</option>
                        <option value="E">Exclude</option>
                      </select>
                    </div>

                    <div class="col-md-2 mb-2">
                      <label class="form-label">ARSP:</label>
                      <input type="text" name="arsp" id="arsp" class="form-control" value="Disabled" placeholder="Disabled">
                    </div>
                  </div>

                  <!-- SIDE-BY-SIDE LAYOUT: 25% / 75% -->
                  <div class="invoice-layout">
                    
                    <!-- LEFT PANEL - 25% -->
                    <div class="invoice-left-panel">
                      <div class="panel-header">
                        <i class="ti ti-receipt"></i> INVOICE DETAILS
                      </div>
                      <div class="panel-body">
                        
                        <div class="section-header">FINANCIAL INFO</div>
                        
                        <table class="financial-table">
                          <tr>
                            <td>FOB</td>
                            <td>
                              <div class="input-group">
                                <select name="fob_currency_id" id="fob_currency_id">
                                  <option value="">USD</option>
                                  <?php foreach ($currencies as $curr): ?>
                                    <option value="<?= $curr['id'] ?>"><?= htmlspecialchars($curr['currency_short_name']) ?></option>
                                  <?php endforeach; ?>
                                </select>
                                <input type="number" step="0.01" name="fob_usd" id="fob_usd" class="financial-calc-trigger" placeholder="0.00" min="0">
                              </div>
                            </td>
                          </tr>
                          
                          <tr>
                            <td>FRET</td>
                            <td>
                              <div class="input-group">
                                <select name="fret_currency_id" id="fret_currency_id">
                                  <option value="">USD</option>
                                  <?php foreach ($currencies as $curr): ?>
                                    <option value="<?= $curr['id'] ?>"><?= htmlspecialchars($curr['currency_short_name']) ?></option>
                                  <?php endforeach; ?>
                                </select>
                                <input type="number" step="0.01" name="fret_usd" id="fret_usd" class="financial-calc-trigger" placeholder="0.00" min="0">
                              </div>
                            </td>
                          </tr>
                          
                          <tr>
                            <td>ASSURANCE</td>
                            <td>
                              <div class="input-group">
                                <select name="assurance_currency_id" id="assurance_currency_id">
                                  <option value="">USD</option>
                                  <?php foreach ($currencies as $curr): ?>
                                    <option value="<?= $curr['id'] ?>"><?= htmlspecialchars($curr['currency_short_name']) ?></option>
                                  <?php endforeach; ?>
                                </select>
                                <input type="number" step="0.01" name="assurance_usd" id="assurance_usd" class="financial-calc-trigger" placeholder="0.00" min="0">
                              </div>
                            </td>
                          </tr>
                          
                          <tr>
                            <td>AUTRES CHG</td>
                            <td>
                              <div class="input-group">
                                <select name="autres_charges_currency_id" id="autres_charges_currency_id">
                                  <option value="">USD</option>
                                  <?php foreach ($currencies as $curr): ?>
                                    <option value="<?= $curr['id'] ?>"><?= htmlspecialchars($curr['currency_short_name']) ?></option>
                                  <?php endforeach; ?>
                                </select>
                                <input type="number" step="0.01" name="autres_charges_usd" id="autres_charges_usd" class="financial-calc-trigger" placeholder="0.00" min="0">
                              </div>
                            </td>
                          </tr>
                          
                          <tr>
                            <td>BANK</td>
                            <td>
                              <select name="exchange_bank_id" id="exchange_bank_id" class="exchange-rate-trigger">
                                <option value="">-- No Bank --</option>
                                <?php foreach ($exchangeBanks as $bank): ?>
                                  <option value="<?= $bank['id'] ?>"><?= htmlspecialchars($bank['bank_name']) ?></option>
                                <?php endforeach; ?>
                              </select>
                            </td>
                          </tr>
                          
                          <tr>
                            <td>RATE CDF/INV</td>
                            <td>
                              <input type="number" step="0.01" name="rate_cdf_inv" id="rate_cdf_inv" class="financial-calc-trigger" placeholder="2500.00" value="2500.00" min="0">
                            </td>
                          </tr>
                          
                          <tr>
                            <td>RATE CDF/BCC</td>
                            <td>
                              <input type="number" step="0.01" name="rate_cdf_usd_bcc" id="rate_cdf_usd_bcc" class="financial-calc-trigger" placeholder="2500.00" value="2500.00" min="0">
                            </td>
                          </tr>
                          
                          <tr>
                            <td>CIF USD</td>
                            <td>
                              <input type="number" step="0.01" name="cif_usd" id="cif_usd" class="calculated-field" readonly placeholder="0.00">
                            </td>
                          </tr>
                          
                          <tr>
                            <td>CIF CDF</td>
                            <td>
                              <input type="number" step="0.01" name="cif_cdf" id="cif_cdf" class="calculated-field" readonly placeholder="0.00">
                            </td>
                          </tr>
                          
                          <tr>
                            <td>DUTY CDF</td>
                            <td>
                              <input type="number" step="0.01" name="total_duty_cdf" id="total_duty_cdf" class="calculated-field" readonly placeholder="0">
                            </td>
                          </tr>
                          
                          <tr>
                            <td>POIDS (KG)</td>
                            <td>
                              <input type="number" step="0.01" name="poids_kg" id="poids_kg" placeholder="0.00" min="0">
                            </td>
                          </tr>
                          
                          <tr>
                            <td>TARIFF CODE</td>
                            <td>
                              <input type="text" name="tariff_code_client" id="tariff_code_client" maxlength="100">
                            </td>
                          </tr>
                        </table>
                        
                        <!-- ROAD TRANSPORT DETAILS -->
                        <div id="roadTransportSection" class="hidden-field">
                          <div class="section-header" style="margin-top: 8px;">ROAD TRANSPORT</div>
                          
                          <table class="financial-table">
                            <tr><td>HORSE</td><td><input type="text" name="horse" id="horse" maxlength="100"></td></tr>
                            <tr><td>TRAILER 1</td><td><input type="text" name="trailer_1" id="trailer_1" maxlength="100"></td></tr>
                            <tr><td>TRAILER 2</td><td><input type="text" name="trailer_2" id="trailer_2" maxlength="100"></td></tr>
                            <tr><td>CONTAINER</td><td><input type="text" name="container" id="container" maxlength="100"></td></tr>
                          </table>
                        </div>
                        
                        <!-- RAIL TRANSPORT DETAILS -->
                        <div id="railTransportSection" class="hidden-field">
                          <div class="section-header" style="margin-top: 8px;">WAGON TRANSPORT</div>
                          
                          <table class="financial-table">
                            <tr><td>WAGON</td><td><input type="text" name="wagon" id="wagon" maxlength="100"></td></tr>
                            <tr><td>HORSE</td><td><input type="text" name="horse_rail" id="horse_rail" maxlength="100"></td></tr>
                            <tr><td>TRAILER 1</td><td><input type="text" name="trailer_1_rail" id="trailer_1_rail" maxlength="100"></td></tr>
                            <tr><td>TRAILER 2</td><td><input type="text" name="trailer_2_rail" id="trailer_2_rail" maxlength="100"></td></tr>
                            <tr><td>CONTAINER</td><td><input type="text" name="container_rail" id="container_rail" maxlength="100"></td></tr>
                          </table>
                        </div>
                        
                        <!-- AIR TRANSPORT DETAILS -->
                        <div id="airTransportSection" class="hidden-field">
                          <div class="section-header" style="margin-top: 8px;">AIR TRANSPORT</div>
                          
                          <table class="financial-table">
                            <tr><td>AIRWAY BILL</td><td><input type="text" name="airway_bill" id="airway_bill" maxlength="100"></td></tr>
                            <tr><td>AWB WEIGHT</td><td><input type="number" step="0.01" name="airway_bill_weight" id="airway_bill_weight" placeholder="0.00" min="0"></td></tr>
                            <tr><td>CONTAINER</td><td><input type="text" name="container_air" id="container_air" maxlength="100"></td></tr>
                          </table>
                        </div>
                        
                        <!-- DOCUMENT DETAILS -->
                        <div class="section-header" style="margin-top: 8px;">DOCUMENTS</div>
                        
                        <table class="financial-table">
                          <tr><td>FACTURE/PFI</td><td><input type="text" name="facture_pfi_no" id="facture_pfi_no" maxlength="100"></td></tr>
                          <tr><td>PO REF</td><td><input type="text" name="po_ref" id="po_ref" maxlength="100"></td></tr>
                          <tr><td>BIVAC</td><td><input type="text" name="bivac_inspection" id="bivac_inspection" maxlength="100"></td></tr>
                          <tr><td>PRODUIT</td><td><input type="text" name="produit" id="produit" value="Default Commodity" maxlength="255"></td></tr>
                          <tr><td>EXONER CODE</td><td><input type="text" name="exoneration_code" id="exoneration_code" maxlength="100"></td></tr>
                          <tr><td>DECLAR NO</td><td><input type="text" name="declaration_no" id="declaration_no" maxlength="100"></td></tr>
                          <tr><td>DECLAR DATE</td><td><input type="date" name="declaration_date" id="declaration_date"></td></tr>
                          <tr><td>LIQUID NO</td><td><input type="text" name="liquidation_no" id="liquidation_no" maxlength="100"></td></tr>
                          <tr><td>LIQUID DATE</td><td><input type="date" name="liquidation_date" id="liquidation_date"></td></tr>
                          <tr><td>QUITTANCE NO</td><td><input type="text" name="quittance_no" id="quittance_no" maxlength="100"></td></tr>
                          <tr><td>QUIT DATE</td><td><input type="date" name="quittance_date" id="quittance_date" class="exchange-rate-trigger"></td></tr>
                          <tr><td>DISPATCH</td><td><input type="date" name="dispatch_deliver_date" id="dispatch_deliver_date"></td></tr>
                        </table>
                        
                        <!-- BANK SECTION WITH CARD DISPLAY -->
                        <div class="section-header" style="margin-top: 8px;">BANK</div>
                        
                        <div id="bankContainer">
                          <div class="bank-alert">
                            <i class="ti ti-info-circle me-1"></i>
                            Select a client to load banks
                          </div>
                        </div>
                        
                      </div>
                    </div>
                    
                    <!-- RIGHT PANEL - 75% QUOTATION SELECTION -->
                    <div class="invoice-right-panel">
                      <div class="section-header">
                        <span>QUOTATION SELECTION</span>
                      </div>
                      <div class="quotation-panel">
                        
                        <!-- QUOTATION DROPDOWN SELECTOR -->
                        <div style="margin-bottom: 15px;">
                          <label class="form-label" style="font-size: 0.85rem; font-weight: 600; margin-bottom: 8px; display: block;">
                            Select Quotation <span class="text-danger">*</span>
                          </label>
                          <select id="quotationSelector" class="form-select" style="padding: 8px 12px; font-size: 0.85rem;">
                            <option value="">-- Select Client First --</option>
                          </select>
                          <div style="margin-top: 5px; font-size: 0.75rem; color: #7f8c8d;">
                            <i class="ti ti-info-circle"></i> Quotations are automatically loaded when you select a Client
                          </div>
                        </div>
                        
                        <!-- Quotation Items Container -->
                        <div id="quotationItemsContainer" style="min-height: 50px;">
                          <div class="quotation-content">
                            <p style="margin: 0;"><i class="ti ti-info-circle me-1"></i> Select a quotation from the dropdown above</p>
                          </div>
                        </div>
                        
                        <!-- Summary Totals -->
                        <div class="summary-totals">
                          <table>
                            <tr>
                              <td>Total excl. TVA</td>
                              <td id="totalExclTVA">$0.00</td>
                            </tr>
                            <tr>
                              <td>TVA (16%)</td>
                              <td id="tvaAmount">$0.00</td>
                            </tr>
                            <tr class="grand-total">
                              <td>Grand Total</td>
                              <td id="grandTotal">$0.00</td>
                            </tr>
                            <tr>
                              <td>Equivalent CDF</td>
                              <td id="equivalentCDF">0.00 CDF</td>
                            </tr>
                          </table>
                        </div>
                      </div>
                    </div>
                    
                  </div>

                  <!-- Form Buttons -->
                  <div class="row mt-4">
                    <div class="col-12 text-end">
                      <button type="button" class="btn btn-secondary btn-sm" id="cancelBtn">
                        <i class="ti ti-x me-1"></i> Cancel
                      </button>
                      <button type="submit" class="btn btn-primary btn-sm ms-2" id="submitBtn">
                        <i class="ti ti-check me-1"></i> <span id="submitBtnText">Save Invoice</span>
                      </button>
                    </div>
                  </div>

                </form>
              </div>
            </div>
          </div>
        </div>

        <!-- Invoices DataTable Card -->
        <div class="card shadow-sm">
          <div class="datatable-header">
            <div class="datatable-title">
              <i class="ti ti-list"></i>
              <span>Import Invoices List</span>
            </div>
            <div class="datatable-actions">
              <button type="button" class="btn btn-sm btn-secondary" id="clearFilterBtn" style="display:none;">
                <i class="ti ti-filter-off me-1"></i> Clear Filter
              </button>
              <div class="custom-search-box">
                <input type="text" id="customSearchBox" placeholder="Search invoices..." autocomplete="off">
                <i class="ti ti-search"></i>
              </div>
              <button type="button" class="btn btn-export-all" onclick="exportAllInvoices();">
                <i class="ti ti-file-spreadsheet"></i> Export All to Excel
              </button>
            </div>
          </div>
          
          <div class="card-body">
            <div class="table-responsive">
              <table id="invoicesTable" class="table table-striped table-bordered dt-responsive nowrap w-100">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Invoice Ref</th>
                    <th>Client</th>
                    <th>MCA Ref</th>
                    <th>CIF USD</th>
                    <th>Total Duty</th>
                    <th>Validation</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
  <?php include(VIEW_PATH . 'layouts/partials/footer.php'); ?>
</div>

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>

<script>
$(document).ready(function () {
  let invoicesTable;
  let currentFilter = 'all';
  let quotationItemsData = [];
  let quotationData = null;
  let hiddenCategoryIndices = [];

  let baseUrl = '<?= rtrim(APP_URL, "/") ?>';
  const CONTROLLER_URL = baseUrl + '/importinvoice';
  const csrfToken = $('#invoiceForm').data('csrf-token');
  
  console.log('🚀 Import Invoice System Initialized (Enhanced with Bank Exchange Rates)');
  console.log('📍 Controller URL:', CONTROLLER_URL);
  
  function escapeHtml(text) {
    if (text === null || text === undefined) return '';
    const map = {'&': '&amp;','<': '&lt;','>': '&gt;','"': '&quot;',"'": '&#039;'};
    return String(text).replace(/[&<>"']/g, function(m) { return map[m]; });
  }
  
  function sanitizeNumber(value) {
    const num = parseFloat(value);
    return isNaN(num) || num < 0 ? 0 : num;
  }

// EXCHANGE RATE HANDLER
function loadExchangeRates() {
  const bankId = $('#exchange_bank_id').val();
  const quittanceDate = $('#quittance_date').val();
  
  if (!bankId || !quittanceDate) {
    // Reset to manual entry
    $('#rate_cdf_inv').prop('readonly', false).removeClass('calculated-field');
    $('#rate_cdf_usd_bcc').prop('readonly', false).removeClass('calculated-field');
    $('#bank_exchange_rate_id').val('');
    return;
  }

  console.log('🏦 Loading exchange rates for bank:', bankId, 'date:', quittanceDate);
  
  $.ajax({
    url: CONTROLLER_URL + '/crudData/getExchangeRates',
    method: 'GET',
    data: { bank_id: bankId, exchange_date: quittanceDate },
    dataType: 'json',
    success: function(res) {
      console.log('📊 Exchange rates response:', res);
      
      if (res.success && res.data) {
        // Parse rates and ensure they're numbers
        const bankRate = parseFloat(res.data.bank_rate) || 2500;
        const bccRate = parseFloat(res.data.bcc_rate) || 2500;
        
        $('#bank_exchange_rate_id').val(res.data.id);
        
        // Set the values with proper formatting for display
        $('#rate_cdf_inv').val(bankRate.toFixed(2)).prop('readonly', true).addClass('calculated-field');
        $('#rate_cdf_usd_bcc').val(bccRate.toFixed(2)).prop('readonly', true).addClass('calculated-field');
        
        // Trigger calculation
        calculateFinancials();
        
        console.log('✅ Exchange rates applied - Bank Rate:', bankRate, 'BCC Rate:', bccRate);
        
        Swal.fire({
          icon: 'success',
          title: 'Exchange Rates Loaded',
          html: `<strong>Bank Rate:</strong> ${bankRate.toFixed(4)}<br><strong>BCC Rate:</strong> ${bccRate.toFixed(4)}`,
          timer: 2000,
          showConfirmButton: false
        });
      } else {
        console.warn('⚠️ No exchange rates found');
        Swal.fire({
          icon: 'warning',
          title: 'No Exchange Rates Found',
          text: res.message || 'No exchange rates available for this date. Using manual entry.',
          timer: 3000
        });
        $('#rate_cdf_inv').prop('readonly', false).removeClass('calculated-field');
        $('#rate_cdf_usd_bcc').prop('readonly', false).removeClass('calculated-field');
        $('#bank_exchange_rate_id').val('');
      }
    },
    error: function(xhr, status, error) {
      console.error('❌ Error loading exchange rates:', error);
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: 'Failed to load exchange rates',
        timer: 2000
      });
      $('#rate_cdf_inv').prop('readonly', false).removeClass('calculated-field');
      $('#rate_cdf_usd_bcc').prop('readonly', false).removeClass('calculated-field');
      $('#bank_exchange_rate_id').val('');
    }
  });
}

  // Exchange rate triggers
  $(document).on('change', '.exchange-rate-trigger', loadExchangeRates);

  // FILTER CARDS CLICK HANDLER
  $('.filter-card').on('click', function() {
    $('.filter-card').removeClass('active-filter');
    $(this).addClass('active-filter');
    currentFilter = $(this).data('filter');
    $('#clearFilterBtn').toggle(currentFilter !== 'all');
    if (invoicesTable) invoicesTable.ajax.reload();
  });

  $('#clearFilterBtn').on('click', function() {
    $('.filter-card').removeClass('active-filter');
    $('.filter-card[data-filter="all"]').addClass('active-filter');
    currentFilter = 'all';
    $(this).hide();
    if (invoicesTable) invoicesTable.ajax.reload();
  });

  // EXPORT ALL FUNCTION
  window.exportAllInvoices = function() {
    console.log('📊 Exporting all invoices...');
    window.location.href = CONTROLLER_URL + '/crudData/exportAll';
    Swal.fire({
      icon: 'success', 
      title: 'Exporting...', 
      text: 'Your Excel file will download shortly', 
      timer: 1500, 
      showConfirmButton: false
    });
  };

  // CLIENT CHANGE
  $('#client_id').on('change', function() {
    const clientId = $(this).val();
    
    console.log('👤 Client changed:', clientId);
    
    $('#license_id').html('<option value="">-- Select --</option>');
    $('#mca_id').html('<option value="">Select MCA Reference</option>');
    $('#quotationSelector').html('<option value="">-- Select Client First --</option>');
    $('#quotation_id').val('');
    $('#invoice_ref').val('').attr('placeholder', 'Select Client First');
    clearMCAFields();
    clearQuotationItems();
    loadBanks(clientId);
    
    if (!clientId) return;
    
    $.ajax({
      url: CONTROLLER_URL + '/crudData/getClientDetails',
      method: 'GET',
      data: { client_id: clientId },
      dataType: 'json',
      success: function(res) {
        console.log('📋 Client details loaded:', res);
        if (res.success && res.data) {
          if (res.data.invoice_template) {
            $('#invoice_template').val(res.data.invoice_template);
            console.log('✅ Invoice Template set to:', res.data.invoice_template);
          }
        }
      },
      error: function(xhr, status, error) {
        console.error('❌ Error loading client details:', error);
      }
    });
    
    // Generate invoice ref
    $.ajax({
      url: CONTROLLER_URL + '/crudData/getNextInvoiceRefForClient',
      method: 'GET',
      data: { client_id: clientId },
      dataType: 'json',
      success: function(res) {
        console.log('📝 Invoice ref generated:', res);
        if (res.success) {
          $('#invoice_ref').val(res.invoice_ref).attr('placeholder', res.invoice_ref);
        }
      },
      error: function(xhr, status, error) {
        console.error('❌ Error generating invoice ref:', error);
      }
    });

    // Load licenses
    $.ajax({
      url: CONTROLLER_URL + '/crudData/getLicenses',
      method: 'GET',
      data: { client_id: clientId },
      dataType: 'json',
      success: function(res) {
        console.log('📜 Licenses loaded:', res);
        if (res.success && res.data && res.data.length > 0) {
          res.data.forEach(function(license) {
            const kindInfo = license.kind_short_name ? ` (${escapeHtml(license.kind_short_name)})` : '';
            $('#license_id').append(`<option value="${license.id}">${escapeHtml(license.license_number)}${kindInfo}</option>`);
          });
        } else {
          console.log('ℹ️ No import licenses found for this client');
        }
      },
      error: function(xhr, status, error) {
        console.error('❌ Error loading licenses:', error);
      }
    });

    // Load quotations
    $.ajax({
      url: CONTROLLER_URL + '/crudData/getAllQuotationsForClient',
      method: 'GET',
      data: { client_id: clientId },
      dataType: 'json',
      success: function(res) {
        console.log('📋 All quotations loaded:', res);
        
        if (res.success && res.data && res.data.length > 0) {
          let options = '<option value="">-- Select Quotation --</option>';
          res.data.forEach(function(quot) {
            options += `<option value="${quot.id}">${escapeHtml(quot.quotation_ref)}</option>`;
          });
          $('#quotationSelector').html(options);
          console.log('✅ Quotation dropdown populated with ' + res.data.length + ' quotations');
        } else {
          $('#quotationSelector').html('<option value="">-- No Quotations Found --</option>');
          console.log('ℹ️ No quotations found for client');
        }
      },
      error: function(xhr, status, error) {
        console.error('❌ Error loading quotations:', error);
        $('#quotationSelector').html('<option value="">-- Error Loading Quotations --</option>');
      }
    });
  });

  // LOAD BANKS FOR CLIENT
  function loadBanks(clientId) {
    if (!clientId) {
      $('#bankContainer').html('<div class="bank-alert"><i class="ti ti-info-circle me-1"></i>Select a client to load banks</div>');
      return;
    }

    console.log('🏦 Loading banks for client:', clientId);

    $.ajax({
      url: CONTROLLER_URL + '/crudData/getBanks',
      method: 'GET',
      data: { client_id: clientId },
      dataType: 'json',
      success: function(res) {
        console.log('🏦 Banks response:', res);
        
        if (res.success && res.data && res.data.length > 0) {
          let html = '';
          
          html += '<input type="hidden" name="bank_id" id="bank_id" value="' + res.data[0].id + '">';
          
          res.data.forEach(function(bank, index) {
            const bankName = escapeHtml(bank.bank_name || 'N/A');
            const accountName = escapeHtml(bank.account_name || 'N/A');
            const accountNumber = escapeHtml(bank.account_number || 'N/A');
            const swift = escapeHtml(bank.swift_code || '');
            const branch = escapeHtml(bank.branch || 'N/A');
            
            html += '<div class="bank-card" data-bank-id="' + bank.id + '">';
            html += '  <div class="bank-card-header">';
            html += '    <div class="bank-icon"><i class="ti ti-building-bank"></i></div>';
            html += '    <div class="bank-name">' + bankName + '</div>';
            html += '  </div>';
            html += '  <div class="bank-detail-row">';
            html += '    <span class="bank-detail-label">Account Name:</span>';
            html += '    <span class="bank-detail-value">' + accountName + '</span>';
            html += '  </div>';
            html += '  <div class="bank-detail-row">';
            html += '    <span class="bank-detail-label">Account #:</span>';
            html += '    <span class="bank-detail-value">' + accountNumber + '</span>';
            html += '  </div>';
            if (swift && swift !== '') {
              html += '  <div class="bank-detail-row">';
              html += '    <span class="bank-detail-label">SWIFT Code:</span>';
              html += '    <span class="bank-detail-value">' + swift + '</span>';
              html += '  </div>';
            }
            if (branch && branch !== 'N/A') {
              html += '  <div class="bank-detail-row">';
              html += '    <span class="bank-detail-label">Branch:</span>';
              html += '    <span class="bank-detail-value">' + branch + '</span>';
              html += '  </div>';
            }
            html += '</div>';
          });
          
          $('#bankContainer').html(html);
          console.log('✅ Banks loaded:', res.data.length);
        } else {
          $('#bankContainer').html('<div class="bank-alert"><i class="ti ti-alert-circle me-1"></i>No banks configured for this client</div>');
          console.log('ℹ️ No banks found for client');
        }
      },
      error: function(xhr, status, error) {
        console.error('❌ Error loading banks:', error);
        $('#bankContainer').html('<div class="bank-alert"><i class="ti ti-x-circle me-1"></i>Error loading banks</div>');
      }
    });
  }

  // QUOTATION SELECTOR CHANGE
  $('#quotationSelector').on('change', function() {
    const quotationId = $(this).val();
    const clientId = $('#client_id').val();
    
    $('#quotation_id').val(quotationId);
    
    if (!quotationId || !clientId) {
      clearQuotationItems();
      return;
    }

    console.log('🎯 Quotation selected:', quotationId);
    getQuotationItems(quotationId, clientId);
  });
  
  function getQuotationItems(quotationId, clientId){
    $.ajax({
      url: CONTROLLER_URL + '/crudData/getQuotationItems',
      method: 'GET',
      data: { quotation_id: quotationId, client_id: clientId },
      dataType: 'json',
      success: function(itemsRes) {
        console.log('📦 Quotation Items Response:', itemsRes);
        
        if (itemsRes.success) {
          quotationData = itemsRes.quotation;
          
          if (itemsRes.categorized_items && itemsRes.categorized_items.length > 0) {
            displayQuotationItemsByCategory(itemsRes.categorized_items, quotationData);
            
            const subTotal = parseFloat(quotationData.sub_total || 0);
            const vatAmount = parseFloat(quotationData.vat_amount || 0);
            const totalAmount = parseFloat(quotationData.total_amount || 0);
            updateSummaryTotals(subTotal, vatAmount, totalAmount);
          } else {
            $('#quotationItemsContainer').html('<div class="quotation-content"><p style="margin: 0; color: #e67e22;"><i class="ti ti-alert-triangle me-1"></i> No items found in quotation</p></div>');
          }
        } else {
          $('#quotationItemsContainer').html('<div class="quotation-content"><p style="margin: 0; color: #e74c3c;"><i class="ti ti-x-circle me-1"></i> ' + (itemsRes.message || 'Error loading quotation items') + '</p></div>');
        }
      },
      error: function(xhr, status, error) {
        console.error('❌ AJAX Error fetching quotation items:', error);
        $('#quotationItemsContainer').html('<div class="quotation-content"><p style="margin: 0; color: #e74c3c;"><i class="ti ti-x-circle me-1"></i> Error loading quotation items</p></div>');
      }
    });
  }
  
  // LICENSE CHANGE
  $('#license_id').on('change', function() {
    const clientId = $('#client_id').val();
    const licenseId = $(this).val();
    
    console.log('🔑 License changed:', licenseId);
    
    $('#mca_id').html('<option value="">Select MCA Reference</option>');
    clearMCAFields();
    
    if (!clientId || !licenseId) return;

    $.ajax({
      url: CONTROLLER_URL + '/crudData/getMCAReferences',
      method: 'GET',
      data: { client_id: clientId, license_id: licenseId },
      dataType: 'json',
      success: function(res) {
        console.log('📋 MCA references loaded:', res);
        if (res.success && res.data && res.data.length > 0) {
          res.data.forEach(function(mca) {
            $('#mca_id').append(`<option value="${mca.id}">${escapeHtml(mca.mca_ref)}</option>`);
          });
        }
      },
      error: function(xhr, status, error) {
        console.error('❌ Error loading MCA references:', error);
      }
    });
  });

  // MCA CHANGE
  $('#mca_id').on('change', function() {
    const mcaId = $(this).val();
    if (!mcaId) { 
      clearMCAFields();
      return; 
    }

    console.log('🎯 MCA selected, loading details for ID:', mcaId);

    $.ajax({
      url: CONTROLLER_URL + '/crudData/getMCADetails',
      method: 'GET',
      data: { mca_id: mcaId },
      dataType: 'json',
      success: function(res) {
        console.log('📦 MCA Details Response:', res);
        
        if (res.success && res.data) {
          const mca = res.data;
          
          $('#kind_id').val(mca.kind_id || '');
          $('#goods_type_id').val(mca.goods_type_id || '');
          $('#transport_mode_id').val(mca.transport_mode_id || '');
          $('#arsp').val(mca.arsp || '');
          $('#kind').val(escapeHtml(mca.kind_name || ''));
          $('#type_of_goods').val(escapeHtml(mca.type_of_goods_name || ''));
          $('#transport_mode').val(escapeHtml(mca.transport_mode_name || ''));
          
          $('#fob_usd').val(mca.fob || '');
          $('#fret_usd').val(mca.fret || '');
          $('#poids_kg').val(mca.weight || '');
          $('#produit').val(escapeHtml(mca.commodity || 'Default Commodity'));
          
          $('#facture_pfi_no').val(escapeHtml(mca.facture_pfi_no || ''));
          $('#po_ref').val(escapeHtml(mca.po_ref || ''));
          $('#bivac_inspection').val(escapeHtml(mca.bivac_inspection || ''));
          $('#declaration_no').val(escapeHtml(mca.declaration_no || ''));
          $('#declaration_date').val(mca.declaration_date || '');
          $('#liquidation_no').val(escapeHtml(mca.liquidation_no || ''));
          $('#liquidation_date').val(mca.liquidation_date || '');
          $('#quittance_no').val(escapeHtml(mca.quittance_no || ''));
          $('#quittance_date').val(mca.quittance_date || '');
          $('#dispatch_deliver_date').val(mca.dispatch_deliver_date || '');
          
          const transportModeId = parseInt(mca.transport_mode_id);
          $('#roadTransportSection, #railTransportSection, #airTransportSection').addClass('hidden-field');
          
          if (transportModeId === 1) {
            $('#roadTransportSection').removeClass('hidden-field');
            $('#horse').val(escapeHtml(mca.horse || ''));
            $('#trailer_1').val(escapeHtml(mca.trailer_1 || ''));
            $('#trailer_2').val(escapeHtml(mca.trailer_2 || ''));
            $('#container').val(escapeHtml(mca.container || ''));
          } 
          else if (transportModeId === 2) {
            $('#airTransportSection').removeClass('hidden-field');
            $('#airway_bill').val(escapeHtml(mca.airway_bill || ''));
            $('#airway_bill_weight').val(mca.airway_bill_weight || '');
            $('#container_air').val(escapeHtml(mca.container || ''));
          }
          else if (transportModeId === 3) {
            $('#railTransportSection').removeClass('hidden-field');
            $('#wagon').val(escapeHtml(mca.wagon || ''));
            $('#horse_rail').val(escapeHtml(mca.horse || ''));
            $('#trailer_1_rail').val(escapeHtml(mca.trailer_1 || ''));
            $('#trailer_2_rail').val(escapeHtml(mca.trailer_2 || ''));
            $('#container_rail').val(escapeHtml(mca.container || ''));
          }
          
          let clientId = $('#client_id').val();
          let quotationId = $('#quotationSelector option').eq(1).val();
          if (quotationId) {
            console.log('Quotation ID: ' + quotationId + ', Client ID: ' + clientId);
            $('#quotationSelector').val(quotationId);
            getQuotationItems(quotationId, clientId);
          }
          
          calculateFinancials();
        }
      },
      error: function(xhr, status, error) {
        console.error('❌ Error loading MCA details:', error);
      }
    });
  });

  // DISPLAY QUOTATION ITEMS BY CATEGORY
  function displayQuotationItemsByCategory(categorizedItems, quotation) {
    let html = '';
    quotationItemsData = [];
    hiddenCategoryIndices = [];
    
    if (!categorizedItems || categorizedItems.length === 0) {
      html = '<p style="margin: 20px 0; color: #e67e22; text-align: center;"><i class="ti ti-alert-triangle me-1"></i> No items found in quotation.</p>';
      $('#quotationItemsContainer').html(html);
      return;
    }
    
    categorizedItems.forEach(function(category, categoryIndex) {
      if (!category.items || category.items.length === 0) return;
      
      const isFirstCategory = categoryIndex === 0;
      
      html += '<div class="quotation-category-header">';
      html += '<span>' + escapeHtml(category.category_header || category.category_name || 'UNCATEGORIZED') + '</span>';
      
      if (isFirstCategory) {
        html += '<button type="button" class="category-toggle-btn" data-category-index="0">';
        html += '<i class="ti ti-chevron-up"></i> Hide';
        html += '</button>';
      }
      
      html += '</div>';
      
      html += '<div class="category-items-display" data-category-index="' + categoryIndex + '">';
      html += '<table class="quotation-items-table">';
      
      html += '<thead>';
      html += '<tr>';
      
      if (isFirstCategory) {
        html += '<th style="width: 20%;">DESCRIPTION</th>';
        html += '<th style="width: 10%;" class="text-center">UNIT</th>';
        html += '<th style="width: 12%;" class="text-center">CIF/Split</th>';
        html += '<th style="width: 8%;" class="text-center">%</th>';
        html += '<th style="width: 12%;" class="text-right">Rate/CDF</th>';
        html += '<th style="width: 12%;" class="text-right">VAT/CDF</th>';
        html += '<th style="width: 14%;" class="text-right">Total/CDF</th>';
        html += '<th style="width: 10%;" class="text-center">ACTION</th>';
      } else {
        html += '<th style="width: 22%;">DESCRIPTION</th>';
        html += '<th style="width: 10%;" class="text-center">UNIT</th>';
        html += '<th style="width: 10%;" class="text-center">QTY</th>';
        html += '<th style="width: 12%;" class="text-right">TAUX/USD</th>';
        html += '<th style="width: 10%;" class="text-center">CURRENCY</th>';
        html += '<th style="width: 8%;" class="text-center">TVA</th>';
        html += '<th style="width: 12%;" class="text-right">TVA/USD</th>';
        html += '<th style="width: 16%;" class="text-right">TOTAL EN USD</th>';
      }
      
      html += '</tr>';
      html += '</thead>';
      
      html += '<tbody>';
      
      category.items.forEach(function(item, itemIndex) {
        const globalItemIndex = quotationItemsData.length;
        quotationItemsData.push(item);
        
        const hasTVA = parseInt(item.has_tva || 0) === 1;
        const currency = escapeHtml(item.currency_short_name || 'USD');
        const quantity = parseFloat(item.quantity || 1);
        const tauxUsd = parseFloat(item.taux_usd || item.cost_usd || 0);
        const tvaUsd = parseFloat(item.tva_usd || 0);
        const totalUsd = parseFloat(item.total_usd || 0);
        
        const cifSplit = parseFloat(item.cif_split || 0);
        const percentage = parseFloat(item.percentage || 0);
        const rateCdf = parseFloat(item.rate_cdf || 0);
        const vatCdf = parseFloat(item.vat_cdf || 0);
        const totalCdf = parseFloat(item.total_cdf || 0);
        
        html += '<tr data-item-index="' + globalItemIndex + '" data-is-first-category="' + isFirstCategory + '">';
        html += '<td class="item-description">' + escapeHtml(item.item_name || 'N/A') + '</td>';
        html += '<td class="text-center item-unit">' + escapeHtml(item.unit_text || item.unit_name || 'Unit') + '</td>';
        
        if (isFirstCategory) {
          html += '<td class="text-center"><input type="number" class="item-input cif-input" data-field="cif_split" value="' + cifSplit.toFixed(2) + '" step="0.01" min="0" style="max-width: 100px;"></td>';
          html += '<td class="text-center"><input type="number" class="item-input percentage-input" data-field="percentage" value="' + percentage.toFixed(4) + '" step="0.0001" min="0" max="100" style="max-width: 80px;"></td>';
          html += '<td class="text-right"><input type="number" class="item-input rate-cdf-input" data-field="rate_cdf" value="' + rateCdf.toFixed(2) + '" step="0.01" min="0" style="max-width: 110px;"></td>';
          html += '<td class="text-right"><input type="number" class="item-input vat-cdf-input" data-field="vat_cdf" value="' + vatCdf.toFixed(2) + '" step="0.01" min="0" style="max-width: 110px;"></td>';
          html += '<td class="text-right"><input type="number" class="item-input total-cdf-input" data-field="total_cdf" value="' + totalCdf.toFixed(2) + '" step="0.01" min="0" style="max-width: 120px;"></td>';
          html += '<td class="text-center"><button type="button" class="delete-item-btn" data-item-index="' + globalItemIndex + '" title="Delete"><i class="ti ti-trash"></i></button></td>';
        } else {
          html += '<td class="text-center"><input type="number" class="item-input qty-input" data-field="quantity" value="' + quantity.toFixed(2) + '" step="0.01" min="0" style="max-width: 80px;"></td>';
          html += '<td class="text-right"><input type="number" class="item-input rate-input" data-field="taux_usd" value="' + tauxUsd.toFixed(2) + '" step="0.01" min="0" style="max-width: 100px;"></td>';
          html += '<td class="text-center item-currency">' + currency + '</td>';
          html += '<td class="text-center"><input type="checkbox" class="tva-display" ' + (hasTVA ? 'checked' : '') + ' disabled></td>';
          html += '<td class="text-right"><span class="item-tva-display">' + tvaUsd.toFixed(2) + '</span></td>';
          html += '<td class="text-right"><span class="item-total-display">' + totalUsd.toFixed(2) + '</span></td>';
        }
        
        html += '</tr>';
      });
      
      html += '</tbody>';
      html += '</table>';
      html += '</div>';
      html += '<div style="margin-bottom: 15px;"></div>';
    });
    
    if (html === '') {
      html = '<p style="margin: 20px 0; color: #e67e22; text-align: center;"><i class="ti ti-alert-triangle me-1"></i> No categories with items found.</p>';
    }
    
    $('#quotationItemsContainer').html(html);
    attachItemEventListeners();
    attachCategoryToggleListener();
    console.log('✅ All categories displayed. Total items:', quotationItemsData.length);
  }

  // ATTACH TOGGLE LISTENER FOR FIRST CATEGORY
  function attachCategoryToggleListener() {
    $(document).off('click', '.category-toggle-btn');
    $(document).on('click', '.category-toggle-btn', function() {
      const $btn = $(this);
      const categoryIndex = $btn.data('category-index');
      const $itemsContainer = $(`.category-items-display[data-category-index="${categoryIndex}"]`);
      
      if ($itemsContainer.hasClass('collapsed')) {
        $itemsContainer.removeClass('collapsed').slideDown(300);
        $btn.removeClass('collapsed').html('<i class="ti ti-chevron-up"></i> Hide');
        hiddenCategoryIndices = hiddenCategoryIndices.filter(i => i !== categoryIndex);
      } else {
        $itemsContainer.addClass('collapsed').slideUp(300);
        $btn.addClass('collapsed').html('<i class="ti ti-chevron-down"></i> Show');
        if (!hiddenCategoryIndices.includes(categoryIndex)) {
          hiddenCategoryIndices.push(categoryIndex);
        }
      }
      
      $('#hidden_categories').val(JSON.stringify(hiddenCategoryIndices));
      console.log('📁 Hidden categories:', hiddenCategoryIndices);
    });
  }

  // ATTACH EVENT LISTENERS TO EDITABLE ITEMS
  function attachItemEventListeners() {
    $(document).off('input change', '.item-input');
    $(document).on('input change', '.item-input', function() {
      const $row = $(this).closest('tr');
      const itemIndex = parseInt($row.data('item-index'));
      const isFirstCategory = $row.data('is-first-category') === true;
      const field = $(this).data('field');
      const value = parseFloat($(this).val()) || 0;
      
      if (quotationItemsData[itemIndex]) {
        if (field === 'quantity') {
          quotationItemsData[itemIndex].quantity = value;
        } else if (field === 'taux_usd') {
          quotationItemsData[itemIndex].taux_usd = value;
          quotationItemsData[itemIndex].cost_usd = value;
        } else if (field === 'cif_split') {
          quotationItemsData[itemIndex].cif_split = value;
        } else if (field === 'percentage') {
          quotationItemsData[itemIndex].percentage = value;
        } else if (field === 'rate_cdf') {
          quotationItemsData[itemIndex].rate_cdf = value;
        } else if (field === 'vat_cdf') {
          quotationItemsData[itemIndex].vat_cdf = value;
        } else if (field === 'total_cdf') {
          quotationItemsData[itemIndex].total_cdf = value;
          quotationItemsData[itemIndex].rate_cdf = value;
          $row.find('.rate-cdf-input').val(value.toFixed(2));
        }
        
        if (!isFirstCategory) {
          recalculateRowTotal($row, itemIndex);
        }
      }
    });
    
    $(document).off('click', '.delete-item-btn');
    $(document).on('click', '.delete-item-btn', function() {
      const itemIndex = parseInt($(this).data('item-index'));
      const $row = $(this).closest('tr');
      
      Swal.fire({
        title: 'Delete Item?',
        text: "Are you sure you want to remove this item?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, delete it!'
      }).then((result) => {
        if (result.isConfirmed) {
          $row.fadeOut(300, function() {
            $(this).remove();
            quotationItemsData.splice(itemIndex, 1);
            $('.quotation-items-table tbody tr').each(function(idx) {
              $(this).attr('data-item-index', idx);
              $(this).find('.delete-item-btn').attr('data-item-index', idx);
            });
            recalculateAllTotals();
            Swal.fire({ icon: 'success', title: 'Deleted!', timer: 1500, showConfirmButton: false });
          });
        }
      });
    });
  }

  // RECALCULATE ROW TOTAL
  function recalculateRowTotal($row, itemIndex) {
    const item = quotationItemsData[itemIndex];
    if (!item) return;
    
    const quantity = parseFloat(item.quantity || 1);
    const rate = parseFloat(item.taux_usd || item.cost_usd || 0);
    const hasTVA = parseInt(item.has_tva || 0) === 1;
    
    const subtotal = quantity * rate;
    let tvaAmount = 0;
    if (hasTVA) {
      tvaAmount = subtotal * 0.16;
    }
    const total = subtotal + tvaAmount;
    
    quotationItemsData[itemIndex].subtotal_usd = subtotal;
    quotationItemsData[itemIndex].tva_usd = tvaAmount;
    quotationItemsData[itemIndex].total_usd = total;
    
    $row.find('.item-tva-display').text(tvaAmount.toFixed(2));
    $row.find('.item-total-display').text(total.toFixed(2));
    
    recalculateAllTotals();
  }

  // RECALCULATE ALL TOTALS
  function recalculateAllTotals() {
    let totalExclTVA = 0;
    let totalTVA = 0;
    
    quotationItemsData.forEach(item => {
      const quantity = parseFloat(item.quantity || 1);
      const rate = parseFloat(item.taux_usd || item.cost_usd || 0);
      const subtotal = quantity * rate;
      const tva = parseFloat(item.tva_usd || 0);
      
      totalExclTVA += subtotal;
      totalTVA += tva;
    });
    
    const grandTotal = totalExclTVA + totalTVA;
    updateSummaryTotals(totalExclTVA, totalTVA, grandTotal);
  }

  function clearQuotationItems() {
    quotationItemsData = [];
    quotationData = null;
    hiddenCategoryIndices = [];
    $('#quotation_id').val('');
    $('#hidden_categories').val('[]');
    $('#quotationItemsContainer').html('<div class="quotation-content"><p style="margin: 0;"><i class="ti ti-info-circle me-1"></i> Select a quotation from the dropdown above</p></div>');
    updateSummaryTotals(0, 0, 0);
  }

  function clearMCAFields() {
    $('#kind_id, #goods_type_id, #transport_mode_id').val('');
    $('#kind, #type_of_goods, #transport_mode').val('');
    $('#fob_usd, #fret_usd, #assurance_usd, #autres_charges_usd, #poids_kg').val('');
    $('#horse, #trailer_1, #trailer_2, #container').val('');
    $('#wagon, #horse_rail, #trailer_1_rail, #trailer_2_rail, #container_rail').val('');
    $('#airway_bill, #airway_bill_weight, #container_air').val('');
    $('#facture_pfi_no, #po_ref, #bivac_inspection, #tariff_code_client').val('');
    $('#declaration_no, #declaration_date').val('');
    $('#liquidation_no, #liquidation_date').val('');
    $('#quittance_no, #quittance_date').val('');
    $('#dispatch_deliver_date').val('');
    $('#produit').val('Default Commodity');
    $('#roadTransportSection, #railTransportSection, #airTransportSection').addClass('hidden-field');
    calculateFinancials();
  }

  // FINANCIAL CALCULATIONS
  $(document).on('input change', '.financial-calc-trigger', calculateFinancials);

  function calculateFinancials() {
    const fob = sanitizeNumber($('#fob_usd').val());
    const fret = sanitizeNumber($('#fret_usd').val());
    const assurance = sanitizeNumber($('#assurance_usd').val());
    const autresCharges = sanitizeNumber($('#autres_charges_usd').val());
    const rateCDF = sanitizeNumber($('#rate_cdf_inv').val());
    
    const cifUSD = fob + fret + assurance + autresCharges;
    $('#cif_usd').val(cifUSD.toFixed(2));
    
    const cifCDF = cifUSD * rateCDF;
    $('#cif_cdf').val(cifCDF.toFixed(2));
    
    const totalDuty = cifCDF * 0.10;
    $('#total_duty_cdf').val(totalDuty.toFixed(0));
    
    recalculateAllTotals();
  }
  
  function updateSummaryTotals(subTotal, vatAmount, totalAmount) {
    const rateCDF = sanitizeNumber($('#rate_cdf_inv').val()) || 2500;
    const equivalentCDF = totalAmount * rateCDF;
    
    $('#totalExclTVA').text('$' + subTotal.toFixed(2));
    $('#tvaAmount').text('$' + vatAmount.toFixed(2));
    $('#grandTotal').text('$' + totalAmount.toFixed(2));
    $('#equivalentCDF').text(equivalentCDF.toFixed(2) + ' CDF');
  }

  // FORM VALIDATION
  function validateForm() {
    $('.form-control, .form-select').removeClass('is-invalid');
    $('.invalid-feedback').text('').hide();
    
    let errors = [];
    const required = [
      { id: 'client_id', label: 'Client' },
      { id: 'license_id', label: 'License Number' },
      { id: 'mca_id', label: 'MCA Reference' },
      { id: 'invoice_ref', label: 'Invoice Reference' }
    ];

    required.forEach(field => {
      if (!$(`#${field.id}`).val()) {
        $(`#${field.id}`).addClass('is-invalid');
        $(`#${field.id}_error`).text(`${field.label} is required`).show();
        errors.push(`${field.label} is required`);
      }
    });

    return { isValid: errors.length === 0, errors };
  }

  // FORM RESET
  function resetForm() {
    $('#invoiceForm')[0].reset();
    $('.form-control, .form-select').removeClass('is-invalid');
    $('.invalid-feedback').text('').hide();
    $('#invoice_id').val('');
    $('#formAction').val('insert');
    $('#formTitle').text('Add New Import Invoice');
    $('#submitBtnText').text('Save Invoice');
    $('#quotationSelector').html('<option value="">-- Select Client First --</option>');
    $('#quotation_id').val('');
    $('#bank_exchange_rate_id').val('');
    clearMCAFields();
    clearQuotationItems();
    $('#rate_cdf_inv, #rate_cdf_usd_bcc').val('2500.00').prop('readonly', false).removeClass('calculated-field');
    $('#exchange_bank_id').val('');
    $('#quittance_date').val('');
    $('#produit').val('Default Commodity');
    $('#invoice_ref').val('').attr('placeholder', 'Select Client First');
    $('#bankContainer').html('<div class="bank-alert"><i class="ti ti-info-circle me-1"></i>Select a client to load banks</div>');
    updateSummaryTotals(0, 0, 0);
    $('#collapseInvoice').collapse('hide');
  }

  // FORM SUBMIT
  $('#invoiceForm').on('submit', function (e) {
    e.preventDefault();
    
    const validation = validateForm();
    if (!validation.isValid) {
      Swal.fire({
        icon: 'error', 
        title: 'Validation Error', 
        html: '<ul style="text-align:left;"><li>' + validation.errors.join('</li><li>') + '</li></ul>'
      });
      $('#collapseInvoice').collapse('show');
      return;
    }

    const transportModeId = parseInt($('#transport_mode_id').val());
    if (transportModeId === 3) {
      $('input[name="horse"]').val($('#horse_rail').val());
      $('input[name="trailer_1"]').val($('#trailer_1_rail').val());
      $('input[name="trailer_2"]').val($('#trailer_2_rail').val());
      $('input[name="container"]').val($('#container_rail').val());
    } else if (transportModeId === 2) {
      $('input[name="container"]').val($('#container_air').val());
    }

    $('#quotation_items').val(JSON.stringify(quotationItemsData));
    $('#hidden_categories').val(JSON.stringify(hiddenCategoryIndices));

    const submitBtn = $('#submitBtn');
    const originalText = submitBtn.html();
    submitBtn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm me-1"></i> Saving...');

    const formData = new FormData(this);
    formData.set('csrf_token', csrfToken);

    $.ajax({
      url: CONTROLLER_URL + '/crudData/' + $('#formAction').val(),
      method: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function (res) {
        submitBtn.prop('disabled', false).html(originalText);
        
        if (res.success) {
          Swal.fire({ icon: 'success', title: 'Success!', text: res.message, timer: 1500, showConfirmButton: false });
          resetForm();
          if (invoicesTable) invoicesTable.ajax.reload(null, false);
          updateStatistics();
        } else {
          Swal.fire({ icon: 'error', title: 'Error!', html: res.message });
        }
      },
      error: function (xhr, status, error) {
        submitBtn.prop('disabled', false).html(originalText);
        Swal.fire({ icon: 'error', title: 'Error', text: 'Failed to save invoice' });
      }
    });
  });

  $('#cancelBtn').on('click', (e) => { e.preventDefault(); resetForm(); });

  // DATATABLE INITIALIZATION
  function initDataTable() {
    if ($.fn.DataTable.isDataTable('#invoicesTable')) {
      $('#invoicesTable').DataTable().destroy();
    }

    invoicesTable = $('#invoicesTable').DataTable({
      processing: true,
      serverSide: true,
      scrollX: true,
      searching: false,
      ajax: { 
        url: CONTROLLER_URL + '/crudData/listing',
        type: 'GET',
        data: function(d) { 
          d.filter = currentFilter;
          d.search = { value: $('#customSearchBox').val() };
        },
        dataSrc: function(json) {
          return json.data || [];
        }
      },
      columns: [
        { data: 'id' },
        { data: 'invoice_ref', render: data => escapeHtml(data || '') },
        { data: 'client_name', render: data => escapeHtml(data || '') },
        { data: 'mca_ref', render: data => escapeHtml(data || '') },
        { data: 'cif_usd', render: data => data ? '$' + parseFloat(data).toFixed(2) : '$0.00' },
        { data: 'total_duty_cdf', render: data => data ? parseFloat(data).toFixed(0) + ' CDF' : '0 CDF' },
        { 
          data: 'validated',
          render: (data, type, row) => {
            const validated = parseInt(data || 0);
            if (validated === 0) {
              return '<span class="validation-badge validation-not-validated">NOT VALIDATED</span>';
            } else if (validated === 1) {
              return '<span class="validation-badge validation-validated">✓ VALIDATED</span>';
            } else if (validated === 2) {
              return '<span class="validation-badge validation-dgi-verified">DGI VERIFIED</span>';
            }
            return '<span class="validation-badge validation-not-validated">UNKNOWN</span>';
          }
        },
        { 
          data: null, 
          orderable: false, 
          searchable: false, 
          render: (data, type, row) => {
            const validated = parseInt(row.validated || 0);
            let html = `
              <button class="btn btn-sm btn-pdf pdfBtn" data-id="${row.id}" title="View PDF">
                <i class="ti ti-file-type-pdf"></i>
              </button>
              <button class="btn btn-sm btn-primary editBtn" data-id="${row.id}" title="Edit">
                <i class="ti ti-edit"></i>
              </button>`;
            
            if (validated === 0) {
              html += `
              <button class="btn btn-sm btn-validate validateBtn" data-id="${row.id}" title="Validate Invoice">
                <i class="ti ti-circle-check"></i>
              </button>`;
            }
            
            if (validated === 1) {
              html += `
              <button class="btn btn-sm btn-dgi dgiBtn" data-id="${row.id}" title="Mark as DGI Verified">
                <i class="ti ti-file-check"></i>
              </button>`;
            }
            
            html += `
              <button class="btn btn-sm btn-export exportBtn" data-id="${row.id}" title="Export to Excel">
                <i class="ti ti-file-spreadsheet"></i>
              </button>
              <button class="btn btn-sm btn-danger deleteBtn" data-id="${row.id}" title="Delete">
                <i class="ti ti-trash"></i>
              </button>
            `;
            return html;
          }
        }
      ],
      order: [[0, 'desc']],
      pageLength: 25,
      dom: 'rt<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
      drawCallback: function() { updateStatistics(); }
    });

    $('#customSearchBox').on('keyup', function() {
      invoicesTable.ajax.reload();
    });
  }

  // STATISTICS UPDATE
  function updateStatistics() {
    $.ajax({
      url: CONTROLLER_URL + '/crudData/statistics',
      method: 'GET',
      dataType: 'json',
      success: function(res) {
        if (res.success && res.data) {
          $('#totalInvoices').text(res.data.total_invoices || 0);
          $('#totalValidated').text(res.data.validated_invoices || 0);
          $('#totalNotValidated').text(res.data.not_validated_invoices || 0);
          $('#totalDGIVerified').text(res.data.dgi_verified_invoices || 0);
        }
      }
    });
  }

  // ACTION BUTTONS
  $(document).on('click', '.pdfBtn', function() {
    const id = $(this).data('id');
    if (!id) return;
    window.open(CONTROLLER_URL + '/crudData/viewPDF?id=' + id, '_blank');
  });
  
  $(document).on('click', '.exportBtn', function() {
    const id = $(this).data('id');
    if (!id) return;
    window.location.href = CONTROLLER_URL + '/crudData/exportInvoice?id=' + id;
    Swal.fire({icon: 'success', title: 'Exporting...', timer: 1500, showConfirmButton: false});
  });

  // VALIDATE BUTTON HANDLER
  $(document).on('click', '.validateBtn', function() {
    const id = $(this).data('id');
    if (!id) return;
    
    Swal.fire({
      title: 'Validate Invoice?',
      html: 'This will remove the watermark from the PDF.<br><br>Are you sure you want to validate this invoice?',
      icon: 'question',
      showCancelButton: true,
      confirmButtonColor: '#17a2b8',
      cancelButtonColor: '#6c757d',
      confirmButtonText: '<i class="ti ti-circle-check me-1"></i> Yes, validate it!',
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: CONTROLLER_URL + '/crudData/validateInvoice',
          method: 'POST',
          data: { id: id, csrf_token: csrfToken },
          dataType: 'json',
          success: function(res) {
            if (res.success) {
              Swal.fire({
                icon: 'success', 
                title: 'Validated!', 
                text: res.message, 
                timer: 2000, 
                showConfirmButton: false
              });
              invoicesTable.ajax.reload(null, false);
              updateStatistics();
            } else {
              Swal.fire('Error', res.message, 'error');
            }
          },
          error: function(xhr, status, error) {
            Swal.fire('Error', 'Failed to validate invoice', 'error');
          }
        });
      }
    });
  });

  // DGI BUTTON HANDLER
  $(document).on('click', '.dgiBtn', function() {
    const id = $(this).data('id');
    if (!id) return;
    
    Swal.fire({
      title: 'Mark as DGI Verified?',
      html: 'This will add a <span style="color: #800000; font-weight: bold;">"NOT Valid"</span> watermark in maroon color.<br><br>Are you sure?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#800000',
      cancelButtonColor: '#6c757d',
      confirmButtonText: '<i class="ti ti-file-check me-1"></i> Yes, mark it!',
      cancelButtonText: 'Cancel'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: CONTROLLER_URL + '/crudData/markDGI',
          method: 'POST',
          data: { id: id, csrf_token: csrfToken },
          dataType: 'json',
          success: function(res) {
            if (res.success) {
              Swal.fire({
                icon: 'success', 
                title: 'Marked as DGI Verified!', 
                text: res.message, 
                timer: 2000, 
                showConfirmButton: false
              });
              invoicesTable.ajax.reload(null, false);
              updateStatistics();
            } else {
              Swal.fire('Error', res.message, 'error');
            }
          },
          error: function(xhr, status, error) {
            Swal.fire('Error', 'Failed to mark invoice for DGI', 'error');
          }
        });
      }
    });
  });

  $(document).on('click', '.editBtn', function() {
    const id = $(this).data('id');
    $.ajax({
      url: CONTROLLER_URL + '/crudData/getInvoice',
      method: 'GET',
      data: { id: id },
      dataType: 'json',
      success: function(res) {
        if (res.success && res.data) {
          const inv = res.data;
          
          $('#invoice_id').val(inv.id);
          $('#formAction').val('update');
          $('#formTitle').text('Edit Import Invoice');
          $('#submitBtnText').text('Update Invoice');
          
          $('#client_id').val(inv.client_id).trigger('change');
          
          setTimeout(() => {
            $('#license_id').val(inv.license_id).trigger('change');
            
            setTimeout(() => {
              $('#mca_id').val(inv.mca_id).trigger('change');
              
              setTimeout(() => {
                if (inv.quotation_id) {
                  $('#quotation_id').val(inv.quotation_id);
                  $('#quotationSelector').val(inv.quotation_id).trigger('change');
                }
                
                setTimeout(() => {
                  Object.keys(inv).forEach(key => {
                    const $field = $(`#${key}`);
                    if ($field.length && inv[key] !== null) {
                      $field.val(inv[key]);
                    }
                  });
                  
                  // Set exchange bank
                  if (inv.exchange_bank_id) {
                    $('#exchange_bank_id').val(inv.exchange_bank_id);
                  }
                  
                  if (res.items && res.items.length > 0) {
                    quotationItemsData = res.items;
                  }
                  
                  if (inv.hidden_categories) {
                    try {
                      hiddenCategoryIndices = JSON.parse(inv.hidden_categories);
                      $('#hidden_categories').val(inv.hidden_categories);
                    } catch(e) {
                      hiddenCategoryIndices = [];
                      $('#hidden_categories').val('[]');
                    }
                  }
                  
                  calculateFinancials();
                  $('#collapseInvoice').collapse('show');
                  $('html, body').animate({ scrollTop: $('#invoiceForm').offset().top - 100 }, 500);
                }, 1500);
              }, 1000);
            }, 800);
          }, 500);
        }
      }
    });
  });

  $(document).on('click', '.deleteBtn', function() {
    const id = $(this).data('id');
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: CONTROLLER_URL + '/crudData/deletion',
          method: 'POST',
          data: { id: id, csrf_token: csrfToken },
          dataType: 'json',
          success: function(res) {
            if (res.success) {
              Swal.fire({icon: 'success', title: 'Deleted!', text: res.message, timer: 1500, showConfirmButton: false});
              invoicesTable.ajax.reload(null, false);
              updateStatistics();
            } else {
              Swal.fire('Error', res.message, 'error');
            }
          }
        });
      }
    });
  });

  // INITIALIZE
  initDataTable();
  updateStatistics();
  $('#rate_cdf_inv, #rate_cdf_usd_bcc').val('2500.00');
  $('#produit').val('Default Commodity');
  updateSummaryTotals(0, 0, 0);
  $('.filter-card[data-filter="all"]').addClass('active-filter');
  
  console.log('✅ Import Invoice System Ready! (Enhanced with Exchange Rates)');
});
</script>