<?php 
if (file_exists(VIEW_PATH . 'layouts/partials/header.php')) {
  include(VIEW_PATH . 'layouts/partials/header.php'); 
}
?>

<link href="<?= BASE_URL ?>/assets/pages/css/payment_request_styles.css" rel="stylesheet" type="text/css">

<style>
    .dataTables_wrapper .dataTables_info {
        float: left;
    }

    .dataTables_wrapper .dataTables_paginate {
        float: right;
        text-align: right;
    }

    /* Compact Design */
    .page-content {
        padding: 15px 0;
    }

    .card {
        margin-bottom: 15px;
    }

    .card-header {
        padding: 12px 20px;
    }

    .card-header h4 {
        font-size: 1.1rem;
        margin: 0;
    }

    .accordion-button {
        padding: 12px 20px;
        font-size: 1rem;
    }

    .accordion-button.collapsed {
        background-color: #fff;
    }

    .accordion-body {
        padding: 20px;
    }

    .form-label {
        font-weight: 500;
        margin-bottom: 6px;
        font-size: 0.875rem;
        display: block;
        color: #666;
    }

    .form-control,
    .form-select {
        height: 38px;
        padding: 8px 12px;
        font-size: 0.875rem;
        border: 1px solid #dee2e6;
        border-radius: 4px;
    }

    .form-control:focus,
    .form-select:focus {
        border-color: #86b7fe;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.15);
    }

    textarea.form-control {
        height: auto;
        padding: 10px 12px;
        resize: none;
    }

    .input-group-text {
        padding: 8px 12px;
        font-size: 0.875rem;
        background: #f8f9fa;
        border: 1px solid #dee2e6;
    }

    .section-header {
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 2px solid #e9ecef;
        color: #495057;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .section-header i {
        font-size: 1.1rem;
        color: #6c757d;
    }

    /* Grid Layout - 5 COLUMNS */
    .form-grid {
        display: grid;
        grid-template-columns: repeat(5, 1fr);
        gap: 15px;
        margin-bottom: 15px;
    }

    .form-grid-4 {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 15px;
        margin-bottom: 15px;
    }

    .form-grid-motif-docs {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 15px;
        margin-bottom: 15px;
        margin-top: 20px;
    }

    .motif-column {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .documents-column {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 15px;
        align-content: start;
    }

    @media (max-width: 1400px) {
        .form-grid {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    @media (max-width: 1200px) {
        .form-grid {
            grid-template-columns: repeat(3, 1fr);
        }

        .form-grid-4 {
            grid-template-columns: repeat(2, 1fr);
        }

        .form-grid-motif-docs {
            grid-template-columns: 1fr;
        }

        .documents-column {
            grid-template-columns: 1fr 1fr;
        }
    }

    @media (max-width: 768px) {
        .form-grid,
        .form-grid-4 {
            grid-template-columns: 1fr;
        }

        .documents-column {
            grid-template-columns: 1fr;
        }
    }

    /* STATUS CARDS - CLICKABLE FILTERS */
    .stats-cards {
        display: grid;
        grid-template-columns: repeat(6, 1fr);
        gap: 15px;
        margin-bottom: 25px;
    }

    @media (max-width: 1400px) {
        .stats-cards {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    @media (max-width: 768px) {
        .stats-cards {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 480px) {
        .stats-cards {
            grid-template-columns: 1fr;
        }
    }

    .stat-card {
        background: white;
        border-radius: 10px;
        padding: 20px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.07);
        border-left: 4px solid;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
        cursor: pointer;
    }

    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 80px;
        height: 80px;
        opacity: 0.1;
        border-radius: 50%;
        transform: translate(30%, -30%);
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 12px rgba(0,0,0,0.15);
    }

    .stat-card.active {
        box-shadow: 0 6px 15px rgba(0,0,0,0.2);
        transform: translateY(-3px);
        border-left-width: 6px;
    }

    .stat-card.active::after {
        content: '✓';
        position: absolute;
        top: 10px;
        right: 10px;
        width: 25px;
        height: 25px;
        background: rgba(0,0,0,0.1);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        font-weight: bold;
    }

    .stat-card.total {
        border-left-color: #0d6efd;
        background: linear-gradient(135deg, #ffffff 0%, #f0f7ff 100%);
    }

    .stat-card.total::before {
        background: #0d6efd;
    }

    .stat-card.total.active {
        background: linear-gradient(135deg, #e7f1ff 0%, #cce5ff 100%);
    }

    .stat-card.waiting-dept {
        border-left-color: #ffc107;
        background: linear-gradient(135deg, #ffffff 0%, #fffbf0 100%);
    }

    .stat-card.waiting-dept::before {
        background: #ffc107;
    }

    .stat-card.waiting-dept.active {
        background: linear-gradient(135deg, #fff8e1 0%, #ffecb3 100%);
    }

    .stat-card.waiting-finance {
        border-left-color: #17a2b8;
        background: linear-gradient(135deg, #ffffff 0%, #f0fbfc 100%);
    }

    .stat-card.waiting-finance::before {
        background: #17a2b8;
    }

    .stat-card.waiting-finance.active {
        background: linear-gradient(135deg, #e0f7fa 0%, #b2ebf2 100%);
    }

    .stat-card.waiting-mgmt {
        border-left-color: #6f42c1;
        background: linear-gradient(135deg, #ffffff 0%, #f7f3fc 100%);
    }

    .stat-card.waiting-mgmt::before {
        background: #6f42c1;
    }

    .stat-card.waiting-mgmt.active {
        background: linear-gradient(135deg, #f3e5f5 0%, #e1bee7 100%);
    }

    .stat-card.paid {
        border-left-color: #28a745;
        background: linear-gradient(135deg, #ffffff 0%, #f0fdf4 100%);
    }

    .stat-card.paid::before {
        background: #28a745;
    }

    .stat-card.paid.active {
        background: linear-gradient(135deg, #e8f5e9 0%, #c8e6c9 100%);
    }

    .stat-card.rejected {
        border-left-color: #dc3545;
        background: linear-gradient(135deg, #ffffff 0%, #fff5f5 100%);
    }

    .stat-card.rejected::before {
        background: #dc3545;
    }

    .stat-card.rejected.active {
        background: linear-gradient(135deg, #ffebee 0%, #ffcdd2 100%);
    }

    .stat-card-title {
        font-size: 0.85rem;
        color: #6c757d;
        font-weight: 600;
        margin-bottom: 12px;
        display: flex;
        align-items: center;
        gap: 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .stat-card-value {
        font-size: 2.5rem;
        font-weight: 700;
        color: #212529;
        line-height: 1;
    }

    .stat-card-icon {
        font-size: 1.3rem;
    }

    /* Compact MCA Section */
    .mca-wrapper {
        max-width: 100%;
    }

    .mca-toolbar {
        background: #f8f9fa;
        padding: 10px 12px;
        border-radius: 6px;
        margin-bottom: 12px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 8px;
    }

    .mca-toolbar-left {
        display: flex;
        gap: 6px;
        align-items: center;
        flex-wrap: wrap;
    }

    .mca-toolbar input[type="number"] {
        width: 70px;
        height: 32px;
        font-size: 0.85rem;
        padding: 6px 8px;
    }

    .mca-toolbar .btn {
        height: 32px;
        padding: 6px 12px;
        font-size: 0.8rem;
    }

    .mca-toolbar .btn i {
        font-size: 0.9rem;
        margin-right: 3px;
    }

    .mca-total {
        font-size: 0.9rem;
        font-weight: 600;
        color: #495057;
    }

    .mca-total span {
        color: #0d6efd;
        font-size: 1.1rem;
    }

    /* Small Compact Table */
    .table-mca-small {
        font-size: 0.85rem;
        margin-bottom: 0;
    }

    .table-mca-small thead th {
        padding: 8px 10px;
        background: #f8f9fa;
        font-weight: 600;
        border-bottom: 2px solid #dee2e6;
        font-size: 0.85rem;
    }

    .table-mca-small tbody td {
        padding: 6px 10px;
        vertical-align: middle;
    }

    .table-mca-small input {
        height: 32px;
        padding: 6px 10px;
        font-size: 0.85rem;
    }

    .table-mca-small .btn-sm {
        padding: 4px 8px;
        font-size: 0.8rem;
    }

    /* Buttons - SMALLER SIZE */
    .btn {
        padding: 6px 12px;
        font-size: 0.8rem;
        border-radius: 4px;
    }

    .btn-xs {
        padding: 3px 8px;
        font-size: 0.75rem;
    }

    .btn i {
        margin-right: 3px;
        font-size: 0.85rem;
        pointer-events: none;
    }

    .action-footer {
        background: #f8f9fa;
        padding: 12px 20px;
        border-top: 1px solid #dee2e6;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .progress {
        height: 3px;
        border-radius: 0;
    }

    .text-danger {
        color: #dc3545;
    }

    small.text-muted {
        font-size: 0.75rem;
        color: #6c757d;
        display: block;
        margin-top: 4px;
    }

    .invalid-feedback {
        font-size: 0.8rem;
    }

    .form-file-label {
        display: block;
        font-size: 0.875rem;
        margin-bottom: 6px;
        font-weight: 500;
        color: #666;
    }

    /* File Link Styling */
    .file-link {
        display: inline-block;
        padding: 5px 10px;
        background: #e7f3ff;
        border: 1px solid #b3d9ff;
        border-radius: 4px;
        color: #0066cc;
        text-decoration: none;
        font-size: 0.85rem;
        margin-right: 5px;
        margin-bottom: 5px;
    }

    .file-link:hover {
        background: #cce5ff;
        color: #004d99;
    }

    .file-link i {
        margin-right: 3px;
    }

    /* INCREASED MODAL HEIGHT */
    .modal-body-scrollable {
        max-height: 70vh;
        overflow-y: auto;
    }

    .info-table {
        font-size: 0.85rem;
    }

    .info-table th {
        width: 40%;
        background: #f8f9fa;
        font-weight: 600;
        padding: 6px 10px;
    }

    .info-table td {
        padding: 6px 10px;
    }

    /* APPROVAL TIMELINE TABLE */
    .timeline-table {
        font-size: 0.85rem;
    }

    .timeline-table th {
        width: 25%;
        background: #f8f9fa;
        font-weight: 600;
        padding: 8px 10px;
        text-align: center;
    }

    .timeline-table td {
        padding: 8px 10px;
        text-align: center;
    }

    .timeline-user {
        font-size: 0.75rem;
        color: #6c757d;
        display: block;
        margin-top: 3px;
    }

    .timeline-time {
        font-size: 0.7rem;
        color: #999;
        display: block;
        margin-top: 2px;
    }

    /* MCA MODAL SEARCH */
    .mca-search-box {
        margin-bottom: 15px;
        padding: 10px;
        background: #f8f9fa;
        border-radius: 5px;
    }

    .mca-search-box input {
        width: 100%;
        padding: 8px 12px;
        border: 1px solid #dee2e6;
        border-radius: 4px;
        font-size: 0.9rem;
    }

    /* UPDATED MCA MODAL SIZE AND CHECKBOX STYLING */
    .modal-mca-small {
        max-width: 700px;
    }

    .mca-refs-list {
        max-height: 450px;
        overflow-y: auto;
        padding: 5px;
    }

    /* IMPROVED CHECKBOX VISIBILITY */
    .mca-ref-item {
        padding: 14px 15px;
        border-bottom: 1px solid #e9ecef;
        transition: background 0.2s;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .mca-ref-item:hover {
        background: #f8f9fa;
    }

    .mca-ref-item:last-child {
        border-bottom: none;
    }

    /* Make checkbox larger and more visible */
    .mca-ref-check {
        width: 20px;
        height: 20px;
        cursor: pointer;
        flex-shrink: 0;
        margin-top: 0;
    }

    .mca-ref-item .form-check-label {
        cursor: pointer;
        margin-bottom: 0;
        flex-grow: 1;
        font-size: 0.95rem;
        color: #333;
    }

/* PRINT STYLES - UPDATED FOR SINGLE PAGE */
@media print {
    body * {
        visibility: hidden;
    }
    .print-section, .print-section * {
        visibility: visible;
    }
    .print-section {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        padding: 20px;
    }
    .no-print {
        display: none !important;
    }
    
    /* Prevent page breaks */
    h6, table, .print-header {
        page-break-inside: avoid;
    }
    
    /* Ensure single page */
    @page {
        size: A4;
        margin: 15mm;
    }
}

.print-header {
    text-align: center;
    margin-bottom: 20px;
    border-bottom: 3px solid #0d6efd;
    padding-bottom: 15px;
}

.print-header h2 {
    margin: 0;
    color: #0d6efd;
    font-size: 1.8rem;
}

.print-header p {
    margin: 5px 0 0 0;
    color: #6c757d;
    font-size: 0.9rem;
}

.print-table {
    width: 100%;
    margin-bottom: 15px;
    border-collapse: collapse;
    font-size: 0.9rem;
}

.print-table th,
.print-table td {
    padding: 8px;
    border: 1px solid #dee2e6;
    text-align: left;
}

.print-table th {
    background: #f8f9fa;
    font-weight: 600;
    width: 30%;
}

.print-table thead th {
    background: #e9ecef;
    font-weight: 700;
    text-align: center;
}
</style>

<div class="page-content">
    <div class="container-fluid">
        
        <!-- STATUS CARDS - CLICKABLE FILTERS -->
        <div class="stats-cards">
            <div class="stat-card total filter-card active" data-filter="all">
                <div class="stat-card-title">
                    <i class="ti ti-file-invoice stat-card-icon"></i>
                    Total Requests
                </div>
                <div class="stat-card-value" id="totalCount">0</div>
            </div>

            <div class="stat-card waiting-dept filter-card" data-filter="waiting_dept">
                <div class="stat-card-title">
                    <i class="ti ti-hourglass-empty stat-card-icon"></i>
                    Waiting Dept
                </div>
                <div class="stat-card-value" id="waitingDeptCount">0</div>
            </div>

            <div class="stat-card waiting-finance filter-card" data-filter="waiting_finance">
                <div class="stat-card-title">
                    <i class="ti ti-calculator stat-card-icon"></i>
                    Waiting Finance
                </div>
                <div class="stat-card-value" id="waitingFinanceCount">0</div>
            </div>

            <div class="stat-card waiting-mgmt filter-card" data-filter="waiting_mgmt">
                <div class="stat-card-title">
                    <i class="ti ti-user-check stat-card-icon"></i>
                    Waiting Mgmt
                </div>
                <div class="stat-card-value" id="waitingMgmtCount">0</div>
            </div>

            <div class="stat-card paid filter-card" data-filter="paid">
                <div class="stat-card-title">
                    <i class="ti ti-circle-check stat-card-icon"></i>
                    Paid
                </div>
                <div class="stat-card-value" id="paidCount">0</div>
            </div>

            <div class="stat-card rejected filter-card" data-filter="rejected">
                <div class="stat-card-title">
                    <i class="ti ti-x-circle stat-card-icon"></i>
                    Rejected
                </div>
                <div class="stat-card-value" id="rejectedCount">0</div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <!-- Payment Request Form Card -->
                <div class="card shadow-sm">
                    <div class="card-header border-bottom d-flex align-items-center justify-content-between">
                        <h4>
                            <i class="ti ti-file-invoice-dollar me-2"></i>
                            <span id="formTitle">New Payment Request</span>
                        </h4>
                        <div>
                            <button type="button" class="btn btn-sm btn-success" id="exportToExcelBtn">
                                <i class="ti ti-file-excel"></i> Export to Excel
                            </button>
                            <button type="button" class="btn btn-sm btn-secondary" id="resetFormBtn" style="display:none;">
                                <i class="ti ti-plus"></i> Add New
                            </button>
                        </div>
                    </div>

                    <!-- Progress Indicator -->
                    <div class="progress">
                        <div class="progress-bar bg-primary" id="formProgress" role="progressbar" style="width: 50%">
                        </div>
                    </div>

                    <form id="paymentRequestForm" method="post" enctype="multipart/form-data" novalidate>
                        <input type="hidden" name="action" id="formAction" value="insert">
                        <input type="hidden" name="payment_id" id="recordId" value="">

                        <!-- Single Accordion Container -->
                        <div class="accordion" id="paymentAccordion">
                            <div class="accordion-item border-0">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#paymentFormContent">
                                        <i class="ti ti-file-invoice me-2"></i>
                                        Payment Request Details
                                    </button>
                                </h2>

                                <div id="paymentFormContent" class="accordion-collapse collapse"
                                    data-bs-parent="#paymentAccordion">
                                    <div class="accordion-body">

                                        <!-- BASIC INFORMATION SECTION -->
                                        <div class="section-header">
                                            <i class="ti ti-info-circle"></i>
                                            <span>Basic Information</span>
                                        </div>

                                        <!-- Row 1: 5 Fields -->
                                        <div class="form-grid">
                                            <!-- Department -->
                                            <div>
                                                <label class="form-label">Department <span class="text-danger">*</span></label>
                                                <select name="department" id="department" class="form-select" required>
                                                    <option value="">Select</option>
                                                    <?php foreach ($dept as $p): ?>
                                                    <option value="<?= $p['id'] ?>">
                                                        <?= htmlspecialchars($p['department_name']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <div class="invalid-feedback">Required</div>
                                            </div>

                                            <!-- Location -->
                                            <div>
                                                <label class="form-label">Location <span class="text-danger">*</span></label>
                                                <select name="location" id="location" class="form-select" required>
                                                    <option value="">Select</option>
                                                    <?php foreach ($loc as $p): ?>
                                                    <option value="<?= $p['id'] ?>">
                                                        <?= htmlspecialchars($p['main_location_name']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <div class="invalid-feedback">Required</div>
                                            </div>

                                            <!-- Beneficiary -->
                                            <div>
                                                <label class="form-label">Beneficiary <span class="text-danger">*</span></label>
                                                <input type="text" name="beneficiary" id="beneficiary"
                                                    class="form-control" required minlength="2" maxlength="200"
                                                    placeholder="Enter name">
                                                <div class="invalid-feedback">Required</div>
                                            </div>

                                            <!-- Client -->
                                            <div>
                                                <label class="form-label">Client <span class="text-danger">*</span></label>
                                                <select name="client_id" id="client_id" class="form-select" required>
                                                    <option value="">Select</option>
                                                    <?php foreach ($client as $p): ?>
                                                    <option value="<?= $p['id'] ?>">
                                                        <?= htmlspecialchars($p['short_name']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <div class="invalid-feedback">Required</div>
                                            </div>

                                            <!-- Payment for -->
                                            <div>
                                                <label class="form-label">Payment For <span class="text-danger">*</span></label>
                                                <select name="pay_for" id="pay_for" class="form-select" required>
                                                    <option value="">Select</option>
                                                    <option value="0">Import Tracking</option>
                                                    <option value="1">Export Tracking</option>
                                                    <option value="2">Local Tracking</option>
                                                    <option value="3">Other</option>
                                                    <option value="4">Pre Payment</option>
                                                </select>
                                                <div class="invalid-feedback">Required</div>
                                            </div>
                                        </div>

                                        <!-- Row 2: 5 Fields -->
                                        <div class="form-grid">
                                            <!-- Payment Type -->
                                            <div>
                                                <label class="form-label">Payment Type <span class="text-danger">*</span></label>
                                                <select name="payment_type" id="payment_type" class="form-select" required>
                                                    <option value="">Select</option>
                                                    <option value="Bank">Bank</option>
                                                    <option value="Cash">Cash</option>
                                                </select>
                                                <div class="invalid-feedback">Required</div>
                                            </div>

                                            <!-- Currency -->
                                            <div>
                                                <label class="form-label">Currency <span class="text-danger">*</span></label>
                                                <select name="currency" id="currency" class="form-select" required>
                                                    <option value="">Select</option>
                                                    <?php foreach ($currency as $p): ?>
                                                    <option value="<?= $p['id'] ?>">
                                                        <?= htmlspecialchars($p['currency_short_name']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <div class="invalid-feedback">Required</div>
                                            </div>

                                            <!-- Amount -->
                                            <div>
                                                <label class="form-label">Amount <span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input type="number" name="amount" id="amount" class="form-control"
                                                        step="0.01" min="0" required placeholder="0.00">
                                                </div>
                                                <div class="invalid-feedback">Required</div>
                                            </div>

                                            <!-- Expense Type -->
                                            <div>
                                                <label class="form-label">Expense Type <span class="text-danger">*</span></label>
                                                <select name="expense_type" id="expense_type" class="form-select" required>
                                                    <option value="">Select</option>
                                                    <?php foreach ($expense as $p): ?>
                                                    <option value="<?= $p['id'] ?>">
                                                        <?= htmlspecialchars($p['expense_type_name']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <div class="invalid-feedback">Required</div>
                                            </div>

                                            <!-- Requestee -->
                                            <div>
                                                <label class="form-label">Requestee <span class="text-danger">*</span></label>
                                                <input type="text" name="requestee" id="requestee"
                                                    class="form-control" required minlength="2" maxlength="200" readonly 
                                                    value="<?php echo $_SESSION['user_data']['fullname']; ?>"
                                                    placeholder="Enter name">
                                                <div class="invalid-feedback">Required</div>
                                            </div>
                                        </div>

                                        <!-- MCA REFERENCES SECTION -->
                                        <div style="margin-top: 30px;">
                                            <div class="section-header">
                                                <i class="ti ti-file-text"></i>
                                                <span>MCA References</span>
                                            </div>

                                            <div class="mca-wrapper">
                                                <div class="mca-toolbar">
                                                    <div class="mca-toolbar-left">
                                                        <input type="number" id="num_mca_refs" class="form-control"
                                                            min="0" max="50" value="0" placeholder="0-50">
                                                        <button type="button" class="btn btn-primary"
                                                            id="add_mca_refs_btn">
                                                            <i class="ti ti-plus"></i> Add
                                                        </button>
                                                        <button type="button" class="btn btn-success"
                                                            id="selectMcaRefsBtn">
                                                            <i class="ti ti-list-check"></i> Select
                                                        </button>
                                                        <label for="excel_import" class="btn btn-info mb-0"
                                                            style="cursor: pointer;">
                                                            <i class="ti ti-file-excel"></i> Import
                                                            <input type="file" id="excel_import" accept=".xlsx,.xls"
                                                                class="d-none">
                                                        </label>
                                                    </div>
                                                    <div class="mca-total">
                                                        Total: <span id="mca_total_amount">0.00</span>
                                                    </div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table table-bordered table-hover table-mca-small"
                                                        id="mcaFilesTable">
                                                        <thead>
                                                            <tr>
                                                                <th style="width: 40px;">#</th>
                                                                <th id="refHeading" style="width: 250px;">MCA Reference</th>
                                                                <th style="width: 120px;">Amount</th>
                                                                <th style="width: 60px;" class="text-center">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="mcaFilesList">
                                                            <tr>
                                                                <td colspan="4" class="text-center text-muted"
                                                                    style="padding: 15px;">
                                                                    <i class="ti ti-info-circle me-1"></i>No MCA
                                                                    references added yet
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <!-- Motif + Documents Section -->
                                                <div class="form-grid-motif-docs">
                                                    <div class="motif-column">
                                                        <div>
                                                            <label class="form-label">Motif / Reason <span class="text-danger">*</span></label>
                                                            <textarea name="motif" id="motif" class="form-control" rows="3" required
                                                                minlength="10" maxlength="500"
                                                                placeholder="Enter reason for payment"></textarea>
                                                            <small class="text-muted">Min 10 chars, Max 500 chars</small>
                                                            <div class="invalid-feedback">Required (10-500 characters)</div>
                                                        </div>
                                                    </div>

                                                    <div class="documents-column">
                                                        <div>
                                                            <label class="form-file-label">Document 1</label>
                                                            <input type="file" name="file1" id="file1" class="form-control"
                                                                accept=".pdf,.jpg,.jpeg,.png,.doc,.docx">
                                                            <small class="text-muted">Max 5MB</small>
                                                        </div>

                                                        <div>
                                                            <label class="form-file-label">Document 2</label>
                                                            <input type="file" name="file2" id="file2" class="form-control"
                                                                accept=".pdf,.jpg,.jpeg,.png,.doc,.docx">
                                                            <small class="text-muted">Max 5MB</small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="action-footer">
                            <button type="button" class="btn btn-outline-secondary" id="clearBtn">
                                Cancel
                            </button>
                            <button type="submit" class="btn btn-success" id="submitBtn">
                                <i class="ti ti-check"></i> Submit
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Payment Requests List Table -->
                <div class="card shadow-sm">
                    <div class="card-header border-bottom border-dashed d-flex align-items-center justify-content-between">
                        <h4 class="header-title mb-0"><i class="ti ti-list me-2"></i> List of Payment Requests</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="paymentRequestsTable"
                                class="table table-striped table-bordered dt-responsive nowrap w-100">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Department</th>
                                        <th>Beneficiary</th>
                                        <th>Client</th>
                                        <th>Payment For</th>
                                        <th>Payment Type</th>
                                        <th>Expense Type</th>
                                        <th>Amount</th>
                                        <th>Refs</th>
                                        <th>Status</th>
                                        <th>Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Department Approval Modal -->
        <div class="modal fade" id="deptApprovalModal" tabindex="-1">
            <input type="hidden" id="currentApprovalId">
            <div class="modal-dialog modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Department Approval</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body modal-body-scrollable">
                        <div id="approvalDetails"></div>
                        <div class="mt-3">
                            <button id="approveBtn" class="btn btn-success btn-sm">
                                <i class="ti ti-check"></i> Approve
                            </button>
                            <button id="rejectBtn" class="btn btn-danger btn-sm">
                                <i class="ti ti-x"></i> Reject
                            </button>
                        </div>
                        <div id="rejectSection" class="mt-3" style="display:none;">
                            <label>Reason for Rejection:</label>
                            <textarea id="rejectReason" class="form-control" rows="3" placeholder="Enter reason for rejection"></textarea>
                            <button id="submitRejectBtn" class="btn btn-danger btn-sm mt-2">
                                <i class="ti ti-send"></i> Submit Rejection
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Finance Approval Modal -->
        <div class="modal fade" id="financeApprovalModal" tabindex="-1">
            <div class="modal-dialog modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Finance Approval</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body modal-body-scrollable">
                        <div id="financeApprovalDetails"></div>
                        <div class="mt-3">
                            <button id="financeApproveBtn" class="btn btn-success btn-sm">
                                <i class="ti ti-check"></i> Approve
                            </button>
                            <button id="financeRejectBtn" class="btn btn-danger btn-sm">
                                <i class="ti ti-x"></i> Reject
                            </button>
                        </div>
                        <div id="financeRejectSection" class="mt-3" style="display:none;">
                            <label>Reason for Rejection:</label>
                            <textarea id="financeRejectReason" class="form-control" rows="3" placeholder="Enter reason for rejection"></textarea>
                            <button id="financeSubmitRejectBtn" class="btn btn-danger btn-sm mt-2">
                                <i class="ti ti-send"></i> Submit Rejection
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Management Approval Modal -->
        <div class="modal fade" id="mgmtApprovalModal" tabindex="-1">
            <div class="modal-dialog modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Management Approval</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body modal-body-scrollable">
                        <div id="mgmtApprovalDetails"></div>
                        <div class="mt-3">
                            <button id="mgmtApproveBtn" class="btn btn-success btn-sm">
                                <i class="ti ti-check"></i> Approve
                            </button>
                            <button id="mgmtRejectBtn" class="btn btn-danger btn-sm">
                                <i class="ti ti-x"></i> Reject
                            </button>
                        </div>
                        <div id="mgmtRejectSection" class="mt-3" style="display:none;">
                            <label>Reason for Rejection:</label>
                            <textarea id="mgmtRejectReason" class="form-control" rows="3" placeholder="Enter reason for rejection"></textarea>
                            <button id="mgmtSubmitRejectBtn" class="btn btn-danger btn-sm mt-2">
                                <i class="ti ti-send"></i> Submit Rejection
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- PAID APPROVAL MODAL -->
        <div class="modal fade" id="paidApprovalModal" tabindex="-1">
            <div class="modal-dialog modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Mark as Paid</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body modal-body-scrollable">
                        <div id="paidApprovalDetails"></div>
                        
                        <!-- Cash Collector Input -->
                        <div class="mt-3">
                            <label class="form-label">Cash Collector <span class="text-danger">*</span></label>
                            <input type="text" id="paidCashCollector" class="form-control" 
                                   placeholder="Enter cash collector name" maxlength="100" required>
                        </div>

                        <!-- File Upload Section -->
                        <div class="mt-3">
                            <h6 class="mb-2">Payment Documents</h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="form-file-label">Document 3</label>
                                    <input type="file" id="paidFile3" class="form-control"
                                        accept=".pdf,.jpg,.jpeg,.png,.doc,.docx">
                                    <small class="text-muted">Max 5MB</small>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-file-label">Document 4</label>
                                    <input type="file" id="paidFile4" class="form-control"
                                        accept=".pdf,.jpg,.jpeg,.png,.doc,.docx">
                                    <small class="text-muted">Max 5MB</small>
                                </div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <button id="paidApproveBtn" class="btn btn-success btn-sm">
                                <i class="ti ti-check"></i> Mark as Paid
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- VIEW MODAL -->
        <div class="modal fade" id="viewModal" tabindex="-1">
            <div class="modal-dialog modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><i class="ti ti-eye"></i> Payment Request Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body modal-body-scrollable" id="viewModalBody"></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- MCA Reference Selection Modal - IMPROVED SIZE WITH SEARCH -->
        <div class="modal fade" id="mcaRefModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-mca-small">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Select MCA References</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <!-- SEARCH BOX -->
                        <div class="mca-search-box">
                            <input type="text" id="mcaSearchInput" class="form-control" 
                                   placeholder="🔍 Search MCA references...">
                        </div>
                        
                        <!-- MCA LIST -->
                        <div id="mcaRefList" class="mca-refs-list"></div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button class="btn btn-primary btn-sm" id="applyMcaRefsBtn">Apply</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- MCA References View Modal -->
        <div class="modal fade" id="mcaRefsViewModal" tabindex="-1">
            <div class="modal-dialog modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">MCA References</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body modal-body-scrollable" id="mcaRefsViewBody"></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- PRINT MODAL -->
        <div class="modal fade" id="printModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header no-print">
                        <h5 class="modal-title"><i class="ti ti-printer"></i> Print Payment Request</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body" id="printModalBody">
                        <div class="print-section"></div>
                    </div>
                    <div class="modal-footer no-print">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="window.print()">
                            <i class="ti ti-printer"></i> Print
                        </button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<script src="<?= BASE_URL ?>/js/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>

<script>
$(document).ready(function () {
    let placeholderText = 'Enter MCA reference';
    var userRoleId = <?php echo $_SESSION['user_data']['role_id']; ?>;
    var currentFilter = 'all';

    // Load Status Cards
    function loadStatusCounts() {
        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_status_counts",
            type: "POST",
            dataType: "json",
            success: function(res) {
                if (res.success) {
                    $('#totalCount').text(res.data.total);
                    $('#waitingDeptCount').text(res.data.waiting_dept);
                    $('#waitingFinanceCount').text(res.data.waiting_finance);
                    $('#waitingMgmtCount').text(res.data.waiting_mgmt);
                    $('#paidCount').text(res.data.paid);
                    $('#rejectedCount').text(res.data.rejected);
                }
            }
        });
    }

    loadStatusCounts();

    // CLICKABLE CARD FILTERS
    $('.filter-card').on('click', function() {
        var filter = $(this).data('filter');
        currentFilter = filter;
        
        $('.filter-card').removeClass('active');
        $(this).addClass('active');
        
        paymentTable.ajax.reload();
    });

    // When "Payment For" dropdown changes
    $('#pay_for').on('change', function () {
        let val = $(this).val();

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/getExpenseTypesByCategory",
            type: "POST",
            data: { pay_for: val },
            dataType: "json",
            success: function(res){
                let html = '<option value="">Select</option>';
                res.forEach(row => {
                    html += `<option value="${row.id}">${row.expense_type_name}</option>`;
                });
                $('#expense_type').html(html);
            }
        });

        let selected = $(this).val();
        let sectionTitle = 'MCA References';
        let tableHeading = 'MCA Reference';

        switch (selected) {
            case '0':
                sectionTitle = 'Import Tracking References';
                tableHeading = 'Import Tracking Reference';
                placeholderText = 'Enter Import tracking reference';
                break;
            case '1':
                sectionTitle = 'Export Tracking References';
                tableHeading = 'Export Tracking Reference';
                placeholderText = 'Enter Export tracking reference';
                break;
            case '2':
                sectionTitle = 'Local Tracking References';
                tableHeading = 'Local Tracking Reference';
                placeholderText = 'Enter Local tracking reference';
                break;
            case '3':
                sectionTitle = 'Other References';
                tableHeading = 'Other Reference';
                placeholderText = 'Enter Other reference';
                break;
            case '4':
                sectionTitle = 'Pre Payment References';
                tableHeading = 'Pre Payment Reference';
                placeholderText = 'Enter Pre Payment reference';
                break;
            default:
                sectionTitle = 'MCA References';
                tableHeading = 'MCA Reference';
                placeholderText = 'Enter MCA reference';
        }

        $('.section-header span').text(sectionTitle);
        $('#refHeading').text(tableHeading);
        $('.mca-reference-input').attr('placeholder', placeholderText);
        $('#mcaFilesList').html(`
            <tr>
                <td colspan="4" class="text-center text-muted" style="padding: 15px;">
                    <i class="ti ti-info-circle me-1"></i>No references added yet
                </td>
            </tr>
        `);
        $('#mca_total_amount').text('0.00');
        $('#num_mca_refs').val(0);
    });

    // MCA SEARCH FUNCTIONALITY
    $('#mcaSearchInput').on('keyup', function() {
        let searchTerm = $(this).val().toLowerCase();
        
        $('.mca-ref-item').each(function() {
            let refText = $(this).find('label').text().toLowerCase();
            if (refText.indexOf(searchTerm) > -1) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });

    // Make entire MCA ref row clickable
    $(document).on('click', '.mca-ref-item', function(e) {
        // Don't toggle if clicked directly on checkbox
        if (e.target.type === 'checkbox') {
            return;
        }
        
        // Toggle checkbox when clicking anywhere on the row
        let checkbox = $(this).find('.mca-ref-check');
        checkbox.prop('checked', !checkbox.prop('checked'));
    });

    // CHECK MCA DUPLICATE FUNCTION
    function checkMcaDuplicate(mcaRef, callback) {
        let expenseType = $('#expense_type').val();
        let paymentId = $('#recordId').val();
        
        if (!expenseType) {
            alert('Please select Expense Type first');
            callback(true);
            return;
        }
        
        $.ajax({
            url: "<?php echo APP_URL; ?>payment/check_mca_duplicate",
            type: "POST",
            data: {
                mca_ref: mcaRef,
                expense_type: expenseType,
                payment_id: paymentId
            },
            dataType: "json",
            success: function(res) {
                if (res.exists) {
                    alert('❌ ' + res.message);
                    callback(true);
                } else {
                    callback(false);
                }
            },
            error: function() {
                callback(false);
            }
        });
    }

    // Validate and calculate total
    function validateMcaAmounts() {
        let mainAmount = parseFloat($('#amount').val()) || 0;
        let total = 0;
        let hasError = false;

        $('.mca-amount-input').each(function () {
            let rowVal = parseFloat($(this).val()) || 0;

            if (mainAmount > 0 && rowVal > mainAmount) {
                alert('❌ Individual row amount (' + rowVal + ') cannot exceed the main amount (' + mainAmount + ').');
                $(this).val('');
                hasError = true;
                rowVal = 0;
            }

            total += rowVal;
        });

        $('#mca_total_amount').text(total.toFixed(2));

        if (mainAmount > 0 && total > mainAmount) {
            alert('❌ Total of all references (' + total.toFixed(2) + ') exceeds main amount (' + mainAmount + ').');
            $('#mca_total_amount').css('color', 'red');
            hasError = true;
        } else {
            $('#mca_total_amount').css('color', '');
        }

        $('#submitBtn').prop('disabled', hasError);
    }

    $(document).on('input', '.mca-amount-input', function () {
        validateMcaAmounts();
    });

    $('#amount').on('input', function () {
        validateMcaAmounts();
    });

    // CHECK DUPLICATE ON MCA REF INPUT BLUR
    $(document).on('blur', '.mca-reference-input', function() {
        let mcaRef = $(this).val().trim();
        let $input = $(this);
        
        if (mcaRef) {
            checkMcaDuplicate(mcaRef, function(isDuplicate) {
                if (isDuplicate) {
                    $input.val('');
                    $input.focus();
                }
            });
        }
    });

    // Initialize DataTable WITH FILTER SUPPORT
    var paymentTable = $('#paymentRequestsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?php echo APP_URL; ?>payment/get_list",
            type: "POST",
            data: function(d) {
                d.status_filter = currentFilter;
                if (userRoleId == 4) {
            d.payment_type_filter = "ALL";  // No filter
        } 
        else if (userRoleId == 5) {
            d.payment_type_filter = "Cash"; // Only Cash
        } 
        else {
            d.payment_type_filter = "DEFAULT"; // others use default
        }
            },
            error: function (xhr, error, thrown) {
                console.error('DataTable Error:', xhr.responseText);
            }
        },
        columns: [
            { data: 'id', width: '50px' },
            { data: 'department_name' },
            { data: 'beneficiary' },
            { data: 'client_name' },
            {
                data: 'pay_for',
                render: function (data) {
                    const payForMap = {
                        '0': 'Import Tracking',
                        '1': 'Export Tracking',
                        '2': 'Local Tracking',
                        '3': 'Other',
                        '4': 'Pre Payment'
                    };
                    return payForMap[data] || 'N/A';
                }
            },
            { data: 'payment_type' },  // PAYMENT TYPE BEFORE EXPENSE TYPE
            { data: 'expense_type_name' },
            {
                data: 'amount',
                render: function (data) {
                    return parseFloat(data).toFixed(2);
                }
            },
            {
                data: 'mca_data',
                orderable: false,
                searchable: false,
                render: function(data, type, row) {
                    let count = 0;
                    if (data) {
                        try {
                            let mcaArray = JSON.parse(data);
                            count = mcaArray.length;
                        } catch(e) {
                            count = 0;
                        }
                    }
                    return `
                        <button class="btn btn-xs btn-info view-mca-refs" data-id="${row.id}" title="View References">
                            <i class="ti ti-eye"></i> ${count}
                        </button>
                    `;
                }
            },
            {
                data: null,
                render: function(data, type, row) {
                    let status = '';
                    
                    if (row.dept_approval == -1) {
                        status = '<span class="badge bg-danger">Dept Rejected</span>';
                    } else if (row.finance_approval == -1) {
                        status = '<span class="badge bg-danger">Finance Rejected</span>';
                    } else if (row.management_approval == -1) {
                        status = '<span class="badge bg-danger">Mgmt Rejected</span>';
                    } else if (row.paid_approval == -1) {
                        status = '<span class="badge bg-danger">Payment Rejected</span>';
                    } else if (row.paid_approval == 1) {
                        status = '<span class="badge bg-success">Paid</span>';
                    } else if (row.management_approval == 1) {
                        status = '<span class="badge bg-info">Mgmt Approved</span>';
                    } else if (row.finance_approval == 1) {
                        status = '<span class="badge bg-dark">Finance Approved</span>';
                    } else if (row.dept_approval == 1) {
                        status = '<span class="badge bg-primary">Dept Approved</span>';
                    } else {
                        status = '<span class="badge bg-warning">Pending</span>';
                    }
                    return status;
                }
            },
            {
                data: 'created_at',
                render: function (data) {
                    return data ? new Date(data).toLocaleDateString() : 'N/A';
                }
            },
            {
                data: null,
                orderable: false,
                searchable: false,
                width: '250px',
                render: function (data, type, row) {
                    let extraBtn = '';
                    let editBtn = '';
                    
                    if (row.dept_approval == -1 || row.finance_approval == -1 || 
                        row.management_approval == -1 || row.paid_approval == -1) {
                        editBtn = `
                            <button class="btn btn-xs btn-warning edit-payment" data-id="${row.id}" title="Edit & Resubmit">
                                <i class="ti ti-edit"></i>
                            </button>`;
                    } else if (row.dept_approval === null) {
                        editBtn = `
                            <button class="btn btn-xs btn-primary edit-payment" data-id="${row.id}" title="Edit">
                                <i class="ti ti-edit"></i>
                            </button>`;
                    }
                    
                    if (row.dept_approval === null && userRoleId == 3) {
                        extraBtn = `
                            <button class="btn btn-xs btn-warning dept-approve" data-id="${row.id}" title="Department Approval">
                                <i class="ti ti-check"></i> Dept
                            </button>`;
                    } else if (row.dept_approval == 1 && row.finance_approval === null && userRoleId == 4 && row.payment_type == 'Cash') {
                        extraBtn = `
                            <button class="btn btn-xs btn-success finance-approve" data-id="${row.id}" title="Finance Approval">
                                <i class="ti ti-check"></i> Finance
                            </button>`;
                    } else if (row.dept_approval == 1 && row.finance_approval === null && userRoleId == 5 && row.payment_type == 'Bank') {
                        extraBtn = `
                            <button class="btn btn-xs btn-success finance-approve" data-id="${row.id}" title="Finance Approval">
                                <i class="ti ti-check"></i> Finance
                            </button>`;
                    } else if (row.dept_approval == 1 && row.finance_approval == 1 && row.management_approval === null && userRoleId == 1) {
                        extraBtn = `
                            <button class="btn btn-xs btn-dark mgmt-approve" data-id="${row.id}" title="Management Approval">
                                <i class="ti ti-user-check"></i> Mgmt
                            </button>`;
                    } else if (row.dept_approval == 1 && row.finance_approval == 1 && 
                             row.management_approval == 1 && row.paid_approval === null && 
                             userRoleId == 10 && row.payment_type == 'Cash') {
                        extraBtn = `
                            <button class="btn btn-xs btn-success paid-approve" data-id="${row.id}" title="Mark as Paid">
                                <i class="ti ti-currency-dollar"></i> Paid
                            </button>`;
                    } else if (row.dept_approval == 1 && row.finance_approval == 1 && 
                             row.management_approval == 1 && row.paid_approval === null && 
                             userRoleId == 15 && row.payment_type == 'Bank') {
                        extraBtn = `
                            <button class="btn btn-xs btn-success paid-approve" data-id="${row.id}" title="Mark as Paid">
                                <i class="ti ti-currency-dollar"></i> Paid
                            </button>`;
                    }

                    return `
                        <button class="btn btn-xs btn-info view-payment" data-id="${row.id}" title="View">
                            <i class="ti ti-eye"></i>
                        </button>
                        <button class="btn btn-xs btn-secondary print-payment" data-id="${row.id}" title="Print">
                            <i class="ti ti-printer"></i>
                        </button>
                        ${editBtn}
                        <button class="btn btn-xs btn-danger delete-payment" data-id="${row.id}" title="Delete">
                            <i class="ti ti-trash"></i>
                        </button>
                        ${extraBtn}
                    `;
                }
            }
        ],
        order: [[0, 'desc']],
        pageLength: 10,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
        language: {
            processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i>',
            emptyTable: "No payment requests found",
            zeroRecords: "No matching records found"
        },
        drawCallback: function() {
            loadStatusCounts();
        }
    });
// View MCA References
    $('#paymentRequestsTable').on('click', '.view-mca-refs', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        let id = $(this).data('id');
        
        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_single",
            type: "POST",
            data: { id: id },
            dataType: "json",
            success: function(res) {
                if (res.success) {
                    let refs = res.mca_refs || [];
                    let html = '';
                    
                    if (refs.length > 0) {
                        html = `
                            <table class="table table-bordered table-striped table-sm">
                                <thead>
                                    <tr>
                                        <th style="width: 50px;">#</th>
                                        <th>Reference</th>
                                        <th style="width: 120px;">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                        `;
                        
                        refs.forEach((r, i) => {
                            html += `
                                <tr>
                                    <td>${i + 1}</td>
                                    <td>${r.mca_ref}</td>
                                    <td>${parseFloat(r.amount).toFixed(2)}</td>
                                </tr>
                            `;
                        });
                        
                        html += `</tbody></table>`;
                    } else {
                        html = '<p class="text-center text-muted">No references found</p>';
                    }
                    
                    $('#mcaRefsViewBody').html(html);
                    var mcaModal = new bootstrap.Modal(document.getElementById('mcaRefsViewModal'));
                    mcaModal.show();
                }
            },
            error: function() {
                alert('Failed to load MCA references');
            }
        });
    });

    // PRINT PAYMENT REQUEST
    $('#paymentRequestsTable').on('click', '.print-payment', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const id = $(this).data('id');
        
        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_single",
            type: "POST",
            data: { id: id },
            dataType: "json",
            success: function (response) { 
                if (response.success) {
                    const data = response.data;
                    const refs = response.mca_refs || [];
                    
                    const payForMap = {
                        '0': 'Import Tracking',
                        '1': 'Export Tracking',
                        '2': 'Local Tracking',
                        '3': 'Other',
                        '4': 'Pre Payment'
                    };

                    let mcaHTML = '';
                    if (refs.length > 0) {
                        mcaHTML = `
                            <h6 style="margin-top: 20px; margin-bottom: 10px;">References (${refs.length})</h6>
                            <table class="print-table">
                                <thead>
                                    <tr>
                                        <th style="width: 50px;">#</th>
                                        <th>Reference</th>
                                        <th style="width: 120px;">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                        `;
                        
                        refs.forEach((mca, index) => {
                            mcaHTML += `
                                <tr>
                                    <td>${index + 1}</td>
                                    <td>${mca.mca_ref}</td>
                                    <td>${parseFloat(mca.amount).toFixed(2)}</td>
                                </tr>
                            `;
                        });
                        
                        mcaHTML += `</tbody></table>`;
                    }

                    let approvalHTML = `
                        <h6 style="margin-top: 30px; margin-bottom: 15px; border-bottom: 2px solid #0d6efd; padding-bottom: 10px;">
                            Approval Timeline
                        </h6>
                        <table class="print-table">
                            <thead>
                                <tr>
                                    <th style="width: 25%; text-align: center;">Department</th>
                                    <th style="width: 25%; text-align: center;">Finance</th>
                                    <th style="width: 25%; text-align: center;">Management</th>
                                    <th style="width: 25%; text-align: center;">Payment</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr style="text-align: center;">
                    `;

                    if (data.dept_approval == 1) {
                        approvalHTML += `
                            <td>
                                <span style="color: green; font-weight: bold;">✓ Approved</span><br>
                                <small style="color: #666;">${data.dept_approved_by_name || 'N/A'}</small><br>
                                <small style="color: #999;">${data.dept_approved_at ? new Date(data.dept_approved_at).toLocaleDateString() : ''}</small>
                            </td>
                        `;
                    } else if (data.dept_approval == -1) {
                        approvalHTML += `
                            <td>
                                <span style="color: red; font-weight: bold;">✗ Rejected</span><br>
                                <small style="color: #666;">${data.dept_approved_by_name || 'N/A'}</small>
                            </td>
                        `;
                    } else {
                        approvalHTML += `<td><span style="color: orange;">Pending</span></td>`;
                    }

                    if (data.finance_approval == 1) {
                        approvalHTML += `
                            <td>
                                <span style="color: green; font-weight: bold;">✓ Approved</span><br>
                                <small style="color: #666;">${data.finance_approved_by_name || 'N/A'}</small><br>
                                <small style="color: #999;">${data.finance_approved_at ? new Date(data.finance_approved_at).toLocaleDateString() : ''}</small>
                            </td>
                        `;
                    } else if (data.finance_approval == -1) {
                        approvalHTML += `
                            <td>
                                <span style="color: red; font-weight: bold;">✗ Rejected</span><br>
                                <small style="color: #666;">${data.finance_approved_by_name || 'N/A'}</small>
                            </td>
                        `;
                    } else {
                        approvalHTML += `<td><span style="color: orange;">Pending</span></td>`;
                    }

                    if (data.management_approval == 1) {
                        approvalHTML += `
                            <td>
                                <span style="color: green; font-weight: bold;">✓ Approved</span><br>
                                <small style="color: #666;">${data.management_approved_by_name || 'N/A'}</small><br>
                                <small style="color: #999;">${data.management_approved_at ? new Date(data.management_approved_at).toLocaleDateString() : ''}</small>
                            </td>
                        `;
                    } else if (data.management_approval == -1) {
                        approvalHTML += `
                            <td>
                                <span style="color: red; font-weight: bold;">✗ Rejected</span><br>
                                <small style="color: #666;">${data.management_approved_by_name || 'N/A'}</small>
                            </td>
                        `;
                    } else {
                        approvalHTML += `<td><span style="color: orange;">Pending</span></td>`;
                    }

                    if (data.paid_approval == 1) {
                        approvalHTML += `
                            <td>
                                <span style="color: green; font-weight: bold;">✓ Paid</span><br>
                                <small style="color: #666;">${data.paid_approved_by_name || 'N/A'}</small><br>
                                <small style="color: #999;">${data.paid_approved_at ? new Date(data.paid_approved_at).toLocaleDateString() : ''}</small>
                            </td>
                        `;
                    } else if (data.paid_approval == -1) {
                        approvalHTML += `
                            <td>
                                <span style="color: red; font-weight: bold;">✗ Rejected</span><br>
                                <small style="color: #666;">${data.paid_approved_by_name || 'N/A'}</small>
                            </td>
                        `;
                    } else {
                        approvalHTML += `<td><span style="color: orange;">Pending</span></td>`;
                    }

                    approvalHTML += `
                                </tr>
                            </tbody>
                        </table>
                    `;

                    const printHTML = `
                        <div class="print-header">
                            <h2>PAYMENT REQUEST</h2>
                            <p>Request ID: #${data.id} | Date: ${new Date(data.created_at).toLocaleDateString()}</p>
                        </div>

                        <h6>Payment Information</h6>
                        <table class="print-table">
                            <tr><th>Request ID</th><td>#${data.id}</td></tr>
                            <tr><th>Department</th><td>${data.department_name || 'N/A'}</td></tr>
                            <tr><th>Location</th><td>${data.main_location_name || 'N/A'}</td></tr>
                            <tr><th>Beneficiary</th><td>${data.beneficiary}</td></tr>
                            <tr><th>Requestee</th><td>${data.requestee}</td></tr>
                            <tr><th>Client</th><td>${data.client_name || 'N/A'}</td></tr>
                            <tr><th>Payment For</th><td>${payForMap[data.pay_for] || 'N/A'}</td></tr>
                            <tr><th>Payment Type</th><td>${data.payment_type}</td></tr>
                            <tr><th>Currency</th><td>${data.currency_short_name || 'N/A'}</td></tr>
                            <tr><th>Amount</th><td><strong style="font-size: 1.2em;">${parseFloat(data.amount).toFixed(2)}</strong></td></tr>
                            <tr><th>Expense Type</th><td>${data.expense_type_name || 'N/A'}</td></tr>
                            <tr><th>Cash Collector</th><td>${data.cash_collector || 'N/A'}</td></tr>
                            <tr><th>Chargeback</th><td>${data.chargeback ? parseFloat(data.chargeback).toFixed(2) : 'N/A'}</td></tr>
                        </table>

                        <h6 style="margin-top: 20px; margin-bottom: 10px;">Motif / Reason</h6>
                        <p style="border: 1px solid #dee2e6; padding: 10px; background: #f8f9fa;">${data.motif}</p>

                        ${mcaHTML}

                        ${approvalHTML}

                        <div style="margin-top: 40px; page-break-inside: avoid;">
                            <p style="text-align: center; color: #666; font-size: 0.9em; margin-top: 30px;">
                                <em>This is a system-generated document. Printed on ${new Date().toLocaleDateString()}</em>
                            </p>
                        </div>
                    `;

                    $('#printModalBody .print-section').html(printHTML);
                    var printModal = new bootstrap.Modal(document.getElementById('printModal'));
                    printModal.show();
                } else {
                    alert('❌ ' + response.message);
                }
            },
            error: function () {
                alert('❌ Failed to load payment details');
            }
        });
    });

    // Function to close accordion
    function closeAccordion() {
        $('#paymentFormContent').removeClass('show');
        $('.accordion-button').addClass('collapsed').attr('aria-expanded', 'false');
    }

    // Function to open accordion
    function openAccordion() {
        $('#paymentFormContent').addClass('show');
        $('.accordion-button').removeClass('collapsed').attr('aria-expanded', 'true');
    }

    // Reset form function
    function resetForm() {
        $('#paymentRequestForm')[0].reset();
        $('#formAction').val('insert');
        $('#recordId').val('');
        $('#formTitle').text('New Payment Request');
        $('#resetFormBtn').hide();
        
        $('#mcaFilesList').html(`
            <tr>
                <td colspan="4" class="text-center text-muted" style="padding: 15px;">
                    <i class="ti ti-info-circle me-1"></i>No MCA references added yet
                </td>
            </tr>
        `);
        
        $('#mca_total_amount').text('0.00');
        $('#paymentRequestForm').removeClass('was-validated');
    }

    // Reset button click
    $('#resetFormBtn').on('click', function() {
        resetForm();
        closeAccordion();
    });

    // Cancel button
    $('#clearBtn').on('click', function() {
        closeAccordion();
        resetForm();
    });

    $('#pay_for').change(autoFillOtherReferences);
    $('#location').change(autoFillOtherReferences);

    // Add MCA Reference Rows
    $('#add_mca_refs_btn').on('click', function () {
        const numRefs = parseInt($('#num_mca_refs').val()) || 0;

        if (numRefs <= 0) {
            alert('Please enter a valid number of references');
            return;
        }

        if (numRefs > 50) {
            alert('Maximum 50 references allowed');
            return;
        }

        const tbody = $('#mcaFilesList');
        tbody.find('td[colspan="4"]').closest('tr').remove();
        const currentRows = tbody.find('tr').length;

        for (let i = 0; i < numRefs; i++) {
            const rowNum = currentRows + i + 1;
            let autoRef = "";

            const payFor = $('#pay_for').val();
            if (payFor == "3") {
                const locText = $('#location option:selected').text().trim();
                const firstTwo = locText.substring(0, 2).toUpperCase();
                autoRef = `OTH-${firstTwo}-${rowNum}`;
            }
            if (payFor == "4") {
                const locText = $('#location option:selected').text().trim();
                const firstTwo = locText.substring(0, 2).toUpperCase();
                autoRef = `PRE-${firstTwo}-${rowNum}`;
            }
            const readonlyAttr = ((payFor == "4") || (payFor == "3")) ? "readonly" : "";
            
            const newRow = `
                <tr>
                    <td class="text-center">${rowNum}</td>
                    <td>
                        <input type="text" class="form-control mca-reference-input" 
                               name="mca_reference[]" value="${autoRef}" ${readonlyAttr}
                               placeholder="${placeholderText}" required>
                    </td>
                    <td>
                        <input type="number" class="form-control mca-amount-input" 
                               name="mca_amount[]" step="0.01" min="0" placeholder="0.00" required>
                    </td>
                    <td class="text-center">
                        <button type="button" class="btn btn-sm btn-danger delete-mca-row">
                            <i class="ti ti-trash"></i>
                        </button>
                    </td>
                </tr>
            `;
            tbody.append(newRow);
        }

        $('#num_mca_refs').val(0);
        calculateMcaTotal();
        autoFillOtherReferences();
    });

    function autoFillOtherReferences() {
        const payFor = $('#pay_for').val();
        if (payFor != "3" && payFor != "4") return;

        const locText = $('#location option:selected').text().trim();
        if (!locText) return;

        const firstTwo = locText.substring(0, 2).toUpperCase();
        const prefix = payFor == "4" ? "PRE" : "OTH";

        $('.mca-reference-input').each(function (index) {
            const rowNum = index + 1;
            $(this).val(`${prefix}-${firstTwo}-${rowNum}`);
        });
    }

    // Delete MCA Row
    $('#mcaFilesList').on('click', '.delete-mca-row', function () {
        $(this).closest('tr').remove();
        renumberMcaRows();
        calculateMcaTotal();

        if ($('#mcaFilesList tr').length === 0) {
            $('#mcaFilesList').html(`
                <tr>
                    <td colspan="4" class="text-center text-muted" style="padding: 15px;">
                        <i class="ti ti-info-circle me-1"></i>No MCA references added yet
                    </td>
                </tr>
            `);
        }
    });

    function addMcaRow(mcaRef = "", amount = 0) {
        const tbody = $('#mcaFilesList');
        tbody.find('td[colspan="4"]').closest('tr').remove();

        const rowNum = tbody.find('tr').length + 1;
        const payFor = $('#pay_for').val();
        const readonlyAttr = ((payFor == "3") || (payFor == "4")) ? "readonly" : "";

        const newRow = `
            <tr>
                <td class="text-center">${rowNum}</td>
                <td>
                    <input type="text" class="form-control mca-reference-input"
                           name="mca_reference[]" value="${mcaRef}" ${readonlyAttr} required>
                </td>
                <td>
                    <input type="number" class="form-control mca-amount-input"
                           name="mca_amount[]" step="0.01" min="0" value="${amount}" required>
                </td>
                <td class="text-center">
                    <button type="button" class="btn btn-sm btn-danger delete-mca-row">
                        <i class="ti ti-trash"></i>
                    </button>
                </td>
            </tr>
        `;

        tbody.append(newRow);
        renumberMcaRows();
        calculateMcaTotal();
    }

    // Excel Import
    $('#excel_import').on('change', function (e) {
        importExcelFile(this);
    });

    // Form submission
    $('#paymentRequestForm').on('submit', function (e) {
        e.preventDefault();

        const formData = new FormData(this);

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/store",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            dataType: "json",
            success: function (res) {
                if (res.success) {
                    alert('✅ ' + res.message);
                    paymentTable.ajax.reload(null, false);
                    closeAccordion();
                    resetForm();
                } else {
                    alert('❌ ' + res.message);
                }
            },
            error: function (xhr, status, error) {
                console.error('Error:', xhr.responseText);
                alert('❌ An error occurred. Check console for details.');
            }
        });
    });

    // View Payment Details
    $('#paymentRequestsTable').on('click', '.view-payment', function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        const id = $(this).data('id');
        
        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_single",
            type: "POST",
            data: { id: id },
            dataType: "json",
            success: function (response) { 
                if (response.success) {
                    const data = response.data;
                    const refs = response.mca_refs || [];
                    
                    const payForMap = {
                        '0': 'Import Tracking',
                        '1': 'Export Tracking',
                        '2': 'Local Tracking',
                        '3': 'Other',
                        '4': 'Pre Payment'
                    };

                    let approvalStatus = '';
                    if (data.dept_approval == -1) {
                        approvalStatus = '<span class="badge bg-danger">Dept Rejected</span>';
                    } else if (data.finance_approval == -1) {
                        approvalStatus = '<span class="badge bg-danger">Finance Rejected</span>';
                    } else if (data.management_approval == -1) {
                        approvalStatus = '<span class="badge bg-danger">Mgmt Rejected</span>';
                    } else if (data.paid_approval == -1) {
                        approvalStatus = '<span class="badge bg-danger">Payment Rejected</span>';
                    } else if (data.paid_approval == 1) {
                        approvalStatus = '<span class="badge bg-success">Paid</span>';
                    } else if (data.management_approval == 1) {
                        approvalStatus = '<span class="badge bg-info">Mgmt Approved</span>';
                    } else if (data.finance_approval == 1) {
                        approvalStatus = '<span class="badge bg-dark">Finance Approved</span>';
                    } else if (data.dept_approval == 1) {
                        approvalStatus = '<span class="badge bg-primary">Dept Approved</span>';
                    } else {
                        approvalStatus = '<span class="badge bg-warning">Pending</span>';
                    }

                    let mcaHTML = '';
                    if (refs.length > 0) {
                        mcaHTML = `
                            <div style="max-height: 200px; overflow-y: auto;">
                                <table class="table table-bordered table-sm">
                                    <thead>
                                        <tr>
                                            <th style="width: 50px;">#</th>
                                            <th>Reference</th>
                                            <th style="width: 100px;">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                        `;
                        
                        refs.forEach((mca, index) => {
                            mcaHTML += `
                                <tr>
                                    <td>${index + 1}</td>
                                    <td>${mca.mca_ref}</td>
                                    <td>${parseFloat(mca.amount).toFixed(2)}</td>
                                </tr>
                            `;
                        });
                        
                        mcaHTML += `</tbody></table></div>`;
                    } else {
                        mcaHTML = '<p class="text-muted">No references found</p>';
                    }

                    let filesHTML = '';
                    if (data.file1_path || data.file2_path || data.file3_path || data.file4_path) {
                        filesHTML += '<div>';
                        if (data.file1_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file1_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 1
                            </a>`;
                        }
                        if (data.file2_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file2_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 2
                            </a>`;
                        }
                        if (data.file3_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file3_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 3
                            </a>`;
                        }
                        if (data.file4_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file4_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 4
                            </a>`;
                        }
                        filesHTML += '</div>';
                    } else {
                        filesHTML = '<p class="text-muted">No documents attached</p>';
                    }

                    function formatDateTime(datetime) {
                        if (!datetime) return 'N/A';
                        let d = new Date(datetime);
                        return d.toLocaleString('en-US', { 
                            year: 'numeric', 
                            month: 'short', 
                            day: 'numeric',
                            hour: '2-digit',
                            minute: '2-digit'
                        });
                    }

                    const viewHTML = `
                        <h6 class="mb-2">Payment Information</h6>
                        <table class="table table-sm table-bordered info-table">
                            <tr><th>Request ID</th><td>#${data.id}</td></tr>
                            <tr><th>Status</th><td>${approvalStatus}</td></tr>
                            <tr><th>Department</th><td>${data.department_name || 'N/A'}</td></tr>
                            <tr><th>Location</th><td>${data.main_location_name || 'N/A'}</td></tr>
                            <tr><th>Beneficiary</th><td>${data.beneficiary}</td></tr>
                            <tr><th>Requestee</th><td>${data.requestee}</td></tr>
                            <tr><th>Client</th><td>${data.client_name || 'N/A'}</td></tr>
                            <tr><th>Payment For</th><td>${payForMap[data.pay_for] || 'N/A'}</td></tr>
                            <tr><th>Payment Type</th><td>${data.payment_type}</td></tr>
                            <tr><th>Currency</th><td>${data.currency_short_name || 'N/A'}</td></tr>
                            <tr><th>Amount</th><td><strong>${parseFloat(data.amount).toFixed(2)}</strong></td></tr>
                            <tr><th>Expense Type</th><td>${data.expense_type_name || 'N/A'}</td></tr>
                            <tr><th>Cash Collector</th><td>${data.cash_collector || 'N/A'}</td></tr>
                            <tr><th>Chargeback</th><td>${data.chargeback ? parseFloat(data.chargeback).toFixed(2) : 'N/A'}</td></tr>
                            <tr><th>Created Date</th><td>${data.created_at}</td></tr>
                            <tr><th>Updated Date</th><td>${data.updated_at || 'N/A'}</td></tr>
                        </table>

                        <h6 class="mt-3 mb-2">Motif / Reason</h6>
                        <div class="alert alert-secondary p-2" style="font-size: 0.85rem;">${data.motif}</div>

                        <h6 class="mt-3 mb-2">Attached Documents</h6>
                        ${filesHTML}

                        <h6 class="mt-3 mb-2">References (${refs.length})</h6>
                        ${mcaHTML}

                        <h6 class="mt-3 mb-2">Approval Timeline</h6>
                        <table class="table table-sm table-bordered timeline-table">
                            <thead>
                                <tr>
                                    <th>Department</th>
                                    <th>Finance</th>
                                    <th>Management</th>
                                    <th>Paid</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        ${data.dept_approval == 1 ? '<span class="badge bg-success">Approved</span>' : 
                                         data.dept_approval == -1 ? '<span class="badge bg-danger">Rejected</span>' : 
                                         '<span class="badge bg-warning">Pending</span>'}
                                        ${data.dept_approval == 1 ? `
                                            <span class="timeline-user">${data.dept_approved_by_name || 'N/A'}</span>
                                            <span class="timeline-time">${formatDateTime(data.dept_approved_at)}</span>
                                        ` : ''}
                                    </td>
                                    <td>
                                        ${data.finance_approval == 1 ? '<span class="badge bg-success">Approved</span>' : 
                                         data.finance_approval == -1 ? '<span class="badge bg-danger">Rejected</span>' : 
                                         '<span class="badge bg-warning">Pending</span>'}
                                        ${data.finance_approval == 1 ? `
                                            <span class="timeline-user">${data.finance_approved_by_name || 'N/A'}</span>
                                            <span class="timeline-time">${formatDateTime(data.finance_approved_at)}</span>
                                        ` : ''}
                                    </td>
                                    <td>
                                        ${data.management_approval == 1 ? '<span class="badge bg-success">Approved</span>' : 
                                         data.management_approval == -1 ? '<span class="badge bg-danger">Rejected</span>' : 
                                         '<span class="badge bg-warning">Pending</span>'}
                                        ${data.management_approval == 1 ? `
                                            <span class="timeline-user">${data.management_approved_by_name || 'N/A'}</span>
                                            <span class="timeline-time">${formatDateTime(data.management_approved_at)}</span>
                                        ` : ''}
                                    </td>
                                    <td>
                                        ${data.paid_approval == 1 ? '<span class="badge bg-success">Paid</span>' : 
                                         data.paid_approval == -1 ? '<span class="badge bg-danger">Rejected</span>' : 
                                         '<span class="badge bg-warning">Pending</span>'}
                                        ${data.paid_approval == 1 ? `
                                            <span class="timeline-user">${data.paid_approved_by_name || 'N/A'}</span>
                                            <span class="timeline-time">${formatDateTime(data.paid_approved_at)}</span>
                                        ` : ''}
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                        ${data.dept_notes ? `<div class="alert alert-danger p-2 mt-2"><strong>Dept Rejection:</strong> ${data.dept_notes}</div>` : ''}
                        ${data.finance_notes ? `<div class="alert alert-danger p-2 mt-2"><strong>Finance Rejection:</strong> ${data.finance_notes}</div>` : ''}
                        ${data.management_notes ? `<div class="alert alert-danger p-2 mt-2"><strong>Mgmt Rejection:</strong> ${data.management_notes}</div>` : ''}
                        ${data.paid_notes ? `<div class="alert alert-danger p-2 mt-2"><strong>Payment Rejection:</strong> ${data.paid_notes}</div>` : ''}
                    `;

                    $('#viewModalBody').html(viewHTML);
                    var viewModal = new bootstrap.Modal(document.getElementById('viewModal'));
                    viewModal.show();
                } else {
                    alert('❌ ' + response.message);
                }
            },
            error: function () {
                alert('❌ Failed to load payment details');
            }
        });
    });

    // Edit Payment
    $('#paymentRequestsTable').on('click', '.edit-payment', function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        const id = $(this).data('id');
        
        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_single",
            type: "POST",
            data: { id: id },
            dataType: "json",
            success: function (response) {
                if (response.success) {
                    const data = response.data;
                    const refs = response.mca_refs || [];
                    
                    $('#formAction').val('update');
                    $('#recordId').val(data.id);
                    $('#formTitle').text('Edit Payment Request #' + data.id);
                    $('#resetFormBtn').show();

                    $('#department').val(data.department);
                    $('#location').val(data.location_id);
                    $('#beneficiary').val(data.beneficiary);
                    $('#requestee').val(data.requestee);
                    $('#client_id').val(data.client_id);
                    $('#pay_for').val(data.pay_for).trigger('change');
                    $('#payment_type').val(data.payment_type);
                    $('#currency').val(data.currency);
                    $('#amount').val(data.amount);
                    
                    setTimeout(function() {
                        $('#expense_type').val(data.expense_type);
                    }, 300);
                    
                    $('#motif').val(data.motif);

                    $('#mcaFilesList').empty();
                    
                    if (refs.length > 0) {
                        refs.forEach((mca, index) => {
                            const newRow = `
                                <tr>
                                    <td class="text-center">${index + 1}</td>
                                    <td>
                                        <input type="text" class="form-control mca-reference-input" 
                                               name="mca_reference[]" value="${mca.mca_ref}"
                                               placeholder="Enter MCA Reference" required>
                                    </td>
                                    <td>
                                        <input type="number" class="form-control mca-amount-input" 
                                               name="mca_amount[]" step="0.01" min="0" 
                                               value="${mca.amount}" placeholder="0.00" required>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-sm btn-danger delete-mca-row">
                                            <i class="ti ti-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            `;
                            $('#mcaFilesList').append(newRow);
                        });
                    } else {
                        $('#mcaFilesList').html(`
                            <tr>
                                <td colspan="4" class="text-center text-muted" style="padding: 15px;">
                                    <i class="ti ti-info-circle me-1"></i>No MCA references added yet
                                </td>
                            </tr>
                        `);
                    }

                    calculateMcaTotal();
                    openAccordion();

                    $('html, body').animate({
                        scrollTop: $('#paymentRequestForm').offset().top - 100
                    }, 500);
                } else {
                    alert('❌ ' + response.message);
                }
            },
            error: function () {
                alert('❌ Failed to load payment data');
            }
        });
    });

    // Delete Payment
    $('#paymentRequestsTable').on('click', '.delete-payment', function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        const id = $(this).data('id');

        if (confirm('Are you sure you want to delete this payment request?')) {
            $.ajax({
                url: "<?php echo APP_URL; ?>payment/delete/" + id,
                type: "POST",
                dataType: "json",
                success: function (res) {
                    if (res.success) {
                        alert('✅ ' + res.message);
                        paymentTable.ajax.reload(null, false);
                    } else {
                        alert('❌ ' + res.message);
                    }
                },
                error: function () {
                    alert('❌ An error occurred. Please try again.');
                }
            });
        }
    });

// Department Approval
    $('#paymentRequestsTable').on("click", ".dept-approve", function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        let id = $(this).data("id");
        $('#currentApprovalId').val(id);

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_single",
            type: "POST",
            data: { id: id },
            dataType: "json",
            success: function(res) { 
                if (res.success) {
                    let data = res.data;
                    let refs = res.mca_refs || [];

                    const payForMap = {
                        0: "Import Tracking",
                        1: "Export Tracking",
                        2: "Local Tracking",
                        3: "Other",
                        4: "Pre Payment"
                    };
                    data.pay_for = payForMap[data.pay_for] || data.pay_for;

                    let mcaHTML = '';
                    if (refs.length > 0) {
                        mcaHTML = `
                            <div style="max-height: 150px; overflow-y: auto;">
                                <table class="table table-bordered table-sm">
                                    <thead>
                                        <tr><th>#</th><th>Reference</th><th>Amount</th></tr>
                                    </thead>
                                    <tbody>
                        `;
                        refs.forEach((mca, index) => {
                            mcaHTML += `<tr><td>${index + 1}</td><td>${mca.mca_ref}</td><td>${parseFloat(mca.amount).toFixed(2)}</td></tr>`;
                        });
                        mcaHTML += `</tbody></table></div>`;
                    } else {
                        mcaHTML = '<p class="text-muted">No references found</p>';
                    }

                    let filesHTML = '';
                    if (data.file1_path || data.file2_path) {
                        filesHTML += '<div>';
                        if (data.file1_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file1_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 1
                            </a>`;
                        }
                        if (data.file2_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file2_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 2
                            </a>`;
                        }
                        filesHTML += '</div>';
                    } else {
                        filesHTML = '<p class="text-muted">No documents attached</p>';
                    }

                    $("#approvalDetails").html(`
                        <h6 class="mb-2">Payment Information</h6>
                        <table class="table table-bordered table-sm info-table">
                            <tr><th>ID</th><td>${data.id}</td></tr>
                            <tr><th>Department</th><td>${data.department_name}</td></tr>
                            <tr><th>Beneficiary</th><td>${data.beneficiary}</td></tr>
                            <tr><th>Requestee</th><td>${data.requestee}</td></tr>
                            <tr><th>Client</th><td>${data.client_name}</td></tr>
                            <tr><th>Payment For</th><td>${data.pay_for}</td></tr>
                            <tr><th>Payment Type</th><td>${data.payment_type}</td></tr>
                            <tr><th>Currency</th><td>${data.currency_short_name}</td></tr>
                            <tr><th>Amount</th><td><strong>${parseFloat(data.amount).toFixed(2)}</strong></td></tr>
                            <tr><th>Expense Type</th><td>${data.expense_type_name}</td></tr>
                            <tr><th>Cash Collector</th><td>${data.cash_collector || 'N/A'}</td></tr>
                        </table>

                        <h6 class="mt-3 mb-2">Motif / Reason</h6>
                        <div class="alert alert-secondary p-2" style="font-size: 0.85rem;">${data.motif}</div>

                        <h6 class="mt-3 mb-2">Attached Documents</h6>
                        ${filesHTML}

                        <h6 class="mt-3 mb-2">References (${refs.length})</h6>
                        ${mcaHTML}

                        <hr>
                        <h6>Chargeback</h6>
                        <div class="form-group mt-2">
                            <label>Chargeback Needed?</label><br>
                            <label><input type="radio" name="chargeback_needed" value="1"> Yes</label>
                            &nbsp;&nbsp;
                            <label><input type="radio" name="chargeback_needed" value="0" checked> No</label>
                        </div>

                        <div class="form-group mt-2" id="chargebackValueBox" style="display:none;">
                            <label>Chargeback Amount</label>
                            <input type="number" id="chargeback_value" class="form-control form-control-sm" min="0" placeholder="Enter amount">
                        </div>
                    `);

                    $("#rejectSection").hide();
                    $("#rejectReason").val('');
                    var deptModal = new bootstrap.Modal(document.getElementById('deptApprovalModal'));
                    deptModal.show();
                }
            }
        });
    });

    $(document).on("change", "input[name='chargeback_needed']", function () {
        if ($(this).val() == "1") {
            $("#chargebackValueBox").show();
        } else {
            $("#chargebackValueBox").hide();
            $("#chargeback_value").val('');
        }
    });

    $("#approveBtn").click(function () {
        let id = $('#currentApprovalId').val();
        let chargeback_needed = $("input[name='chargeback_needed']:checked").val();
        let chargeback_value = $("#chargeback_value").val();

        if (chargeback_needed == "1" && (!chargeback_value || chargeback_value < 1)) {
            alert("Enter valid chargeback amount");
            return;
        }

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/update_approval",
            type: "POST",
            data: {
                id: id,
                action: "dept_approve",
                chargeback_needed: chargeback_needed,
                chargeback_value: chargeback_value
            },
            dataType: "json",
            success: function(res) {
                if (res.success) {
                    alert("✅ Department Approved Successfully");
                    var modal = bootstrap.Modal.getInstance(document.getElementById('deptApprovalModal'));
                    modal.hide();
                    paymentTable.ajax.reload(null, false);
                } else {
                    alert("❌ " + res.message);
                }
            }
        });
    });

    $("#rejectBtn").click(function() {
        $("#rejectSection").show();
    });

    $("#submitRejectBtn").on("click", function() {
        let id = $('#currentApprovalId').val();
        let reason = $("#rejectReason").val().trim();

        if (reason === "") {
            alert("Please enter a reason for rejection.");
            return;
        }

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/reject_request",
            type: "POST",
            data: {
                id: id,
                reject_type: "dept",
                reason: reason
            },
            dataType: "json",
            success: function(res) {
                if (res.success) {
                    alert("✅ Rejected Successfully");
                    $("#rejectSection").hide();
                    $("#rejectReason").val("");
                    var modal = bootstrap.Modal.getInstance(document.getElementById('deptApprovalModal'));
                    modal.hide();
                    paymentTable.ajax.reload(null, false);
                } else {
                    alert("❌ " + res.message);
                }
            }
        });
    });

    // Finance Approval
    $('#paymentRequestsTable').on('click', '.finance-approve', function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        let id = $(this).data('id');

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_single",
            type: "POST",
            data: { id: id },
            dataType: "json",
            success: function(res) { 
                if (res.success) {
                    let data = res.data;
                    let refs = res.mca_refs || [];

                    const payForMap = {
                        0: "Import Tracking",
                        1: "Export Tracking",
                        2: "Local Tracking",
                        3: "Other",
                        4: "Pre Payment"
                    };
                    data.pay_for = payForMap[data.pay_for] || data.pay_for;

                    let mcaHTML = '';
                    if (refs.length > 0) {
                        mcaHTML = `
                            <div style="max-height: 150px; overflow-y: auto;">
                                <table class="table table-bordered table-sm">
                                    <thead>
                                        <tr><th>#</th><th>Reference</th><th>Amount</th></tr>
                                    </thead>
                                    <tbody>
                        `;
                        refs.forEach((mca, index) => {
                            mcaHTML += `<tr><td>${index + 1}</td><td>${mca.mca_ref}</td><td>${parseFloat(mca.amount).toFixed(2)}</td></tr>`;
                        });
                        mcaHTML += `</tbody></table></div>`;
                    } else {
                        mcaHTML = '<p class="text-muted">No references found</p>';
                    }

                    let filesHTML = '';
                    if (data.file1_path || data.file2_path) {
                        filesHTML += '<div>';
                        if (data.file1_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file1_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 1
                            </a>`;
                        }
                        if (data.file2_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file2_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 2
                            </a>`;
                        }
                        filesHTML += '</div>';
                    } else {
                        filesHTML = '<p class="text-muted">No documents attached</p>';
                    }

                    $("#financeApprovalDetails").html(`
                        <h6 class="mb-2">Payment Information</h6>
                        <table class="table table-bordered table-sm info-table">
                            <tr><th>ID</th><td>${data.id}</td></tr>
                            <tr><th>Department</th><td>${data.department_name}</td></tr>
                            <tr><th>Beneficiary</th><td>${data.beneficiary}</td></tr>
                            <tr><th>Requestee</th><td>${data.requestee}</td></tr>
                            <tr><th>Client</th><td>${data.client_name}</td></tr>
                            <tr><th>Payment For</th><td>${data.pay_for}</td></tr>
                            <tr><th>Payment Type</th><td>${data.payment_type}</td></tr>
                            <tr><th>Currency</th><td>${data.currency_short_name}</td></tr>
                            <tr><th>Amount</th><td><strong>${parseFloat(data.amount).toFixed(2)}</strong></td></tr>
                            <tr><th>Expense Type</th><td>${data.expense_type_name}</td></tr>
                            <tr><th>Cash Collector</th><td>${data.cash_collector || 'N/A'}</td></tr>
                            <tr><th>Chargeback</th><td>${data.chargeback ? parseFloat(data.chargeback).toFixed(2) : 'N/A'}</td></tr>
                        </table>

                        <h6 class="mt-3 mb-2">Motif / Reason</h6>
                        <div class="alert alert-secondary p-2" style="font-size: 0.85rem;">${data.motif}</div>

                        <h6 class="mt-3 mb-2">Attached Documents</h6>
                        ${filesHTML}

                        <h6 class="mt-3 mb-2">References (${refs.length})</h6>
                        ${mcaHTML}
                    `);

                    $("#financeApproveBtn").data("id", id);
                    $("#financeRejectBtn").data("id", id);
                    $("#financeRejectSection").hide();
                    $("#financeRejectReason").val('');
                    var finModal = new bootstrap.Modal(document.getElementById('financeApprovalModal'));
                    finModal.show();
                }
            }
        });
    });

    $("#financeApproveBtn").click(function () {
        let id = $(this).data("id");

        $.post("<?php echo APP_URL; ?>payment/update_approval", {
            id: id,
            action: "finance_approve"
        }, function (res) {
            if (res.success) {
                alert("✅ Finance Approved Successfully");
                var modal = bootstrap.Modal.getInstance(document.getElementById('financeApprovalModal'));
                modal.hide();
                paymentTable.ajax.reload(null, false);
            } else {
                alert("❌ Failed: " + res.message);
            }
        }, "json");
    });

    $("#financeRejectBtn").click(function() {
        $("#financeRejectSection").show();
    });

    $("#financeSubmitRejectBtn").on("click", function() {
        let id = $("#financeApproveBtn").data("id");
        let reason = $("#financeRejectReason").val().trim();

        if (reason === "") {
            alert("Please enter a reason for rejection.");
            return;
        }

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/reject_request",
            type: "POST",
            data: {
                id: id,
                reject_type: "finance",
                reason: reason
            },
            dataType: "json",
            success: function(res) {
                if (res.success) {
                    alert("✅ Rejected Successfully");
                    $("#financeRejectSection").hide();
                    $("#financeRejectReason").val("");
                    var modal = bootstrap.Modal.getInstance(document.getElementById('financeApprovalModal'));
                    modal.hide();
                    paymentTable.ajax.reload(null, false);
                } else {
                    alert("❌ " + res.message);
                }
            }
        });
    });

    // Management Approval
    $('#paymentRequestsTable').on('click', '.mgmt-approve', function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        let id = $(this).data('id');

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_single",
            type: "POST",
            data: { id: id },
            dataType: "json",
            success: function(res) { 
                if (res.success) {
                    let data = res.data;
                    let refs = res.mca_refs || [];

                    const payForMap = {
                        0: "Import Tracking",
                        1: "Export Tracking",
                        2: "Local Tracking",
                        3: "Other",
                        4: "Pre Payment"
                    };
                    data.pay_for = payForMap[data.pay_for] || data.pay_for;

                    let mcaHTML = '';
                    if (refs.length > 0) {
                        mcaHTML = `
                            <div style="max-height: 150px; overflow-y: auto;">
                                <table class="table table-bordered table-sm">
                                    <thead>
                                        <tr><th>#</th><th>Reference</th><th>Amount</th></tr>
                                    </thead>
                                    <tbody>
                        `;
                        refs.forEach((mca, index) => {
                            mcaHTML += `<tr><td>${index + 1}</td><td>${mca.mca_ref}</td><td>${parseFloat(mca.amount).toFixed(2)}</td></tr>`;
                        });
                        mcaHTML += `</tbody></table></div>`;
                    } else {
                        mcaHTML = '<p class="text-muted">No references found</p>';
                    }

                    let filesHTML = '';
                    if (data.file1_path || data.file2_path) {
                        filesHTML += '<div>';
                        if (data.file1_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file1_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 1
                            </a>`;
                        }
                        if (data.file2_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file2_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 2
                            </a>`;
                        }
                        filesHTML += '</div>';
                    } else {
                        filesHTML = '<p class="text-muted">No documents attached</p>';
                    }

                    $("#mgmtApprovalDetails").html(`
                        <h6 class="mb-2">Payment Information</h6>
                        <table class="table table-bordered table-sm info-table">
                            <tr><th>ID</th><td>${data.id}</td></tr>
                            <tr><th>Department</th><td>${data.department_name}</td></tr>
                            <tr><th>Beneficiary</th><td>${data.beneficiary}</td></tr>
                            <tr><th>Requestee</th><td>${data.requestee}</td></tr>
                            <tr><th>Client</th><td>${data.client_name}</td></tr>
                            <tr><th>Payment For</th><td>${data.pay_for}</td></tr>
                            <tr><th>Payment Type</th><td>${data.payment_type}</td></tr>
                            <tr><th>Currency</th><td>${data.currency_short_name}</td></tr>
                            <tr><th>Amount</th><td><strong>${parseFloat(data.amount).toFixed(2)}</strong></td></tr>
                            <tr><th>Expense Type</th><td>${data.expense_type_name}</td></tr>
                            <tr><th>Cash Collector</th><td>${data.cash_collector || 'N/A'}</td></tr>
                            <tr><th>Chargeback</th><td>${data.chargeback ? parseFloat(data.chargeback).toFixed(2) : 'N/A'}</td></tr>
                        </table>

                        <h6 class="mt-3 mb-2">Motif / Reason</h6>
                        <div class="alert alert-secondary p-2" style="font-size: 0.85rem;">${data.motif}</div>

                        <h6 class="mt-3 mb-2">Attached Documents</h6>
                        ${filesHTML}

                        <h6 class="mt-3 mb-2">References (${refs.length})</h6>
                        ${mcaHTML}
                    `);

                    $("#mgmtApproveBtn").data("id", id);
                    $("#mgmtRejectBtn").data("id", id);
                    $("#mgmtRejectSection").hide();
                    $("#mgmtRejectReason").val('');
                    var mgmtModal = new bootstrap.Modal(document.getElementById('mgmtApprovalModal'));
                    mgmtModal.show();
                }
            }
        });
    });

    $("#mgmtApproveBtn").click(function () {
        let id = $(this).data("id");

        $.post("<?php echo APP_URL; ?>payment/update_approval", {
            id: id,
            action: "management_approve"
        }, function (res) {
            if (res.success) {
                alert("✅ Management Approved Successfully");
                var modal = bootstrap.Modal.getInstance(document.getElementById('mgmtApprovalModal'));
                modal.hide();
                paymentTable.ajax.reload(null, false);
            } else {
                alert("❌ Failed: " + res.message);
            }
        }, "json");
    });

    $("#mgmtRejectBtn").click(function() {
        $("#mgmtRejectSection").show();
    });

    $("#mgmtSubmitRejectBtn").on("click", function() {
        let id = $("#mgmtApproveBtn").data("id");
        let reason = $("#mgmtRejectReason").val().trim();

        if (reason === "") {
            alert("Please enter a reason for rejection.");
            return;
        }

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/reject_request",
            type: "POST",
            data: {
                id: id,
                reject_type: "management",
                reason: reason
            },
            dataType: "json",
            success: function(res) {
                if (res.success) {
                    alert("✅ Rejected Successfully");
                    $("#mgmtRejectSection").hide();
                    $("#mgmtRejectReason").val("");
                    var modal = bootstrap.Modal.getInstance(document.getElementById('mgmtApprovalModal'));
                    modal.hide();
                    paymentTable.ajax.reload(null, false);
                } else {
                    alert("❌ " + res.message);
                }
            }
        });
    });

    // PAID APPROVAL
    $('#paymentRequestsTable').on('click', '.paid-approve', function (e) {
        e.preventDefault();
        e.stopPropagation();
        
        let id = $(this).data('id');

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_single",
            type: "POST",
            data: { id: id },
            dataType: "json",
            success: function(res) { 
                if (res.success) {
                    let data = res.data;
                    let refs = res.mca_refs || [];

                    const payForMap = {
                        0: "Import Tracking",
                        1: "Export Tracking",
                        2: "Local Tracking",
                        3: "Other",
                        4: "Pre Payment"
                    };
                    data.pay_for = payForMap[data.pay_for] || data.pay_for;

                    let mcaHTML = '';
                    if (refs.length > 0) {
                        mcaHTML = `
                            <div style="max-height: 150px; overflow-y: auto;">
                                <table class="table table-bordered table-sm">
                                    <thead>
                                        <tr><th>#</th><th>Reference</th><th>Amount</th></tr>
                                    </thead>
                                    <tbody>
                        `;
                        refs.forEach((mca, index) => {
                            mcaHTML += `<tr><td>${index + 1}</td><td>${mca.mca_ref}</td><td>${parseFloat(mca.amount).toFixed(2)}</td></tr>`;
                        });
                        mcaHTML += `</tbody></table></div>`;
                    } else {
                        mcaHTML = '<p class="text-muted">No references found</p>';
                    }

                    let filesHTML = '';
                    if (data.file1_path || data.file2_path) {
                        filesHTML += '<div>';
                        if (data.file1_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file1_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 1
                            </a>`;
                        }
                        if (data.file2_path) {
                            filesHTML += `<a href="<?php echo BASE_URL; ?>${data.file2_path}" target="_blank" class="file-link">
                                <i class="ti ti-file"></i> Document 2
                            </a>`;
                        }
                        filesHTML += '</div>';
                    } else {
                        filesHTML = '<p class="text-muted">No documents attached</p>';
                    }

                    $("#paidApprovalDetails").html(`
                        <h6 class="mb-2">Payment Information</h6>
                        <table class="table table-bordered table-sm info-table">
                            <tr><th>ID</th><td>${data.id}</td></tr>
                            <tr><th>Department</th><td>${data.department_name}</td></tr>
                            <tr><th>Beneficiary</th><td>${data.beneficiary}</td></tr>
                            <tr><th>Requestee</th><td>${data.requestee}</td></tr>
                            <tr><th>Client</th><td>${data.client_name}</td></tr>
                            <tr><th>Payment For</th><td>${data.pay_for}</td></tr>
                            <tr><th>Payment Type</th><td>${data.payment_type}</td></tr>
                            <tr><th>Currency</th><td>${data.currency_short_name}</td></tr>
                            <tr><th>Amount</th><td><strong>${parseFloat(data.amount).toFixed(2)}</strong></td></tr>
                            <tr><th>Expense Type</th><td>${data.expense_type_name}</td></tr>
                            <tr><th>Chargeback</th><td>${data.chargeback ? parseFloat(data.chargeback).toFixed(2) : 'N/A'}</td></tr>
                        </table>

                        <h6 class="mt-3 mb-2">Motif / Reason</h6>
                        <div class="alert alert-secondary p-2" style="font-size: 0.85rem;">${data.motif}</div>

                        <h6 class="mt-3 mb-2">Attached Documents</h6>
                        ${filesHTML}

                        <h6 class="mt-3 mb-2">References (${refs.length})</h6>
                        ${mcaHTML}
                    `);

                    $('#paidCashCollector').val(data.cash_collector || '');
                    $("#paidApproveBtn").data("id", id);
                    var paidModal = new bootstrap.Modal(document.getElementById('paidApprovalModal'));
                    paidModal.show();
                }
            }
        });
    });

    $("#paidApproveBtn").click(function () {
        let id = $(this).data("id");
        let cash_collector = $('#paidCashCollector').val().trim();

        if (!cash_collector) {
            alert("Please enter Cash Collector name");
            return;
        }

        let formData = new FormData();
        formData.append('id', id);
        formData.append('action', 'paid_approve');
        formData.append('cash_collector', cash_collector);

        let file3 = $('#paidFile3')[0].files[0];
        let file4 = $('#paidFile4')[0].files[0];

        if (file3) {
            formData.append('file3', file3);
        }
        if (file4) {
            formData.append('file4', file4);
        }

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/update_approval",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            dataType: "json",
            success: function(res) {
                if (res.success) {
                    alert("✅ Marked as Paid Successfully");
                    var modal = bootstrap.Modal.getInstance(document.getElementById('paidApprovalModal'));
                    modal.hide();
                    $('#paidFile3').val('');
                    $('#paidFile4').val('');
                    paymentTable.ajax.reload(null, false);
                } else {
                    alert("❌ Failed: " + res.message);
                }
            },
            error: function() {
                alert("❌ An error occurred");
            }
        });
    });

    // Select MCA References Modal WITH DUPLICATE CHECK
    $('#selectMcaRefsBtn').on('click', function () {
        let clientId = $('#client_id').val();
        let paymentfor = $('#pay_for').val();
        let expenseType = $('#expense_type').val();

        if (!clientId) {
            alert('Please select a client first');
            return;
        }
        if (!paymentfor) {
            alert('Please select a payment for');
            return;
        }
        if (!expenseType) {
            alert('Please select an expense type first');
            return;
        }

        $.ajax({
            url: "<?php echo APP_URL; ?>payment/get_mca_refs_by_client",
            type: "POST",
            data: { client_id: clientId, paymentfor: paymentfor },
            dataType: "json",
            success: function(res) {
                if (!res.success) {
                    alert(res.message);
                    return;
                }

                if (res.data.length === 0) {
                    alert('No MCA references found for this client');
                    return;
                }

                let html = '';
                res.data.forEach(item => {
                    html += `
                        <div class="mca-ref-item">
                            <input class="form-check-input mca-ref-check"
                                type="checkbox"
                                id="mca_${item.mca_ref}"
                                data-ref="${item.mca_ref}"
                                data-amount="0">
                            <label class="form-check-label" for="mca_${item.mca_ref}">
                                <b>${item.mca_ref}</b>
                            </label>
                        </div>
                    `;
                });

                $('#mcaRefList').html(html);
                $('#mcaSearchInput').val('');
                var mcaModal = new bootstrap.Modal(document.getElementById('mcaRefModal'));
                mcaModal.show();
            }
        });
    });

    $('#applyMcaRefsBtn').on('click', function () {
        let selectedRefs = [];
        let hasError = false;
        
        $('.mca-ref-check:checked').each(function () {
            selectedRefs.push($(this).data('ref'));
        });
        
        if (selectedRefs.length === 0) {
            alert('Please select at least one reference');
            return;
        }

        // CHECK DUPLICATES FOR ALL SELECTED REFS
        let checksCompleted = 0;
        
        selectedRefs.forEach(function(ref) {
            checkMcaDuplicate(ref, function(isDuplicate) {
                checksCompleted++;
                
                if (isDuplicate) {
                    hasError = true;
                }
                
                // WHEN ALL CHECKS COMPLETE
                if (checksCompleted === selectedRefs.length) {
                    if (!hasError) {
                        // ADD ALL REFS
                        $('#mcaFilesList').html('');
                        
                        selectedRefs.forEach(function(ref) {
                            addMcaRow(ref, 0);
                        });
                        
                        calculateMcaTotal();
                        var modal = bootstrap.Modal.getInstance(document.getElementById('mcaRefModal'));
                        modal.hide();
                    } else {
                        alert('Some references are already used for this expense type. Please deselect them and try again.');
                    }
                }
            });
        });
    });

    // Export to Excel
    $('#exportToExcelBtn').on('click', function() {
        $.ajax({
            url: "<?php echo APP_URL; ?>payment/export_to_excel",
            type: "POST",
            dataType: "json",
            success: function(res) {
                if (res.success && res.data.length > 0) {
                    const payForMap = {
                        '0': 'Import Tracking',
                        '1': 'Export Tracking',
                        '2': 'Local Tracking',
                        '3': 'Other',
                        '4': 'Pre Payment'
                    };

                    let exportData = res.data.map(row => ({
                        'ID': row.id,
                        'Department': row.department_name,
                        'Beneficiary': row.beneficiary,
                        'Requestee': row.requestee,
                        'Client': row.client_name,
                        'Payment For': payForMap[row.pay_for] || 'N/A',
                        'Payment Type': row.payment_type,
                        'Expense Type': row.expense_type_name,
                        'Currency': row.currency_short_name,
                        'Amount': parseFloat(row.amount).toFixed(2),
                        'Location': row.main_location_name,
                        'Cash Collector': row.cash_collector || 'N/A',
                        'Motif': row.motif,
                        'Date': row.created_at
                    }));

                    let ws = XLSX.utils.json_to_sheet(exportData);
                    let wb = XLSX.utils.book_new();
                    XLSX.utils.book_append_sheet(wb, ws, "Payment Requests");
                    
                    XLSX.writeFile(wb, "Payment_Requests_" + new Date().toISOString().slice(0,10) + ".xlsx");
                } else {
                    alert('No data to export');
                }
            },
            error: function() {
                alert('Failed to export data');
            }
        });
    });

    function renumberMcaRows() {
        $('#mcaFilesList tr').each(function (index) {
            const firstCell = $(this).find('td:first-child');
            if (!firstCell.attr('colspan')) {
                firstCell.text(index + 1);
            }
        });
    }

    function calculateMcaTotal() {
        let total = 0;
        $('.mca-amount-input').each(function () {
            const value = parseFloat($(this).val()) || 0;
            total += value;
        });
        $('#mca_total_amount').text(total.toFixed(2));
    }

    $('#mcaFilesList').on('input', '.mca-amount-input', calculateMcaTotal);

    function importExcelFile(input) {
        try {
            if (!input.files || !input.files[0]) {
                return;
            }

            const file = input.files[0];
            const reader = new FileReader();

            reader.onload = function (e) {
                try {
                    const data = e.target.result;
                    const workbook = XLSX.read(data, {
                        type: 'binary',
                        cellDates: true,
                        cellNF: false,
                        cellText: false
                    });

                    const firstSheetName = workbook.SheetNames[0];
                    const worksheet = workbook.Sheets[firstSheetName];
                    const json = XLSX.utils.sheet_to_json(worksheet, {
                        raw: false,
                        dateNF: 'yyyy-mm-dd',
                        header: 1,
                        defval: ''
                    });

                    if (json.length > 0) {
                        const firstRow = json[0];
                        let isHeader = false;

                        if (firstRow.some(cell => {
                                const cellText = String(cell).toLowerCase();
                                return cellText.includes('mca') ||
                                    cellText.includes('reference') ||
                                    cellText.includes('ref') ||
                                    cellText.includes('amount');
                            })) {
                            isHeader = true;
                        }

                        if (isHeader) {
                            json.shift();
                        }
                    }

                    let mcaRefColumn = 0;
                    let amountColumn = 1;

                    const existingRows = document.querySelectorAll('#mcaFilesList tr');
                    if (existingRows.length > 0 && json.length > 0) {
                        if (confirm('Do you want to replace existing MCA references? Click OK to replace, Cancel to append.')) {
                            document.getElementById('mcaFilesList').innerHTML = '';
                        }
                    }

                    processImportedData(json, mcaRefColumn, amountColumn);
                } catch (error) {
                    console.error("Error processing Excel file:", error);
                    alert('Failed to process the Excel file. Please check the file format.');
                }
            };

            reader.onerror = function () {
                console.error("File reading error");
                alert('Failed to read the Excel file.');
            };

            reader.readAsBinaryString(file);
            input.value = '';
        } catch (error) {
            console.error("Error in importExcelFile:", error);
            alert('An unexpected error occurred while importing the file.');
        }
    }

    function processImportedData(json, mcaRefColumn, amountColumn) {
        try {
            let validRows = 0;

            json.forEach(row => {
                if (row && row.length > 0 && row[mcaRefColumn]) {
                    const mcaRef = row[mcaRefColumn].toString().trim();
                    const amount = row.length > amountColumn && row[amountColumn]
                        ? parseFloat(row[amountColumn]) || 0
                        : 0;

                    if (mcaRef) {
                        addMcaRow(mcaRef, amount);
                        validRows++;
                    }
                }
            });

            const numMcaRefs = document.getElementById('num_mca_refs');
            if (numMcaRefs) {
                const currentRows = document.querySelectorAll('#mcaFilesList tr').length;
                numMcaRefs.value = currentRows;
            }

            calculateMcaTotal();
            alert(`✅ ${validRows} MCA references were imported successfully.`);

        } catch (error) {
            console.error("Error processing imported data:", error);
            alert('Failed to process the imported data.');
        }
    }
});
</script>

<?php 
if (file_exists(VIEW_PATH . 'layouts/partials/footer.php')) {
  include(VIEW_PATH . 'layouts/partials/footer.php'); 
}
?>