<link href="<?= BASE_URL ?>/assets/pages/css/local_styles.css" rel="stylesheet" type="text/css">

<style>
  .dataTables_wrapper .dataTables_info { float: left; }
  .dataTables_wrapper .dataTables_paginate { float: right; text-align: right; }
  
  .card { border: none; border-radius: 10px; box-shadow: 0 2px 15px rgba(0,0,0,0.08); }
  .card-header { background: white; border-bottom: 1px solid #eee; padding: 15px 20px; }
  .header-title { font-size: 1.1rem; font-weight: 600; color: #2C3E50; }
  
  .btn-export-all {
    background: linear-gradient(135deg, #28a745, #20c997) !important;
    color: white !important;
    border: none !important;
    padding: 8px 18px !important;
    border-radius: 6px !important;
    font-weight: 500 !important;
    font-size: 0.85rem !important;
  }
  .btn-export-all:hover { transform: translateY(-1px); box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3) !important; }
  
  .btn-view {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
    border: none;
    width: 32px;
    height: 32px;
    padding: 0;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border-radius: 6px;
  }
  .btn-view:hover { color: white; transform: scale(1.1); box-shadow: 0 3px 10px rgba(102, 126, 234, 0.4); }
  
  .btn-primary { background: linear-gradient(135deg, #3498DB, #2980B9); border: none; }
  .btn-danger { background: linear-gradient(135deg, #e74c3c, #c0392b); border: none; }
  
  .modal-content { border: none; border-radius: 12px; overflow: hidden; }
  .modal-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 18px 25px; }
  .modal-header .btn-close { filter: brightness(0) invert(1); }
  .modal-body { padding: 25px; }
  
  .value-box {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 12px;
    text-align: center;
    margin-bottom: 12px;
  }
  .value-box:hover { background: #fff; box-shadow: 0 2px 8px rgba(0,0,0,0.08); }
  .value-box .value-label { font-size: 0.7rem; color: #7f8c8d; margin-bottom: 4px; text-transform: uppercase; }
  .value-box .value-number { font-size: 1rem; font-weight: 700; color: #2C3E50; }
  .value-box-license { border-left: 3px solid #3498DB; }
  .value-box-used { border-left: 3px solid #F39C12; }
  .value-box-available { border-left: 3px solid #9B59B6; }
  .value-box-calculated { border-left: 3px solid #1ABC9C; }

  .excel-form-wrapper {
    overflow-x: auto;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    margin-bottom: 15px;
    background: #fafafa;
  }
  
  .excel-form-table {
    width: max-content;
    min-width: 100%;
    border-collapse: collapse;
    background: white;
  }
  
  .excel-form-table th {
    background: linear-gradient(180deg, #f8f9fa, #e9ecef);
    border: 1px solid #ddd;
    padding: 10px 12px;
    font-size: 0.78rem;
    font-weight: 600;
    color: #495057;
    text-align: center;
    white-space: nowrap;
    min-width: 120px;
    text-transform: uppercase;
  }
  
  .excel-form-table td {
    border: 1px solid #ddd;
    padding: 8px;
    vertical-align: middle;
    background: white;
  }
  
  .excel-form-table input {
    width: 100%;
    border: 1px solid #ddd;
    padding: 8px 10px;
    font-size: 0.85rem;
    border-radius: 5px;
  }
  
  .excel-form-table input:focus {
    border-color: #667eea;
    outline: none;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.15);
  }
  
  .excel-form-table .readonly-cell input {
    background: #f5f5f5;
    color: #555;
    font-weight: 600;
    cursor: not-allowed;
  }
  
  .excel-form-table th.section-license { background: linear-gradient(135deg, #3498DB, #2980B9); color: white; }
  .excel-form-table th.section-used { background: linear-gradient(135deg, #F39C12, #E67E22); color: white; }
  .excel-form-table th.section-available { background: linear-gradient(135deg, #9B59B6, #8E44AD); color: white; }
  .excel-form-table th.section-calculated { background: linear-gradient(135deg, #1ABC9C, #16A085); color: white; }
  
  .license-info-bar {
    background: linear-gradient(135deg, #f8f9fa, #fff);
    border: 1px solid #e9ecef;
    border-left: 4px solid #667eea;
    border-radius: 8px;
    padding: 12px 18px;
    margin-bottom: 15px;
    display: flex;
    flex-wrap: wrap;
    gap: 25px;
    align-items: center;
  }
  
  .license-info-bar .info-item { display: flex; align-items: center; gap: 8px; }
  .license-info-bar .info-label { font-size: 0.72rem; color: #7f8c8d; font-weight: 600; text-transform: uppercase; }
  .license-info-bar .info-value { font-size: 0.9rem; color: #2C3E50; font-weight: 600; }
  
  .edit-mode-note {
    background: linear-gradient(135deg, #fff3cd, #ffeeba);
    border: 1px solid #ffc107;
    border-radius: 8px;
    padding: 10px 15px;
    font-size: 0.85rem;
    color: #856404;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    gap: 10px;
  }
  
  .scroll-hint { font-size: 0.75rem; color: #aaa; text-align: center; margin-top: 8px; font-style: italic; }
  
  .count-badge {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 35px;
    height: 28px;
    padding: 0 10px;
    border-radius: 15px;
    font-weight: 600;
    font-size: 0.85rem;
    cursor: pointer;
  }
  
  .count-badge.has-records { background: linear-gradient(135deg, #667eea, #764ba2); color: white; }
  .count-badge.has-records:hover { transform: scale(1.1); box-shadow: 0 3px 12px rgba(102, 126, 234, 0.4); }
  .count-badge.no-records { background: #e9ecef; color: #6c757d; cursor: default; }
  
  .records-list-container { max-height: 400px; overflow-y: auto; padding-right: 5px; }
  .records-list-container::-webkit-scrollbar { width: 6px; }
  .records-list-container::-webkit-scrollbar-track { background: #f1f1f1; border-radius: 3px; }
  .records-list-container::-webkit-scrollbar-thumb { background: #c1c1c1; border-radius: 3px; }
  
  .record-item {
    background: #fff;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 12px;
    border-left: 4px solid #667eea;
  }
  .record-item:hover { box-shadow: 0 3px 12px rgba(0,0,0,0.08); transform: translateX(3px); }
  
  .record-item .record-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
    padding-bottom: 8px;
    border-bottom: 1px dashed #eee;
  }
  
  .record-item .record-title { font-weight: 600; color: #2C3E50; font-size: 0.95rem; }
  .record-item .record-id { background: #667eea; color: white; padding: 2px 10px; border-radius: 12px; font-size: 0.75rem; }
  
  .record-item .record-details { display: grid; grid-template-columns: repeat(auto-fit, minmax(140px, 1fr)); gap: 10px; }
  .record-item .detail-item { background: #f8f9fa; padding: 8px 10px; border-radius: 5px; }
  .record-item .detail-label { font-size: 0.7rem; color: #7f8c8d; text-transform: uppercase; margin-bottom: 2px; }
  .record-item .detail-value { font-size: 0.85rem; font-weight: 600; color: #2C3E50; }
  
  .empty-state { text-align: center; padding: 40px 20px; color: #aaa; }
  .empty-state i { font-size: 3rem; margin-bottom: 15px; opacity: 0.5; }
  
  .section-title {
    font-size: 0.85rem;
    font-weight: 600;
    color: #667eea;
    margin: 15px 0 10px;
    padding-bottom: 5px;
    border-bottom: 2px solid #667eea;
    display: inline-block;
  }
  .section-title.calculated { color: #1ABC9C; border-bottom-color: #1ABC9C; }
  
  .badge { padding: 5px 10px; font-size: 0.8rem; border-radius: 5px; }
  
  #partielleTable { font-size: 0.9rem; }
  #partielleTable thead th {
    background: linear-gradient(180deg, #f8f9fa, #e9ecef);
    font-weight: 600;
    font-size: 0.8rem;
    text-transform: uppercase;
    color: #495057;
  }
  
  .edit-form-card { border-left: 4px solid #9B59B6; }
</style>

<div class="page-content">
  <div class="page-container">
    <div class="row">
      <div class="col-12">

        <!-- Edit AV Details Form Card -->
        <div class="card mb-4 edit-form-card" id="editFormCard" style="display:none;">
          <div class="card-header d-flex align-items-center justify-content-between">
            <h4 class="header-title mb-0">
              <i class="ti ti-edit me-2" style="color: #9B59B6;"></i> 
              <span>Edit AV Details</span>
              <small class="text-muted ms-2" id="editingPartielle"></small>
            </h4>
            <button type="button" class="btn btn-sm btn-outline-secondary" id="closeFormBtn">
              <i class="ti ti-x"></i> Close
            </button>
          </div>

          <div class="card-body">
            <form id="partielleForm" method="post" novalidate>
              <input type="hidden" name="csrf_token" id="csrf_token" value="<?= $csrf_token ?>">
              <input type="hidden" name="partielle_id" id="partielle_id" value="">
              <input type="hidden" name="action" id="formAction" value="update">

              <div id="licenseInfoBar" class="license-info-bar">
                <div class="info-item">
                  <span class="info-label">PARTIELLE:</span>
                  <span class="info-value" id="info_partial_name">-</span>
                </div>
                <div class="info-item">
                  <span class="info-label">License:</span>
                  <span class="info-value" id="info_license_number">-</span>
                </div>
                <div class="info-item">
                  <span class="info-label">CRF:</span>
                  <span class="info-value" id="info_crf">-</span>
                </div>
                <div class="info-item">
                  <span class="info-label">Supplier:</span>
                  <span class="info-value" id="info_supplier">-</span>
                </div>
              </div>

              <div class="edit-mode-note">
                <i class="ti ti-info-circle" style="font-size: 1.2rem;"></i>
                <span>Only <span style="color: #9B59B6; font-weight: 700;">AV Balance</span> fields (purple) can be edited. Calculated fields (green) auto-update.</span>
              </div>

              <div class="excel-form-wrapper">
                <table class="excel-form-table">
                  <thead>
                    <tr>
                      <th class="section-license">License Weight</th>
                      <th class="section-license">License FOB</th>
                      <th class="section-license">License Insurance</th>
                      <th class="section-license">License Freight</th>
                      <th class="section-license">License Other</th>
                      
                      <th class="section-used">Used Weight</th>
                      <th class="section-used">Used FOB</th>
                      <th class="section-used">Used Insurance</th>
                      <th class="section-used">Used Freight</th>
                      <th class="section-used">Used Other</th>
                      
                      <th class="section-available">AV Weight</th>
                      <th class="section-available">AV FOB</th>
                      <th class="section-available">AV Insurance</th>
                      <th class="section-available">AV Freight</th>
                      <th class="section-available">AV Other</th>
                      
                      <th class="section-calculated">Lic - AV Weight</th>
                      <th class="section-calculated">Lic - AV FOB</th>
                      <th class="section-calculated">AV - Used Weight</th>
                      <th class="section-calculated">AV - Used FOB</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td class="readonly-cell"><input type="number" step="0.01" id="license_weight_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="license_fob_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="license_insurance_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="license_freight_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="license_other_costs_display" readonly></td>
                      
                      <td class="readonly-cell"><input type="number" step="0.01" id="partial_weight_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="partial_fob_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="partial_insurance_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="partial_freight_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="partial_other_costs_display" readonly></td>
                      
                      <td><input type="number" step="0.01" name="av_weight" id="av_weight" min="0" placeholder="0.00"></td>
                      <td><input type="number" step="0.01" name="av_fob" id="av_fob" min="0" placeholder="0.00"></td>
                      <td><input type="number" step="0.01" name="av_insurance" id="av_insurance" min="0" placeholder="0.00"></td>
                      <td><input type="number" step="0.01" name="av_freight" id="av_freight" min="0" placeholder="0.00"></td>
                      <td><input type="number" step="0.01" name="av_other_costs" id="av_other_costs" min="0" placeholder="0.00"></td>
                      
                      <td class="readonly-cell"><input type="number" step="0.01" id="licenseweight_avweight_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="licensefob_avfob_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="avweight_usedweight_display" readonly></td>
                      <td class="readonly-cell"><input type="number" step="0.01" id="avfob_usedfob_display" readonly></td>
                    </tr>
                  </tbody>
                </table>
              </div>
              <div class="scroll-hint">← Scroll horizontally to see all fields →</div>

              <div class="row mt-3">
                <div class="col-12 text-end">
                  <button type="button" class="btn btn-outline-secondary btn-sm" id="cancelBtn">
                    <i class="ti ti-x me-1"></i> Cancel
                  </button>
                  <button type="submit" class="btn btn-primary btn-sm ms-2" id="submitBtn">
                    <i class="ti ti-check me-1"></i> Update AV Details
                  </button>
                </div>
              </div>

            </form>
          </div>
        </div>

        <!-- PARTIELLE DataTable -->
        <div class="card">
          <div class="card-header d-flex align-items-center justify-content-between">
            <h4 class="header-title mb-0"><i class="ti ti-list me-2" style="color: #667eea;"></i> PARTIELLE List</h4>
            <button type="button" class="btn btn-export-all" id="exportAllBtn">
              <i class="ti ti-file-spreadsheet me-1"></i> Export All
            </button>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table id="partielleTable" class="table table-striped table-bordered dt-responsive nowrap w-100">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>PARTIELLE Name</th>
                    <th>License</th>
                    <th>CRF Ref</th>
                    <th>Supplier</th>
                    <th>Used Weight</th>
                    <th>Used FOB</th>
                    <th>AV-Used Weight</th>
                    <th>AV-Used FOB</th>
                    <th>Records</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
  <?php include(VIEW_PATH . 'layouts/partials/footer.php'); ?>
</div>

<!-- View Details Modal -->
<div class="modal fade" id="viewPartielleModal" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"><i class="ti ti-eye me-2"></i> PARTIELLE Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="modalDetailsContent"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Records List Modal -->
<div class="modal fade" id="recordsListModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">
          <i class="ti ti-file-text me-2"></i> 
          <span id="recordsModalTitle">Records</span>
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="records-list-container" id="recordsListContent"></div>
      </div>
      <div class="modal-footer">
        <span class="me-auto text-muted" id="recordsCount"></span>
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function () {

  const csrfToken = $('#csrf_token').val();

  function formatDate(dateStr) {
    if (!dateStr) return '-';
    const d = new Date(dateStr);
    return `${String(d.getDate()).padStart(2,'0')}-${String(d.getMonth()+1).padStart(2,'0')}-${d.getFullYear()}`;
  }

  function hideForm() {
    $('#editFormCard').slideUp(300);
    $('#partielleForm')[0].reset();
    $('#partielle_id').val('');
  }

  $('#closeFormBtn, #cancelBtn').on('click', hideForm);

  // Auto-calculate derived fields (SUBTRACTION)
  function calculateDerivedFields() {
    const licenseWeight = parseFloat($('#license_weight_display').val()) || 0;
    const licenseFob = parseFloat($('#license_fob_display').val()) || 0;
    const usedWeight = parseFloat($('#partial_weight_display').val()) || 0;
    const usedFob = parseFloat($('#partial_fob_display').val()) || 0;
    const avWeight = parseFloat($('#av_weight').val()) || 0;
    const avFob = parseFloat($('#av_fob').val()) || 0;

    // SUBTRACTION operations
    $('#licenseweight_avweight_display').val((licenseWeight - avWeight).toFixed(2));
    $('#licensefob_avfob_display').val((licenseFob - avFob).toFixed(2));
    $('#avweight_usedweight_display').val((avWeight - usedWeight).toFixed(2));
    $('#avfob_usedfob_display').val((avFob - usedFob).toFixed(2));
  }

  $('#av_weight, #av_fob').on('input', calculateDerivedFields);

  // DataTable
  var partielleTable = $('#partielleTable').DataTable({
    processing: true,
    serverSide: true,
    ajax: {
      url: '<?= APP_URL ?>/bivac/crudData/listing',
      type: 'GET',
      error: function() {
        Swal.fire('Error', 'Failed to load data', 'error');
      }
    },
    columns: [
      { data: 'id' },
      { data: 'partial_name' },
      { data: 'license_number' },
      { data: 'ref_cod' },
      { data: 'supplier' },
      { 
        data: 'partial_weight',
        render: d => '<span class="badge bg-warning text-dark">' + parseFloat(d||0).toFixed(2) + ' KG</span>'
      },
      { 
        data: 'partial_fob',
        render: d => '<span class="badge bg-success">' + parseFloat(d||0).toFixed(2) + '</span>'
      },
      { 
        data: 'avweight_usedweight',
        render: d => {
          const val = parseFloat(d||0);
          const cls = val >= 0 ? 'bg-info' : 'bg-danger';
          return '<span class="badge ' + cls + '">' + val.toFixed(2) + ' KG</span>';
        }
      },
      { 
        data: 'avfob_usedfob',
        render: d => {
          const val = parseFloat(d||0);
          const cls = val >= 0 ? 'bg-info' : 'bg-danger';
          return '<span class="badge ' + cls + '">' + val.toFixed(2) + '</span>';
        }
      },
      { 
        data: 'import_count',
        render: function(d, t, row) {
          const count = d || 0;
          if (count > 0) {
            return `<span class="count-badge has-records" data-partial-name="${row.partial_name}" data-count="${count}">${count}</span>`;
          } else {
            return `<span class="count-badge no-records">0</span>`;
          }
        }
      },
      {
        data: null,
        orderable: false,
        render: (d, t, row) => `
          <button class="btn btn-sm btn-view viewBtn" data-id="${row.id}"><i class="ti ti-eye"></i></button>
          <button class="btn btn-sm btn-primary editBtn" data-id="${row.id}" style="width:32px;height:32px;padding:0;"><i class="ti ti-edit"></i></button>
          <button class="btn btn-sm btn-danger deleteBtn" data-id="${row.id}" style="width:32px;height:32px;padding:0;"><i class="ti ti-trash"></i></button>
        `
      }
    ],
    order: [[0, 'desc']],
    pageLength: 25,
    responsive: true
  });

  // Records modal
  $(document).on('click', '.count-badge.has-records', function() {
    const partialName = $(this).data('partial-name');
    const count = $(this).data('count');
    
    $('#recordsModalTitle').text('Records for: ' + partialName);
    $('#recordsCount').text('Total: ' + count + ' record(s)');
    
    $('#recordsListContent').html(`
      <div class="text-center py-4">
        <div class="spinner-border text-primary"></div>
        <p class="mt-2 text-muted">Loading records...</p>
      </div>
    `);
    
    $('#recordsListModal').modal('show');
    
    $.ajax({
      url: '<?= APP_URL ?>/bivac/crudData/getPartielleRecords',
      method: 'GET',
      data: { partial_name: partialName },
      dataType: 'json',
      success: function(res) {
        if (res.success && res.data && res.data.length > 0) {
          let html = '';
          res.data.forEach(function(record) {
            html += `
              <div class="record-item">
                <div class="record-header">
                  <span class="record-title">${record.bl_number || 'N/A'}</span>
                  <span class="record-id">#${record.id}</span>
                </div>
                <div class="record-details">
                  <div class="detail-item">
                    <div class="detail-label">Weight</div>
                    <div class="detail-value">${parseFloat(record.weight || 0).toFixed(2)} KG</div>
                  </div>
                  <div class="detail-item">
                    <div class="detail-label">FOB</div>
                    <div class="detail-value">${parseFloat(record.fob || 0).toFixed(2)}</div>
                  </div>
                  <div class="detail-item">
                    <div class="detail-label">Client</div>
                    <div class="detail-value">${record.client_name || 'N/A'}</div>
                  </div>
                  <div class="detail-item">
                    <div class="detail-label">Status</div>
                    <div class="detail-value">${record.status || 'N/A'}</div>
                  </div>
                  <div class="detail-item">
                    <div class="detail-label">Date</div>
                    <div class="detail-value">${formatDate(record.created_at)}</div>
                  </div>
                </div>
              </div>
            `;
          });
          $('#recordsListContent').html(html);
        } else {
          $('#recordsListContent').html(`<div class="empty-state"><i class="ti ti-file-off"></i><p>No records found</p></div>`);
        }
      },
      error: function() {
        $('#recordsListContent').html(`<div class="empty-state"><i class="ti ti-alert-circle"></i><p>Failed to load records</p></div>`);
      }
    });
  });

  // Export
  $('#exportAllBtn').on('click', function() {
    Swal.fire({ title: 'Exporting...', didOpen: () => Swal.showLoading() });
    window.location.href = '<?= APP_URL ?>/bivac/crudData/exportAll';
    setTimeout(() => Swal.close(), 2000);
  });

  // View
  $(document).on('click', '.viewBtn', function() {
    const id = $(this).data('id');
    Swal.fire({ title: 'Loading...', didOpen: () => Swal.showLoading() });
    
    $.get('<?= APP_URL ?>/bivac/crudData/getPartielle', { id }, function(res) {
      Swal.close();
      if (res.success && res.data) {
        const d = res.data;
        $('#modalDetailsContent').html(`
          <h5 class="text-center mb-4" style="color: #667eea;">${d.partial_name}</h5>
          
          <div class="row mb-3">
            <div class="col-md-4"><div class="value-box value-box-license"><div class="value-label">License</div><div class="value-number">${d.license_number||'N/A'}</div></div></div>
            <div class="col-md-4"><div class="value-box value-box-license"><div class="value-label">CRF</div><div class="value-number">${d.ref_cod||'N/A'}</div></div></div>
            <div class="col-md-4"><div class="value-box value-box-license"><div class="value-label">Supplier</div><div class="value-number">${d.supplier||'N/A'}</div></div></div>
          </div>
          
          <span class="section-title">License Original Values</span>
          <div class="row">
            <div class="col"><div class="value-box value-box-license"><div class="value-label">Weight</div><div class="value-number">${parseFloat(d.license_weight||0).toFixed(2)} KG</div></div></div>
            <div class="col"><div class="value-box value-box-license"><div class="value-label">FOB</div><div class="value-number">${parseFloat(d.license_fob||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-license"><div class="value-label">Insurance</div><div class="value-number">${parseFloat(d.license_insurance||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-license"><div class="value-label">Freight</div><div class="value-number">${parseFloat(d.license_freight||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-license"><div class="value-label">Other</div><div class="value-number">${parseFloat(d.license_other_costs||0).toFixed(2)}</div></div></div>
          </div>
          
          <span class="section-title">Used Values</span>
          <div class="row">
            <div class="col"><div class="value-box value-box-used"><div class="value-label">Weight</div><div class="value-number">${parseFloat(d.partial_weight||0).toFixed(2)} KG</div></div></div>
            <div class="col"><div class="value-box value-box-used"><div class="value-label">FOB</div><div class="value-number">${parseFloat(d.partial_fob||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-used"><div class="value-label">Insurance</div><div class="value-number">${parseFloat(d.partial_insurance||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-used"><div class="value-label">Freight</div><div class="value-number">${parseFloat(d.partial_freight||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-used"><div class="value-label">Other</div><div class="value-number">${parseFloat(d.partial_other_costs||0).toFixed(2)}</div></div></div>
          </div>
          
          <span class="section-title">AV Balance</span>
          <div class="row">
            <div class="col"><div class="value-box value-box-available"><div class="value-label">Weight</div><div class="value-number">${parseFloat(d.av_weight||0).toFixed(2)} KG</div></div></div>
            <div class="col"><div class="value-box value-box-available"><div class="value-label">FOB</div><div class="value-number">${parseFloat(d.av_fob||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-available"><div class="value-label">Insurance</div><div class="value-number">${parseFloat(d.av_insurance||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-available"><div class="value-label">Freight</div><div class="value-number">${parseFloat(d.av_freight||0).toFixed(2)}</div></div></div>
            <div class="col"><div class="value-box value-box-available"><div class="value-label">Other</div><div class="value-number">${parseFloat(d.av_other_costs||0).toFixed(2)}</div></div></div>
          </div>
          
          <span class="section-title calculated">Calculated Values (Subtraction)</span>
          <div class="row">
            <div class="col-md-3"><div class="value-box value-box-calculated"><div class="value-label">License - AV Weight</div><div class="value-number">${parseFloat(d.licenseweight_avweight||0).toFixed(2)} KG</div></div></div>
            <div class="col-md-3"><div class="value-box value-box-calculated"><div class="value-label">License - AV FOB</div><div class="value-number">${parseFloat(d.licensefob_avfob||0).toFixed(2)}</div></div></div>
            <div class="col-md-3"><div class="value-box value-box-calculated"><div class="value-label">AV - Used Weight</div><div class="value-number">${parseFloat(d.avweight_usedweight||0).toFixed(2)} KG</div></div></div>
            <div class="col-md-3"><div class="value-box value-box-calculated"><div class="value-label">AV - Used FOB</div><div class="value-number">${parseFloat(d.avfob_usedfob||0).toFixed(2)}</div></div></div>
          </div>
          
          <div class="row mt-4 pt-3 border-top">
            <div class="col-6"><small class="text-muted"><i class="ti ti-calendar me-1"></i>Created: ${formatDate(d.created_at)}</small></div>
            <div class="col-6 text-end"><small class="text-muted"><i class="ti ti-calendar me-1"></i>Updated: ${d.updated_at ? formatDate(d.updated_at) : 'N/A'}</small></div>
          </div>
        `);
        $('#viewPartielleModal').modal('show');
      } else {
        Swal.fire('Error', res.message || 'Failed to load', 'error');
      }
    }, 'json').fail(() => {
      Swal.close();
      Swal.fire('Error', 'Failed to load data', 'error');
    });
  });

  // Edit
  $(document).on('click', '.editBtn', function() {
    const id = $(this).data('id');
    Swal.fire({ title: 'Loading...', didOpen: () => Swal.showLoading() });
    
    $.get('<?= APP_URL ?>/bivac/crudData/getPartielle', { id }, function(res) {
      Swal.close();
      if (res.success && res.data) {
        const d = res.data;
        
        $('#partielle_id').val(d.id);
        $('#editingPartielle').text('(' + d.partial_name + ')');
        
        $('#info_partial_name').text(d.partial_name || '');
        $('#info_license_number').text(d.license_number || '');
        $('#info_crf').text(d.ref_cod || '');
        $('#info_supplier').text(d.supplier || '');

        $('#license_weight_display').val(parseFloat(d.license_weight||0).toFixed(2));
        $('#license_fob_display').val(parseFloat(d.license_fob||0).toFixed(2));
        $('#license_insurance_display').val(parseFloat(d.license_insurance||0).toFixed(2));
        $('#license_freight_display').val(parseFloat(d.license_freight||0).toFixed(2));
        $('#license_other_costs_display').val(parseFloat(d.license_other_costs||0).toFixed(2));

        $('#partial_weight_display').val(parseFloat(d.partial_weight||0).toFixed(2));
        $('#partial_fob_display').val(parseFloat(d.partial_fob||0).toFixed(2));
        $('#partial_insurance_display').val(parseFloat(d.partial_insurance||0).toFixed(2));
        $('#partial_freight_display').val(parseFloat(d.partial_freight||0).toFixed(2));
        $('#partial_other_costs_display').val(parseFloat(d.partial_other_costs||0).toFixed(2));

        $('#av_weight').val(parseFloat(d.av_weight||0).toFixed(2));
        $('#av_fob').val(parseFloat(d.av_fob||0).toFixed(2));
        $('#av_insurance').val(parseFloat(d.av_insurance||0).toFixed(2));
        $('#av_freight').val(parseFloat(d.av_freight||0).toFixed(2));
        $('#av_other_costs').val(parseFloat(d.av_other_costs||0).toFixed(2));

        $('#licenseweight_avweight_display').val(parseFloat(d.licenseweight_avweight||0).toFixed(2));
        $('#licensefob_avfob_display').val(parseFloat(d.licensefob_avfob||0).toFixed(2));
        $('#avweight_usedweight_display').val(parseFloat(d.avweight_usedweight||0).toFixed(2));
        $('#avfob_usedfob_display').val(parseFloat(d.avfob_usedfob||0).toFixed(2));

        $('#editFormCard').slideDown(300);
        $('html, body').animate({ scrollTop: $('#editFormCard').offset().top - 20 }, 300);
      } else {
        Swal.fire('Error', res.message || 'Failed to load', 'error');
      }
    }, 'json').fail(() => {
      Swal.close();
      Swal.fire('Error', 'Failed to load data', 'error');
    });
  });

  // Submit
  $('#partielleForm').on('submit', function(e) {
    e.preventDefault();
    
    const id = $('#partielle_id').val();
    if (!id) {
      Swal.fire('Error', 'No PARTIELLE selected', 'error');
      return;
    }

    const btn = $('#submitBtn');
    const orig = btn.html();
    btn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm"></i> Updating...');

    const formData = new FormData(this);
    formData.set('csrf_token', csrfToken);
    
    $.ajax({
      url: '<?= APP_URL ?>/bivac/crudData/update',
      method: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      dataType: 'json',
      success: function(res) {
        btn.prop('disabled', false).html(orig);
        if (res.success) {
          Swal.fire({ icon: 'success', title: 'Success!', text: res.message, timer: 1500, showConfirmButton: false });
          hideForm();
          partielleTable.ajax.reload(null, false);
        } else {
          Swal.fire('Error', res.message || 'Update failed', 'error');
        }
      },
      error: function(xhr) {
        btn.prop('disabled', false).html(orig);
        Swal.fire('Error', xhr.status === 403 ? 'Token expired. Refresh page.' : 'Server error', 'error');
      }
    });
  });

  // Delete
  $(document).on('click', '.deleteBtn', function() {
    const id = $(this).data('id');
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#6c757d',
      confirmButtonText: 'Yes, delete!'
    }).then((result) => {
      if (result.isConfirmed) {
        $.post('<?= APP_URL ?>/bivac/crudData/deletion', { id, csrf_token: csrfToken }, function(res) {
          if (res.success) {
            Swal.fire({ icon: 'success', title: 'Deleted!', timer: 1500, showConfirmButton: false });
            hideForm();
            partielleTable.ajax.reload(null, false);
          } else {
            Swal.fire('Error', res.message || 'Delete failed', 'error');
          }
        }, 'json').fail(() => {
          Swal.fire('Error', 'Failed to delete', 'error');
        });
      }
    });
  });

});
</script>