<!-- FILE: views/tracking/imports.php -->
<link href="<?= BASE_URL ?>/assets/pages/css/local_styles.css" rel="stylesheet" type="text/css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">

<style>
  .dataTables_wrapper .dataTables_info { float: left; }
  .dataTables_wrapper .dataTables_paginate { float: right; text-align: right; }
  
  /* Export Button Styling - Green */
  .dt-buttons { float: left; margin-bottom: 10px; }
  .buttons-excel, .btn-export-all {
    background: #28a745 !important; color: white !important; border: none !important;
    padding: 8px 20px !important; border-radius: 5px !important; font-weight: 500 !important;
    transition: all 0.3s !important; box-shadow: none !important;
  }
  .buttons-excel:hover, .btn-export-all:hover {
    background: #218838 !important; color: white !important;
    transform: translateY(-2px) !important;
    box-shadow: 0 4px 8px rgba(40, 167, 69, 0.4) !important;
  }
  
  .btn-export {
    background: #28a745; color: white; border: none;
  }
  .btn-export:hover {
    background: #218838; color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(40, 167, 69, 0.4);
  }
  
  /* Bulk Update Button - Orange */
  .btn-bulk-update {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
    color: white; border: none; font-weight: 500;
  }
  .btn-bulk-update:hover {
    background: linear-gradient(135deg, #e67e22 0%, #d35400 100%);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(243, 156, 18, 0.4);
  }
  .btn-bulk-update:disabled {
    background: #95a5a6 !important;
    cursor: not-allowed;
    opacity: 0.6;
  }
  
  .text-danger { color: #dc3545; font-weight: bold; }
  .is-invalid { border-color: #dc3545 !important; }
  .invalid-feedback { display: block; color: #dc3545; font-size: 0.875rem; margin-top: 0.25rem; }

  /* ✅ UPDATED: PARTIELLE Table Styling */
  #partielleTable {
    font-size: 0.9rem;
    margin-bottom: 0;
  }

  #partielleTable thead th {
    background: #1f2937;
    color: white;
    font-weight: 600;
    text-align: center;
    vertical-align: middle;
    padding: 12px 8px;
    white-space: nowrap;
    position: sticky;
    top: 0;
    z-index: 10;
  }

  #partielleTable tbody td {
    vertical-align: middle;
    padding: 10px 8px;
    text-align: center;
  }

  #partielleTable tbody tr {
    transition: background-color 0.2s;
  }

  #partielleTable tbody tr:hover {
    background-color: #f3f4f6;
  }

  /* ✅ NEW: Row number styling */
  .partielle-row-number {
    font-weight: 600;
    color: #6c757d;
    font-size: 0.9rem;
  }

  .badge-count {
    background: #3b82f6;
    color: white;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 0.85rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
  }

  .badge-count:hover {
    background: #2563eb;
    transform: scale(1.1);
    box-shadow: 0 2px 8px rgba(59, 130, 246, 0.4);
  }

  .text-balance-positive {
    color: #10b981;
    font-weight: 600;
  }

  .text-balance-negative {
    color: #ef4444;
    font-weight: 600;
  }

  .modal.show ~ .modal {
    z-index: 1060;
  }

  .modal-backdrop.show ~ .modal-backdrop {
    z-index: 1055;
  }
  
  /* Stats Cards - Smaller and Clickable */
  .stats-card {
    border: none; border-radius: 10px;
    transition: all 0.3s ease; overflow: hidden;
    background: white; border: 1px solid #e9ecef;
    cursor: pointer; position: relative;
  }
  .stats-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    border-color: #007bff;
  }
  .stats-card.active {
    border-color: #007bff; background: #f8f9ff;
    box-shadow: 0 4px 12px rgba(0,123,255,0.2);
  }
  .stats-card .card-body {
    padding: 15px; position: relative;
  }
  
  .stats-card-icon {
    width: 35px; height: 35px;
    border-radius: 8px; display: flex;
    align-items: center; justify-content: center;
    margin-bottom: 8px; float: left; margin-right: 10px;
  }
  .stats-card-icon i { font-size: 18px; color: white; }
  
  .icon-blue { background: linear-gradient(135deg, #4A90E2 0%, #357ABD 100%); }
  .icon-green { background: linear-gradient(135deg, #2ECC71 0%, #27AE60 100%); }
  .icon-orange { background: linear-gradient(135deg, #F39C12 0%, #E67E22 100%); }
  .icon-gray { background: linear-gradient(135deg, #95A5A6 0%, #7F8C8D 100%); }
  .icon-red { background: linear-gradient(135deg, #E74C3C 0%, #C0392B 100%); }
  .icon-purple { background: linear-gradient(135deg, #9B59B6 0%, #8E44AD 100%); }
  .icon-cyan { background: linear-gradient(135deg, #3498DB 0%, #2980B9 100%); }
  .icon-pink { background: linear-gradient(135deg, #E91E63 0%, #C2185B 100%); }
  .icon-teal { background: linear-gradient(135deg, #1ABC9C 0%, #16A085 100%); }
  .icon-indigo { background: linear-gradient(135deg, #6366F1 0%, #4F46E5 100%); }
  .icon-yellow { background: linear-gradient(135deg, #FFC107 0%, #FF9800 100%); }
  .icon-brown { background: linear-gradient(135deg, #795548 0%, #5D4037 100%); }
  
  .stats-value {
    font-size: 1.4rem; font-weight: 700; color: #2C3E50;
    margin-bottom: 2px; line-height: 1.2;
  }
  .stats-label {
    font-size: 0.75rem; color: #7F8C8D;
    font-weight: 500; line-height: 1.2;
  }
  
  .stats-card .card-body::after {
    content: ""; display: table; clear: both;
  }
  
  .modal-content { border: none; border-radius: 15px; overflow: hidden; }
  .modal-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white; border: none; padding: 20px 30px;
  }
  .modal-header .btn-close { filter: brightness(0) invert(1); }
  .detail-row {
    padding: 15px; border-bottom: 1px solid #f0f0f0;
    transition: background 0.2s;
  }
  .detail-row:hover { background: #f8f9fa; }
  .detail-row:last-child { border-bottom: none; }
  .detail-label {
    font-weight: 600; color: #667eea;
    font-size: 0.9rem; margin-bottom: 5px;
  }
  .detail-value { color: #2d3748; font-size: 1rem; font-weight: 500; }
  .detail-icon { color: #667eea; margin-right: 8px; }

  .auto-generated-field { background-color: #f8f9fa; cursor: not-allowed; }
  .readonly-field { background-color: #e9ecef; cursor: not-allowed; }
  
  /* ✅ UPDATED: Removed manual/auto mode styling - fully automatic now */
  .clearing-status-auto-mode {
    border-left: 4px solid #28a745 !important;
  }
  
  .remarks-entry {
    border: 1px solid #dee2e6; border-radius: 8px;
    padding: 15px; margin-bottom: 15px; background: #f8f9fa;
    position: relative;
  }
  .remarks-entry .btn-remove { position: absolute; top: 10px; right: 10px; }
  
  .accordion-button:not(.collapsed) { background-color: #667eea; color: white; }
  
  .group-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white; padding: 10px 15px; border-radius: 8px;
    margin-bottom: 20px; margin-top: 20px;
  }
  .group-header i { margin-right: 10px; }
  
  .date-sequence-error {
    border-color: #dc3545 !important;
    animation: shake 0.5s;
  }
  
  @keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-10px); }
    75% { transform: translateX(10px); }
  }
  
  @media (min-width: 768px) {
    .col-md-2-4 {
      flex: 0 0 auto;
      width: 20%;
    }
  }

  .filter-indicator {
    position: absolute; top: 8px; right: 8px;
    background: #007bff; color: white; border-radius: 50%;
    width: 20px; height: 20px; display: none;
    align-items: center; justify-content: center;
    font-size: 10px; font-weight: bold;
  }
  .stats-card.active .filter-indicator { display: flex; }
  
  .dataTables_wrapper .dataTables_scroll {
    overflow-x: auto;
  }
  
  .dataTables_wrapper .dataTables_scrollBody {
    overflow-x: auto;
  }
  
  /* Bulk Update Modal - TABLE LAYOUT */
  #bulkUpdateModal .modal-header {
    background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
  }
  
  .bulk-update-table {
    width: 100%;
    margin-bottom: 1rem;
    border-collapse: separate;
    border-spacing: 0;
    font-size: 0.9rem;
  }
  
  .bulk-update-table thead th {
    background: #667eea;
    color: white;
    padding: 12px 8px;
    font-weight: 600;
    font-size: 0.85rem;
    border: none;
    position: sticky;
    top: 0;
    z-index: 10;
    text-align: left;
  }
  
  .bulk-update-table tbody tr {
    border-bottom: 1px solid #dee2e6;
    transition: background 0.2s;
  }
  
  .bulk-update-table tbody tr:hover {
    background: #f8f9fa;
  }
  
  .bulk-update-table tbody tr.selected {
    background: #e7f3ff;
  }
  
  .bulk-update-table td {
    padding: 10px 8px;
    vertical-align: middle;
  }
  
  .bulk-update-table .form-control,
  .bulk-update-table .form-select {
    font-size: 0.85rem;
    padding: 6px 10px;
    height: auto;
    width: 100%;
  }
  
  .bulk-update-table .form-check-input {
    width: 20px;
    height: 20px;
    cursor: pointer;
  }
  
  .mca-ref-badge {
    background: #667eea;
    color: white;
    padding: 4px 10px;
    border-radius: 15px;
    font-size: 0.8rem;
    font-weight: 600;
    display: inline-block;
    white-space: nowrap;
  }
  
  .pre-alert-date-text {
    color: #6c757d;
    font-size: 0.75rem;
    display: block;
    margin-top: 2px;
  }
  
  .bulk-update-summary {
    background: #fff3cd;
    border: 1px solid #ffc107;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 20px;
  }
  
  .bulk-update-summary h6 {
    color: #856404;
    margin-bottom: 10px;
    font-weight: 600;
  }
  
  .bulk-table-container {
    max-height: 500px;
    overflow-y: auto;
    border: 1px solid #dee2e6;
    border-radius: 8px;
  }
  
  .border-success {
    border-color: #28a745 !important;
    transition: border-color 0.3s ease;
  }

  #addCommodityBtn, #addPartielleBtn {
    padding: 0.375rem 0.75rem;
    border-top-left-radius: 0;
    border-bottom-left-radius: 0;
    background: #28a745;
    border: 1px solid #28a745;
  }

  #addCommodityBtn:hover, #addPartielleBtn:hover {
    background: #218838;
    border-color: #1e7e34;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(40, 167, 69, 0.3);
  }

  #commodityModal .modal-header, #partielleModal .modal-header {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
  }

  #partielle_preview {
    font-size: 0.95rem;
    border-left: 4px solid #28a745;
    background: #d4edda;
    border-color: #c3e6cb;
  }

  #partielle_number {
    border-left: none;
  }

  .input-group-text {
    min-width: 60px;
    justify-content: center;
  }

  #partielle_prefix {
    background-color: #28a745;
    color: white;
    font-weight: 600;
    border-color: #28a745;
  }
  
  .swal2-popup {
    font-size: 1rem !important;
  }
  
  .swal2-title {
    font-size: 1.5rem !important;
  }
  
  .swal2-html-container {
    font-size: 0.95rem !important;
  }
  
  .currency-input-group {
    position: relative;
    display: flex;
    align-items: stretch;
  }
  
  .currency-input-group input {
    flex: 1;
    border-top-right-radius: 0 !important;
    border-bottom-right-radius: 0 !important;
    border-right: none !important;
  }
  
  .currency-input-group select {
    width: 100px;
    border-top-left-radius: 0 !important;
    border-bottom-left-radius: 0 !important;
    border-left: 1px solid #dee2e6 !important;
    background-color: #f8f9fa;
  }
  
  .currency-input-group select:focus {
    border-color: #80bdff;
    box-shadow: none;
  }
  
  .currency-input-group input:focus {
    border-color: #80bdff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    z-index: 3;
  }

  /* ✅ Filter Controls Styling */
  .filter-controls {
    background: #f8f9fa;
    border-radius: 10px;
    padding: 20px;
    margin-bottom: 20px;
    border: 2px solid #e9ecef;
  }

  .filter-controls h6 {
    color: #495057;
    font-weight: 600;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
  }

  .filter-controls h6 i {
    margin-right: 8px;
    color: #667eea;
  }

  .filter-controls .form-label {
    font-weight: 500;
    color: #495057;
    margin-bottom: 5px;
    font-size: 0.9rem;
  }

  .filter-controls .form-select,
  .filter-controls .form-control {
    border-radius: 6px;
    border: 1px solid #ced4da;
    font-size: 0.9rem;
  }

  .filter-controls .form-select:focus,
  .filter-controls .form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
  }

  .btn-apply-filters {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    font-weight: 500;
    padding: 8px 20px;
    border-radius: 6px;
    transition: all 0.3s;
  }

  .btn-apply-filters:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(102, 126, 234, 0.3);
    color: white;
  }

  .btn-reset-filters {
    background: #6c757d;
    color: white;
    border: none;
    font-weight: 500;
    padding: 8px 20px;
    border-radius: 6px;
    transition: all 0.3s;
  }

  .btn-reset-filters:hover {
    background: #5a6268;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(108, 117, 125, 0.3);
  }

  .client-filter-dropdown {
    min-width: 250px;
    max-width: 300px;
  }

  .client-filter-dropdown .form-select {
    font-size: 0.9rem;
    padding: 6px 12px;
    border: 2px solid #007bff;
    background-color: #f8f9ff;
  }

  .client-filter-dropdown .form-select:focus {
    border-color: #0056b3;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
  }

  /* Files Detail Table Styling */
  .files-detail-table {
    font-size: 0.9rem;
    margin-bottom: 0;
  }

  .files-detail-table thead th {
    background: #667eea;
    color: white;
    font-weight: 600;
    text-align: center;
    padding: 12px 8px;
    white-space: nowrap;
  }

  .files-detail-table tbody td {
    vertical-align: middle;
    padding: 10px 8px;
    text-align: center;
  }

  .files-detail-table tbody tr:hover {
    background-color: #f3f4f6;
  }
</style>

<div class="page-content">
  <div class="page-container">
    <div class="row">
      <div class="col-12">
        
        <!-- Statistics Cards with Icons -->
        <div class="row mb-4">
          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="all">
              <div class="card-body">
                <div class="stats-card-icon icon-blue">
                  <i class="ti ti-truck-delivery"></i>
                </div>
                <div class="stats-value" id="totalTrackings">0</div>
                <div class="stats-label">Total Imports</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="completed">
              <div class="card-body">
                <div class="stats-card-icon icon-green">
                  <i class="ti ti-circle-check"></i>
                </div>
                <div class="stats-value" id="totalCompleted">0</div>
                <div class="stats-label">Completed</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="in_progress">
              <div class="card-body">
                <div class="stats-card-icon icon-orange">
                  <i class="ti ti-loader"></i>
                </div>
                <div class="stats-value" id="totalInProgress">0</div>
                <div class="stats-label">In Progress</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="in_transit">
              <div class="card-body">
                <div class="stats-card-icon icon-gray">
                  <i class="ti ti-package"></i>
                </div>
                <div class="stats-value" id="totalInTransit">0</div>
                <div class="stats-label">In Transit</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="crf_missing">
              <div class="card-body">
                <div class="stats-card-icon icon-purple">
                  <i class="ti ti-file-text"></i>
                </div>
                <div class="stats-value" id="totalCRFMissing">0</div>
                <div class="stats-label">CRF Missing</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="ad_missing">
              <div class="card-body">
                <div class="stats-card-icon icon-cyan">
                  <i class="ti ti-file-alert"></i>
                </div>
                <div class="stats-value" id="totalADMissing">0</div>
                <div class="stats-label">AD Missing</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
          
          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="insurance_missing">
              <div class="card-body">
                <div class="stats-card-icon icon-pink">
                  <i class="ti ti-shield-off"></i>
                </div>
                <div class="stats-value" id="totalInsuranceMissing">0</div>
                <div class="stats-label">Insurance Missing</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>

          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="audited_pending">
              <div class="card-body">
                <div class="stats-card-icon icon-teal">
                  <i class="ti ti-calendar-check"></i>
                </div>
                <div class="stats-value" id="totalAuditedPending">0</div>
                <div class="stats-label">Audited Pending</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>

          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="archived_pending">
              <div class="card-body">
                <div class="stats-card-icon icon-indigo">
                  <i class="ti ti-archive"></i>
                </div>
                <div class="stats-value" id="totalArchivedPending">0</div>
                <div class="stats-label">Archived Pending</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>

          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="dgda_in_pending">
              <div class="card-body">
                <div class="stats-card-icon icon-yellow">
                  <i class="ti ti-building"></i>
                </div>
                <div class="stats-value" id="totalDgdaInPending">0</div>
                <div class="stats-label">DGDA In Pending</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>

          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="liquidation_pending">
              <div class="card-body">
                <div class="stats-card-icon icon-brown">
                  <i class="ti ti-cash"></i>
                </div>
                <div class="stats-value" id="totalLiquidationPending">0</div>
                <div class="stats-label">Liquidation Pending</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>

          <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
            <div class="card stats-card shadow-sm" data-filter="quittance_pending">
              <div class="card-body">
                <div class="stats-card-icon icon-red">
                  <i class="ti ti-receipt"></i>
                </div>
                <div class="stats-value" id="totalQuittancePending">0</div>
                <div class="stats-label">Quittance Pending</div>
                <div class="filter-indicator">✓</div>
              </div>
            </div>
          </div>
        </div>

        <!-- Advanced Filter Controls -->
        <div class="card shadow-sm mb-4 filter-controls">
          <h6><i class="ti ti-filter"></i> Advanced Filters</h6>
          <div class="row">
            <div class="col-md-3 mb-3">
              <label class="form-label">Client</label>
              <select class="form-select" id="filterClientSelect">
                <option value="">All Clients</option>
                <?php foreach ($subscribers as $sub): ?>
                  <option value="<?= $sub['id'] ?>"><?= $sub['short_name'] ?></option>
                <?php endforeach; ?>
              </select>
            </div>

            <div class="col-md-3 mb-3">
              <label class="form-label">Transport Mode</label>
              <select class="form-select" id="filterTransportModeSelect">
                <option value="">All Transport Modes</option>
                <?php foreach ($transport_modes as $mode): ?>
                  <option value="<?= $mode['id'] ?>"><?= $mode['transport_mode_name'] ?></option>
                <?php endforeach; ?>
              </select>
            </div>

            <div class="col-md-2 mb-3">
              <label class="form-label">Start Date</label>
              <input type="date" class="form-control" id="filterStartDate">
            </div>

            <div class="col-md-2 mb-3">
              <label class="form-label">End Date</label>
              <input type="date" class="form-control" id="filterEndDate">
            </div>

            <div class="col-md-2 mb-3 d-flex align-items-end">
              <button type="button" class="btn btn-apply-filters w-100" id="applyFiltersBtn">
                <i class="ti ti-check me-1"></i> Apply Filters
              </button>
            </div>
          </div>
        </div>

        <!-- Import Form Card -->
        <div class="card shadow-sm mb-4">
          <div class="card-header border-bottom border-dashed d-flex align-items-center justify-content-between">
            <h4 class="header-title mb-0"><i class="ti ti-file-import me-2"></i> <span id="formTitle">Add New Import</span></h4>
            <div class="d-flex gap-2">
              <button type="button" class="btn btn-sm btn-export-all" id="exportAllBtn">
                <i class="ti ti-file-spreadsheet me-1"></i> Export All to Excel
              </button>
              <button type="button" class="btn btn-sm btn-secondary" id="resetFormBtn" style="display:none;">
                <i class="ti ti-plus"></i> Add New
              </button>
            </div>
          </div>

          <div class="card-body">
            <form id="importForm" method="post" novalidate data-csrf-token="<?= htmlspecialchars($csrf_token, ENT_QUOTES, 'UTF-8') ?>">
              <input type="hidden" name="import_id" id="import_id" value="">
              <input type="hidden" name="action" id="formAction" value="insert">

              <div class="accordion" id="importAccordion">
                
                <!-- IMPORT TRACKING ACCORDION -->
                <div class="accordion-item mb-3">
                  <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#importTracking">
                      <i class="ti ti-file-import me-2"></i> Import Tracking
                    </button>
                  </h2>

                  <div id="importTracking" class="accordion-collapse collapse" data-bs-parent="#importAccordion">
                    <div class="accordion-body">

                      <!-- ========== GROUP 1: DOCUMENTATION ========== -->
                      <div class="group-header">
                        <i class="ti ti-file-text"></i>Documentation
                      </div>

                      <!-- Row 1: Client, License, Kind, Type of Goods, Transport Mode -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>Client <span class="text-danger">*</span></label>
                          <select name="subscriber_id" id="subscriber_id" class="form-select" required>
                            <option value="">-- Select Client --</option>
                            <?php foreach ($subscribers as $sub): ?>
                              <option value="<?= $sub['id'] ?>" data-liquidation="<?= $sub['liquidation_paid_by'] ?? '' ?>"><?= $sub['short_name'] ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="subscriber_id_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>License Number <span class="text-danger">*</span></label>
                          <select name="license_id" id="license_id" class="form-select" required>
                            <option value="">-- Select License --</option>
                          </select>
                          <div class="invalid-feedback" id="license_id_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Kind <span class="text-danger">*</span></label>
                          <input type="hidden" name="kind" id="kind_hidden">
                          <input type="text" id="kind_display" class="form-control readonly-field" readonly placeholder="From License">
                          <div class="invalid-feedback" id="kind_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Type of Goods <span class="text-danger">*</span></label>
                          <input type="hidden" name="type_of_goods" id="type_of_goods_hidden">
                          <input type="text" id="type_of_goods_display" class="form-control readonly-field" readonly placeholder="From License">
                          <div class="invalid-feedback" id="type_of_goods_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Transport Mode <span class="text-danger">*</span></label>
                          <input type="hidden" name="transport_mode" id="transport_mode_hidden">
                          <input type="text" id="transport_mode_display" class="form-control readonly-field" readonly placeholder="From License">
                          <div class="invalid-feedback" id="transport_mode_error"></div>
                        </div>
                      </div>

                      <!-- Row 2: MCA, Currency, Supplier, Regime, Clearance -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>MCA Reference <span class="text-danger">*</span> <small class="text-muted">(Auto)</small></label>
                          <input type="text" name="mca_ref" id="mca_ref" class="form-control auto-generated-field" required readonly placeholder="Auto-generated">
                          <div class="invalid-feedback" id="mca_ref_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Currency <span class="text-danger">*</span></label>
                          <input type="hidden" name="currency" id="currency_hidden">
                          <input type="text" id="currency_display" class="form-control readonly-field" readonly placeholder="From License">
                          <div class="invalid-feedback" id="currency_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Supplier <span class="text-danger">*</span></label>
                          <input type="text" name="supplier" id="supplier" class="form-control" placeholder="Enter supplier name" maxlength="255">
                          <div class="invalid-feedback" id="supplier_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Regime <span class="text-danger">*</span></label>
                          <select name="regime" id="regime" class="form-select" required>
                            <option value="">-- Select Regime --</option>
                            <?php foreach ($regimes as $regime): ?>
                              <option value="<?= $regime['id'] ?>"><?= $regime['regime_name'] ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="regime_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Types of Clearance <span class="text-danger">*</span></label>
                          <select name="types_of_clearance" id="types_of_clearance" class="form-select" required>
                            <option value="">-- Select Clearance --</option>
                            <?php foreach ($clearance_types as $type): ?>
                              <option value="<?= $type['id'] ?>" <?= ($type['id'] == 1) ? 'selected' : '' ?>><?= $type['clearance_name'] ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="types_of_clearance_error"></div>
                        </div>
                      </div>

                      <!-- Row 3: Declaration Office, Pre-Alert, Invoice, Commodity with + button, PO Ref -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>Declaration Office</label>
                          <select name="declaration_office_id" id="declaration_office_id" class="form-select">
                            <option value="">-- Select Office --</option>
                            <?php foreach ($sub_offices as $office): ?>
                              <option value="<?= $office['id'] ?>"><?= $office['sub_office_name'] ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="declaration_office_id_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Pre-Alert Date <span class="text-danger">*</span></label>
                          <input type="date" name="pre_alert_date" id="pre_alert_date" class="form-control" required>
                          <div class="invalid-feedback" id="pre_alert_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Invoice <span class="text-danger">*</span></label>
                          <input type="text" name="invoice" id="invoice" class="form-control" required maxlength="100">
                          <div class="invalid-feedback" id="invoice_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Commodity <span class="text-danger">*</span></label>
                          <div class="input-group">
                            <select name="commodity" id="commodity" class="form-select" required>
                              <option value="">-- Select Commodity --</option>
                              <?php foreach ($commodities as $commodity): ?>
                                <option value="<?= $commodity['id'] ?>"><?= $commodity['commodity_name'] ?></option>
                              <?php endforeach; ?>
                            </select>
                            <button type="button" class="btn btn-success" id="addCommodityBtn" title="Add Commodity">
                              <i class="ti ti-plus"></i>
                            </button>
                          </div>
                          <div class="invalid-feedback" id="commodity_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>PO Reference</label>
                          <input type="text" name="po_ref" id="po_ref" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="po_ref_error"></div>
                        </div>
                      </div>

                      <!-- Row 4: Fret, Other Charges, CRF Reference, CRF Received Date, Clearing Based On -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>Fret</label>
                          <div class="currency-input-group">
                            <input type="number" step="0.01" name="fret" id="fret" class="form-control" min="0" placeholder="Amount">
                            <select name="fret_currency" id="fret_currency" class="form-select">
                              <option value="">Currency</option>
                              <?php foreach ($currencies as $curr): ?>
                                <option value="<?= $curr['id'] ?>"><?= $curr['currency_short_name'] ?></option>
                              <?php endforeach; ?>
                            </select>
                          </div>
                          <div class="invalid-feedback" id="fret_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Other Charges</label>
                          <div class="currency-input-group">
                            <input type="number" step="0.01" name="other_charges" id="other_charges" class="form-control" min="0" placeholder="Amount">
                            <select name="other_charges_currency" id="other_charges_currency" class="form-select">
                              <option value="">Currency</option>
                              <?php foreach ($currencies as $curr): ?>
                                <option value="<?= $curr['id'] ?>"><?= $curr['currency_short_name'] ?></option>
                              <?php endforeach; ?>
                            </select>
                          </div>
                          <div class="invalid-feedback" id="other_charges_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>CRF Reference <small class="text-muted">(From License)</small></label>
                          <input type="text" name="crf_reference" id="crf_reference" class="form-control readonly-field" readonly maxlength="100" placeholder="From License">
                          <div class="invalid-feedback" id="crf_reference_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>CRF Received Date <small class="text-muted">(>= Pre-Alert)</small></label>
                          <input type="date" name="crf_received_date" id="crf_received_date" class="form-control document-status-trigger date-after-prealert">
                          <div class="invalid-feedback" id="crf_received_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Clearing Based On</label>
                          <select name="clearing_based_on" id="clearing_based_on" class="form-select">
                            <option value="">-- Select --</option>
                            <?php foreach ($clearing_based_on_options as $option): ?>
                              <option value="<?= htmlspecialchars($option, ENT_QUOTES, 'UTF-8') ?>"><?= htmlspecialchars($option, ENT_QUOTES, 'UTF-8') ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="clearing_based_on_error"></div>
                        </div>
                      </div>

                      <!-- Row 5: AD Date, Insurance Date, Insurance Amount, Insurance Reference, Inspection Reports with + button -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>AD Date <small class="text-muted">(>= Pre-Alert)</small></label>
                          <input type="date" name="ad_date" id="ad_date" class="form-control document-status-trigger date-after-prealert">
                          <div class="invalid-feedback" id="ad_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Insurance Date <small class="text-muted">(>= Pre-Alert)</small></label>
                          <input type="date" name="insurance_date" id="insurance_date" class="form-control document-status-trigger date-after-prealert">
                          <div class="invalid-feedback" id="insurance_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Insurance Amount</label>
                          <div class="currency-input-group">
                            <input type="number" step="0.01" name="insurance_amount" id="insurance_amount" class="form-control" min="0" placeholder="Amount">
                            <select name="insurance_amount_currency" id="insurance_amount_currency" class="form-select">
                              <option value="">Currency</option>
                              <?php foreach ($currencies as $curr): ?>
                                <option value="<?= $curr['id'] ?>"><?= $curr['currency_short_name'] ?></option>
                              <?php endforeach; ?>
                            </select>
                          </div>
                          <div class="invalid-feedback" id="insurance_amount_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Insurance Reference</label>
                          <input type="text" name="insurance_reference" id="insurance_reference" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="insurance_reference_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Inspection Reports (PARTIELLE)</label>
                          <div class="input-group">
                            <select name="inspection_reports" id="inspection_reports" class="form-select">
                              <option value="">-- Select PARTIELLE --</option>
                            </select>
                            <button type="button" class="btn btn-success" id="addPartielleBtn" title="Manage PARTIELLE">
                              <i class="ti ti-settings"></i>
                            </button>
                          </div>
                          <div class="invalid-feedback" id="inspection_reports_error"></div>
                        </div>
                      </div>

                      <!-- Row 6: Available Partial Weight, Available Partial FOB, Weight, FOB, Archive Reference -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>Available Partial Weight <small class="text-muted">(Auto)</small></label>
                          <input type="text" id="available_partial_weight_display" class="form-control readonly-field" readonly placeholder="Select PARTIELLE">
                          <input type="hidden" id="available_partial_weight_hidden">
                          <div class="invalid-feedback" id="available_partial_weight_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Available Partial FOB <small class="text-muted">(Auto)</small></label>
                          <input type="text" id="available_partial_fob_display" class="form-control readonly-field" readonly placeholder="Select PARTIELLE">
                          <input type="hidden" id="available_partial_fob_hidden">
                          <div class="invalid-feedback" id="available_partial_fob_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Weight <span class="text-danger">*</span></label>
                          <input type="number" step="0.01" name="weight" id="weight" class="form-control" required min="0">
                          <div class="invalid-feedback" id="weight_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>FOB <span class="text-danger">*</span></label>
                          <div class="currency-input-group">
                            <input type="number" step="0.01" name="fob" id="fob" class="form-control" required min="0" placeholder="Amount">
                            <select name="fob_currency" id="fob_currency" class="form-select">
                              <option value="">Currency</option>
                              <?php foreach ($currencies as $curr): ?>
                                <option value="<?= $curr['id'] ?>"><?= $curr['currency_short_name'] ?></option>
                              <?php endforeach; ?>
                            </select>
                          </div>
                          <div class="invalid-feedback" id="fob_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Archive Reference</label>
                          <input type="text" name="archive_reference" id="archive_reference" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="archive_reference_error"></div>
                        </div>
                      </div>

                      <!-- Row 7: Audited Date, Archived Date, Road Manifest (conditional), Wagon (conditional) -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>Audited Date <small class="text-muted">(>= Pre-Alert)</small></label>
                          <input type="date" name="audited_date" id="audited_date" class="form-control date-after-prealert">
                          <div class="invalid-feedback" id="audited_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Archived Date <small class="text-muted">(>= Pre-Alert)</small></label>
                          <input type="date" name="archived_date" id="archived_date" class="form-control date-after-prealert">
                          <div class="invalid-feedback" id="archived_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3" id="road_manifest_field" style="display:none;">
                          <label>Road Manifest <small class="text-muted">(Road/Rail)</small></label>
                          <input type="text" name="road_manif" id="road_manif" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="road_manif_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3" id="wagon_field" style="display:none;">
                          <label>Wagon <small class="text-muted">(Rail)</small></label>
                          <input type="text" name="wagon" id="wagon" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="wagon_error"></div>
                        </div>
                      </div>

                      <!-- HORSE/TRAILERS/CONTAINER/ENTRY POINT ROW (ROAD/RAIL) -->
                      <div class="row" id="road_fields" style="display:none;">
                        <div class="col-md-2-4 mb-3">
                          <label>Horse <small class="text-muted">(Road/Rail)</small></label>
                          <input type="text" name="horse" id="horse" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="horse_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Trailer 1 <small class="text-muted">(Road/Rail)</small></label>
                          <input type="text" name="trailer_1" id="trailer_1" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="trailer_1_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Trailer 2 <small class="text-muted">(Road/Rail)</small></label>
                          <input type="text" name="trailer_2" id="trailer_2" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="trailer_2_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Container <small class="text-muted">(Road/Rail)</small></label>
                          <input type="text" name="container" id="container" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="container_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Entry Point <span class="text-danger">*</span></label>
                          <select name="entry_point_id" id="entry_point_id" class="form-select" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($entry_points as $point): ?>
                              <option value="<?= $point['id'] ?>"><?= $point['transit_point_name'] ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="entry_point_id_error"></div>
                        </div>
                      </div>

                      <!-- AIR: ENTRY POINT ALONE -->
                      <div class="row" id="air_entry_point_row" style="display:none;">
                        <div class="col-md-2-4 mb-3">
                          <label>Entry Point <span class="text-danger">*</span></label>
                          <select name="entry_point_id_air" id="entry_point_id_air" class="form-select" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($entry_points as $point): ?>
                              <option value="<?= $point['id'] ?>"><?= $point['transit_point_name'] ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="entry_point_id_air_error"></div>
                        </div>
                      </div>

                      <!-- ========== GROUP 2: DECLARATION ========== -->
                      <div class="group-header">
                        <i class="ti ti-file-certificate"></i>Declaration
                      </div>

                      <!-- Row 1: DGDA In Date, Declaration Reference, SEGUES RCV Reference, SEGUES Payment Date, Customs Manifest Number -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>DGDA In Date</label>
                          <input type="date" name="dgda_in_date" id="dgda_in_date" class="form-control">
                          <div class="invalid-feedback" id="dgda_in_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Declaration Reference</label>
                          <input type="text" name="declaration_reference" id="declaration_reference" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="declaration_reference_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>SEGUES RCV Reference</label>
                          <input type="text" name="segues_rcv_ref" id="segues_rcv_ref" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="segues_rcv_ref_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>SEGUES Payment Date</label>
                          <input type="date" name="segues_payment_date" id="segues_payment_date" class="form-control">
                          <div class="invalid-feedback" id="segues_payment_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Customs Manifest Number</label>
                          <input type="text" name="customs_manifest_number" id="customs_manifest_number" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="customs_manifest_number_error"></div>
                        </div>
                      </div>

                      <!-- Row 2: Customs Manifest Date, Liquidation Reference, Liquidation Date, Liquidation Paid By, Liquidation Amount -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>Customs Manifest Date</label>
                          <input type="date" name="customs_manifest_date" id="customs_manifest_date" class="form-control">
                          <div class="invalid-feedback" id="customs_manifest_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Liquidation Reference</label>
                          <input type="text" name="liquidation_reference" id="liquidation_reference" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="liquidation_reference_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Liquidation Date</label>
                          <input type="date" name="liquidation_date" id="liquidation_date" class="form-control">
                          <div class="invalid-feedback" id="liquidation_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Liquidation Paid By <small class="text-muted">(From Client)</small></label>
                          <input type="text" name="liquidation_paid_by" id="liquidation_paid_by" class="form-control readonly-field" readonly placeholder="From Client">
                          <div class="invalid-feedback" id="liquidation_paid_by_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Liquidation Amount</label>
                          <input type="number" step="0.01" name="liquidation_amount" id="liquidation_amount" class="form-control" min="0">
                          <div class="invalid-feedback" id="liquidation_amount_error"></div>
                        </div>
                      </div>

                      <!-- Row 3: Quittance Reference, Quittance Date, DGDA Out Date, Document Status, Customs Clearance Code -->
                      <div class="row">
                        <div class="col-md-2-4 mb-3">
                          <label>Quittance Reference</label>
                          <input type="text" name="quittance_reference" id="quittance_reference" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="quittance_reference_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Quittance Date <small class="text-muted">(Triggers Status)</small></label>
                          <input type="date" name="quittance_date" id="quittance_date" class="form-control clearing-status-trigger">
                          <div class="invalid-feedback" id="quittance_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>DGDA Out Date</label>
                          <input type="date" name="dgda_out_date" id="dgda_out_date" class="form-control">
                          <div class="invalid-feedback" id="dgda_out_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Document Status <small class="text-muted">(Auto)</small></label>
                          <select name="document_status" id="document_status" class="form-select auto-generated-field" readonly disabled>
                            <option value="">-- Select --</option>
                            <?php foreach ($document_statuses as $status): ?>
                              <option value="<?= $status['id'] ?>" <?= ($status['id'] == 1) ? 'selected' : '' ?>><?= $status['document_status'] ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="document_status_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Customs Clearance Code</label>
                          <input type="text" name="customs_clearance_code" id="customs_clearance_code" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="customs_clearance_code_error"></div>
                        </div>
                      </div>

                      <!-- ========== GROUP 3: LOGISTICS & TRANSPORT ========== -->
                      <div class="group-header">
                        <i class="ti ti-truck-delivery"></i>Logistics & Transport
                      </div>

                      <!-- AIR ONLY FIELDS -->
                      <div class="row" id="air_fields" style="display:none;">
                        <div class="col-md-2-4 mb-3">
                          <label>Airway Bill <small class="text-muted">(Air)</small></label>
                          <input type="text" name="airway_bill" id="airway_bill" class="form-control" maxlength="100">
                          <div class="invalid-feedback" id="airway_bill_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Airway Bill Weight <small class="text-muted">(Air)</small></label>
                          <input type="number" step="0.01" name="airway_bill_weight" id="airway_bill_weight" class="form-control" min="0">
                          <div class="invalid-feedback" id="airway_bill_weight_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Airport Arrival Date <small class="text-muted">(Air)</small></label>
                          <input type="date" name="airport_arrival_date" id="airport_arrival_date" class="form-control">
                          <div class="invalid-feedback" id="airport_arrival_date_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Dispatch from Airport <small class="text-muted">(Air, >= Arrival)</small></label>
                          <input type="date" name="dispatch_from_airport" id="dispatch_from_airport" class="form-control airport-date-validate">
                          <div class="invalid-feedback" id="dispatch_from_airport_error"></div>
                        </div>

                        <div class="col-md-2-4 mb-3">
                          <label>Declaration Validity <small class="text-muted">(Air/Temp)</small></label>
                          <select name="declaration_validity" id="declaration_validity" class="form-select">
                            <option value="">-- Select --</option>
                            <?php foreach ($declaration_validity_options as $option): ?>
                              <option value="<?= htmlspecialchars($option, ENT_QUOTES, 'UTF-8') ?>"><?= htmlspecialchars($option, ENT_QUOTES, 'UTF-8') ?></option>
                            <?php endforeach; ?>
                          </select>
                          <div class="invalid-feedback" id="declaration_validity_error"></div>
                        </div>
                      </div>

                      <!-- ALL LOGISTICS FIELDS (ROAD & RAIL ONLY, NOT AIR) -->
                      <div id="logistics_fields" style="display:none;">
                        <!-- Row 1: Always has 5 fields -->
                        <div class="row" id="logistics_row1">
                          <!-- T1 fields (when clearance = 3) -->
                          <div class="col-md-2-4 mb-3" id="t1_number_col" style="display:none;">
                            <label>T1 Number <small class="text-muted">(Transfer)</small></label>
                            <input type="text" name="t1_number" id="t1_number" class="form-control" maxlength="100">
                            <div class="invalid-feedback" id="t1_number_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3" id="t1_date_col" style="display:none;">
                            <label>T1 Date <small class="text-muted">(Transfer)</small></label>
                            <input type="date" name="t1_date" id="t1_date" class="form-control">
                            <div class="invalid-feedback" id="t1_date_error"></div>
                          </div>

                          <!-- Always visible -->
                          <div class="col-md-2-4 mb-3">
                            <label>Arrival Date Zambia</label>
                            <input type="date" name="arrival_date_zambia" id="arrival_date_zambia" class="form-control date-sequence-field" data-seq="1">
                            <div class="invalid-feedback" id="arrival_date_zambia_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Dispatch from Zambia</label>
                            <input type="date" name="dispatch_from_zambia" id="dispatch_from_zambia" class="form-control date-sequence-field" data-seq="2">
                            <div class="invalid-feedback" id="dispatch_from_zambia_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>DRC Entry Date</label>
                            <input type="date" name="drc_entry_date" id="drc_entry_date" class="form-control date-sequence-field" data-seq="3">
                            <div class="invalid-feedback" id="drc_entry_date_error"></div>
                          </div>

                          <!-- Show when T1 hidden -->
                          <div class="col-md-2-4 mb-3" id="border_arrival_col_row1" style="display:none;">
                            <label>Border Warehouse Arrival <small class="text-muted">(Triggers Status)</small></label>
                            <input type="date" name="border_warehouse_arrival_date" id="border_warehouse_arrival_date" class="form-control date-sequence-field clearing-status-trigger" data-seq="4">
                            <div class="invalid-feedback" id="border_warehouse_arrival_date_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3" id="border_dispatch_col_row1" style="display:none;">
                            <label>Dispatch from Border</label>
                            <input type="date" name="dispatch_from_border" id="dispatch_from_border" class="form-control date-sequence-field" data-seq="5">
                            <div class="invalid-feedback" id="dispatch_from_border_error"></div>
                          </div>
                        </div>

                        <!-- Row 2: IBS Coupon onwards -->
                        <div class="row">
                          <div class="col-md-2-4 mb-3">
                            <label>IBS Coupon Reference</label>
                            <input type="text" name="ibs_coupon_reference" id="ibs_coupon_reference" class="form-control" maxlength="100">
                            <div class="invalid-feedback" id="ibs_coupon_reference_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Border Warehouse</label>
                            <select name="border_warehouse_id" id="border_warehouse_id" class="form-select">
                              <option value="">-- Select --</option>
                              <?php foreach ($border_warehouses as $wh): ?>
                                <option value="<?= $wh['id'] ?>"><?= $wh['transit_point_name'] ?></option>
                              <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback" id="border_warehouse_id_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Entry Coupon</label>
                            <input type="text" name="entry_coupon" id="entry_coupon" class="form-control" maxlength="100">
                            <div class="invalid-feedback" id="entry_coupon_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Bonded Warehouse</label>
                            <select name="bonded_warehouse_id" id="bonded_warehouse_id" class="form-select">
                              <option value="">-- Select --</option>
                              <?php foreach ($bonded_warehouses as $wh): ?>
                                <option value="<?= $wh['id'] ?>"><?= $wh['transit_point_name'] ?></option>
                              <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback" id="bonded_warehouse_id_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Truck Status</label>
                            <select name="truck_status" id="truck_status" class="form-select">
                              <option value="">-- Select --</option>
                              <?php foreach ($truck_statuses as $status): ?>
                                <option value="<?= htmlspecialchars($status['truck_status'], ENT_QUOTES, 'UTF-8') ?>"><?= $status['truck_status'] ?></option>
                              <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback" id="truck_status_error"></div>
                          </div>
                        </div>

                        <!-- Row 3: Kanyaka dates -->
                        <div class="row">
                          <div class="col-md-2-4 mb-3">
                            <label>Kanyaka Arrival Date</label>
                            <input type="date" name="kanyaka_arrival_date" id="kanyaka_arrival_date" class="form-control">
                            <div class="invalid-feedback" id="kanyaka_arrival_date_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Kanyaka Dispatch Date</label>
                            <input type="date" name="kanyaka_dispatch_date" id="kanyaka_dispatch_date" class="form-control">
                            <div class="invalid-feedback" id="kanyaka_dispatch_date_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Warehouse Arrival Date</label>
                            <input type="date" name="warehouse_arrival_date" id="warehouse_arrival_date" class="form-control">
                            <div class="invalid-feedback" id="warehouse_arrival_date_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Warehouse Departure Date</label>
                            <input type="date" name="warehouse_departure_date" id="warehouse_departure_date" class="form-control">
                            <div class="invalid-feedback" id="warehouse_departure_error"></div>
                          </div>

                          <div class="col-md-2-4 mb-3">
                            <label>Dispatch/Deliver Date</label>
                            <input type="date" name="dispatch_deliver_date" id="dispatch_deliver_date" class="form-control">
                            <div class="invalid-feedback" id="dispatch_deliver_date_error"></div>
                          </div>
                        </div>
                      </div>

                      <!-- ✅ UPDATED: Clearing Status - Fully Automatic (No Manual Option) -->
                      <div class="row">
                        <div class="col-md-4 mb-3">
                          <label>Clearing Status <span class="text-danger">*</span> 
                            <span class="badge bg-success">Auto</span>
                          </label>
                          <select name="clearing_status" id="clearing_status" class="form-select clearing-status-auto-mode" required>
                            <option value="">-- Select --</option>
                            <?php foreach ($clearing_statuses as $status): ?>
                              <option value="<?= $status['id'] ?>"><?= $status['clearing_status'] ?></option>
                            <?php endforeach; ?>
                          </select>
                          <small class="text-muted">Automatically updated based on dates and progress</small>
                          <div class="invalid-feedback" id="clearing_status_error"></div>
                        </div>
                      </div>

                      <!-- ========== REMARKS ========== -->
                      <div class="mt-4 mb-3">
                        <h6><i class="ti ti-message-circle me-2"></i>Remarks</h6>
                        <input type="hidden" name="remarks" id="remarks_hidden" value="">
                        
                        <div id="remarksContainer">
                          <!-- Remarks will be dynamically added here -->
                        </div>

                        <button type="button" class="btn btn-sm btn-success" id="addRemarkBtn">
                          <i class="ti ti-plus me-1"></i> Add Remark
                        </button>
                      </div>

                    </div>
                  </div>
                </div>

              </div>

              <!-- Form Buttons -->
              <div class="row mt-4">
                <div class="col-12 text-end">
                  <button type="button" class="btn btn-secondary" id="cancelBtn">
                    <i class="ti ti-x me-1"></i> Cancel
                  </button>
                  <button type="submit" class="btn btn-primary ms-2" id="submitBtn">
                    <i class="ti ti-check me-1"></i> <span id="submitBtnText">Save Import</span>
                  </button>
                </div>
              </div>

            </form>
          </div>
        </div>

        <!-- Imports DataTable -->
        <div class="card shadow-sm">
          <div class="card-header border-bottom border-dashed d-flex align-items-center justify-content-between">
            <h4 class="header-title mb-0"><i class="ti ti-list me-2"></i> Imports List</h4>
            <div class="d-flex align-items-center gap-2">
              <button type="button" class="btn btn-sm btn-bulk-update" id="bulkUpdateBtn" disabled>
                <i class="ti ti-edit me-1"></i> Bulk Update
              </button>
              <button type="button" class="btn btn-sm btn-outline-secondary" id="clearFilters">
                <i class="ti ti-filter-off me-1"></i> Clear All Filters
              </button>
              <span class="badge bg-primary" id="activeFiltersBadge" style="display: none;">0 Filters Active</span>
            </div>
          </div>
          <div class="card-body">
            <div class="table-responsive">
              <table id="importsTable" class="table table-striped table-bordered dt-responsive nowrap w-100">
                <thead>
                  <tr>
                    <th>MCA Ref</th>
                    <th>Client</th>
                    <th>License</th>
                    <th>Invoice</th>
                    <th>Pre-Alert Date</th>
                    <th>Weight</th>
                    <th>FOB</th>
                    <th>Clearing Status</th>
                    <th>Actions</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
  <?php include(VIEW_PATH . 'layouts/partials/footer.php'); ?>
</div>

<!-- Bulk Update Modal -->
<div class="modal fade" id="bulkUpdateModal" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">
          <i class="ti ti-edit me-2"></i> Bulk Update Imports
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="bulk-update-summary">
          <h6><i class="ti ti-info-circle me-2"></i>Filter Summary</h6>
          <p class="mb-0" id="bulkFilterSummary">No filter active</p>
        </div>

        <div id="bulkUpdateContent">
          <p class="text-center text-muted">Loading...</p>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
          <i class="ti ti-x me-1"></i> Cancel
        </button>
        <button type="button" class="btn btn-primary" id="saveBulkUpdateBtn">
          <i class="ti ti-check me-1"></i> Save All Changes
        </button>
      </div>
    </div>
  </div>
</div>

<!-- Commodity Modal -->
<div class="modal fade" id="commodityModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header" style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white;">
        <h5 class="modal-title">
          <i class="ti ti-plus-circle me-2"></i> Create New Commodity
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: brightness(0) invert(1);"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label class="form-label">Commodity Name <span class="text-danger">*</span></label>
          <input type="text" class="form-control" id="commodity_name_input" placeholder="Enter commodity name" maxlength="255">
          <small class="text-muted">Enter the name of the commodity</small>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
          <i class="ti ti-x me-1"></i> Cancel
        </button>
        <button type="button" class="btn btn-success" id="saveCommodityBtn">
          <i class="ti ti-check me-1"></i> Create Commodity
        </button>
      </div>
    </div>
  </div>
</div>

<!-- ✅ PARTIELLE Management Modal -->
<div class="modal fade" id="partielleModal" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">
          <i class="ti ti-table me-2"></i>PARTIELLE Management - <span id="partielle_license_display_main"></span>
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <!-- Hidden Fields -->
        <input type="hidden" id="partielle_license_id_hidden">
        <input type="hidden" id="partielle_subscriber_id_hidden">
        <input type="hidden" id="partielle_crf_reference_hidden">

        <!-- License Info Summary -->
        <div class="row mb-3">
          <div class="col-md-6">
            <div class="alert alert-info mb-0">
              <strong>Client:</strong> <span id="partielle_client_display_main"></span><br>
              <strong>CRF Reference:</strong> <span id="partielle_crf_display_main"></span><br>
              <strong>License Weight:</strong> <span id="partielle_license_weight_display_main">0.00</span> KG<br>
              <strong>License FOB:</strong> <span id="partielle_license_fob_display_main">0.00</span>
            </div>
          </div>
          <div class="col-md-6">
            <div class="alert alert-success mb-0">
              <strong>Available Weight:</strong> <span id="partielle_available_weight_display_main" class="text-success fw-bold">0.00</span> KG<br>
              <strong>Available FOB:</strong> <span id="partielle_available_fob_display_main" class="text-success fw-bold">0.00</span>
            </div>
          </div>
        </div>

        <!-- Add New PARTIELLE Button -->
        <div class="mb-3">
          <button type="button" class="btn btn-success" id="addNewPartielleBtn">
            <i class="ti ti-plus me-1"></i> Add New PARTIELLE
          </button>
        </div>

        <!-- PARTIELLE Table -->
        <div class="table-responsive">
          <table class="table table-bordered table-hover" id="partielleTable">
            <thead class="table-dark">
              <tr>
                <th style="width: 50px;">#</th>
                <th>REF COD</th>
                <th>PARTIELLE Number</th>
                <th>License Weight</th>
                <th>License FOB</th>
                <th>No of Files</th>
                <th>Partial Weight</th>
                <th>Partial FOB</th>
                <th>Weight Used in Files</th>
                <th>FOB Used in Files</th>
                <th>Partial Weight - Weight Used</th>
                <th>Partial FOB - FOB Used</th>
                <th style="width: 80px;">Action</th>
              </tr>
            </thead>
            <tbody id="partielleTableBody">
              <tr>
                <td colspan="13" class="text-center text-muted">No PARTIELLEs found. Click "Add New PARTIELLE" to create one.</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
          <i class="ti ti-x me-1"></i> Close
        </button>
      </div>
    </div>
  </div>
</div>

<!-- Add/Edit PARTIELLE Sub-Modal -->
<div class="modal fade" id="addPartielleSubModal" tabindex="-1" data-bs-backdrop="static">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">
          <i class="ti ti-plus-circle me-2"></i><span id="subModalTitle">Add New PARTIELLE</span>
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="edit_partielle_id">
        
        <!-- PARTIELLE Number -->
        <div class="mb-3">
          <label class="form-label fw-bold">PARTIELLE Number <span class="text-danger">*</span></label>
          <div class="input-group">
            <span class="input-group-text bg-primary text-white fw-bold" id="sub_partielle_prefix"></span>
            <input type="text" class="form-control" id="sub_partielle_number" 
                   placeholder="0001" required pattern="[0-9]{3,4}" maxlength="4">
          </div>
          <small class="text-muted">Enter 3-4 digit number (e.g., 0001, 0002)</small>
          <div class="invalid-feedback" id="sub_partielle_number_error"></div>
        </div>

        <!-- Preview -->
        <div class="mb-3" id="sub_partielle_preview" style="display: none;">
          <div class="alert alert-info mb-0">
            <strong>Preview:</strong> <span id="sub_partielle_preview_text" class="text-primary fw-bold"></span>
          </div>
        </div>

        <!-- Partial Weight -->
        <div class="mb-3">
          <label class="form-label fw-bold">
            <i class="ti ti-weight me-1"></i>Partial Weight (KG)
          </label>
          <input type="number" class="form-control" id="sub_partial_weight" 
                 step="0.01" min="0" placeholder="0.00">
          <div class="invalid-feedback" id="sub_partial_weight_error"></div>
          <small class="text-muted">
            <strong>Available:</strong> <span id="sub_available_weight_display" class="text-success fw-bold">0.00</span> KG
          </small>
        </div>

        <!-- Partial FOB -->
        <div class="mb-3">
          <label class="form-label fw-bold">
            <i class="ti ti-currency-dollar me-1"></i>Partial FOB
          </label>
          <input type="number" class="form-control" id="sub_partial_fob" 
                 step="0.01" min="0" placeholder="0.00">
          <div class="invalid-feedback" id="sub_partial_fob_error"></div>
          <small class="text-muted">
            <strong>Available:</strong> <span id="sub_available_fob_display" class="text-success fw-bold">0.00</span>
          </small>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
          <i class="ti ti-x me-1"></i> Cancel
        </button>
        <button type="button" class="btn btn-success" id="saveSubPartielleBtn">
          <i class="ti ti-check me-1"></i> Save PARTIELLE
        </button>
      </div>
    </div>
  </div>
</div>

<!-- Files Detail Modal -->
<div class="modal fade" id="filesDetailModal" tabindex="-1" data-bs-backdrop="static">
  <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">
          <i class="ti ti-files me-2"></i>Files Using PARTIELLE: <span id="files_partielle_name"></span>
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="alert alert-info">
          <strong>Total Files:</strong> <span id="files_total_count">0</span> | 
          <strong>Total Weight:</strong> <span id="files_total_weight">0.00</span> KG | 
          <strong>Total FOB:</strong> <span id="files_total_fob">0.00</span>
        </div>

        <div class="table-responsive">
          <table class="table table-bordered table-hover files-detail-table">
            <thead>
              <tr>
                <th style="width: 50px;">#</th>
                <th>MCA Reference</th>
                <th>Inspection Reports</th>
                <th>Declaration Reference</th>
                <th>DGDA In Date</th>
                <th>Liquidation Reference</th>
                <th>Liquidation Date</th>
                <th>Quittance Reference</th>
                <th>Quittance Date</th>
                <th>Weight</th>
                <th>FOB</th>
              </tr>
            </thead>
            <tbody id="filesDetailTableBody">
              <tr>
                <td colspan="11" class="text-center text-muted">Loading files...</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
          <i class="ti ti-x me-1"></i> Close
        </button>
      </div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  $(document).ready(function () {
    const csrfToken = $('#importForm').data('csrf-token');
    
    let clearingStatusIds = {
      in_transit_id: null,
      in_progress_id: null,
      completed_id: null
    };
    
    let selectedClientId = null;
    let selectedTransportModeId = null;
    let selectedStartDate = null;
    let selectedEndDate = null;
    let currentTypeOfGoodsId = null;
    
    function loadClearingStatusIds() {
      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/getClearingStatusIds',
        method: 'GET',
        dataType: 'json',
        success: function(res) {
          if (res.success) {
            clearingStatusIds = res.data;
            console.log('✅ Clearing Status IDs loaded:', clearingStatusIds);
            
            if (clearingStatusIds.in_transit_id) {
              $('#clearing_status').val(clearingStatusIds.in_transit_id);
            }
          } else {
            console.error('❌ Failed to load clearing status IDs');
          }
        },
        error: function() {
          console.error('❌ Error loading clearing status IDs');
        }
      });
    }
    
    loadClearingStatusIds();

    // ========================================
    // APPLY FILTERS FUNCTIONALITY
    // ========================================

    $('#applyFiltersBtn').on('click', function() {
      selectedClientId = $('#filterClientSelect').val() ? parseInt($('#filterClientSelect').val()) : null;
      selectedTransportModeId = $('#filterTransportModeSelect').val() ? parseInt($('#filterTransportModeSelect').val()) : null;
      selectedStartDate = $('#filterStartDate').val() || null;
      selectedEndDate = $('#filterEndDate').val() || null;
      
      console.log('🔍 Applying filters:', {
        client_id: selectedClientId,
        transport_mode_id: selectedTransportModeId,
        start_date: selectedStartDate,
        end_date: selectedEndDate
      });
      
      if (typeof importsTable !== 'undefined') {
        importsTable.ajax.reload();
      }
      
      updateActiveFiltersDisplay();
      updateBulkUpdateButton();
      
      Swal.fire({
        icon: 'success',
        title: 'Filters Applied',
        text: 'Your filters have been applied successfully!',
        timer: 1500,
        showConfirmButton: false
      });
    });

    $('#clearFilters').on('click', function() {
      $('.stats-card').removeClass('active');
      activeFilters = [];
      selectedClientId = null;
      selectedTransportModeId = null;
      selectedStartDate = null;
      selectedEndDate = null;
      
      $('#filterClientSelect').val('');
      $('#filterTransportModeSelect').val('');
      $('#filterStartDate').val('');
      $('#filterEndDate').val('');
      
      updateActiveFiltersDisplay();
      applyFiltersToTable();
      updateBulkUpdateButton();
    });

    // ========================================
    // COMMODITY FUNCTIONALITY
    // ========================================

    $('#addCommodityBtn').on('click', function() {
      $('#commodity_name_input').val('');
      $('#commodityModal').modal('show');
    });

    $('#saveCommodityBtn').on('click', function() {
      const commodityName = $('#commodity_name_input').val().trim();
      
      if (!commodityName) {
        Swal.fire({
          icon: 'warning',
          title: 'Name Required',
          text: 'Please enter a commodity name.',
          confirmButtonText: 'OK',
          confirmButtonColor: '#f39c12'
        });
        return;
      }
      
      const $saveBtn = $('#saveCommodityBtn');
      const originalText = $saveBtn.html();
      $saveBtn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm me-1"></i> Creating...');
      
      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/createCommodity',
        method: 'POST',
        data: {
          commodity_name: commodityName,
          csrf_token: csrfToken
        },
        dataType: 'json',
        success: function(res) {
          $saveBtn.prop('disabled', false).html(originalText);
          
          if (res.success) {
            $('#commodity').append(new Option(commodityName, res.id));
            $('#commodity').val(res.id);
            $('#commodityModal').modal('hide');
            
            Swal.fire({
              icon: 'success',
              title: 'Created!',
              text: 'Commodity created successfully!',
              timer: 1500,
              showConfirmButton: false
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Failed',
              html: res.message || 'Failed to create commodity',
              confirmButtonText: 'OK'
            });
          }
        },
        error: function(xhr) {
          $saveBtn.prop('disabled', false).html(originalText);
          
          let errorMsg = 'An error occurred while creating commodity';
          
          if (xhr.responseJSON && xhr.responseJSON.message) {
            errorMsg = xhr.responseJSON.message;
          } else if (xhr.status === 403) {
            errorMsg = 'Security token expired. Please refresh the page and try again.';
          }
          
          Swal.fire({
            icon: 'error',
            title: 'Error',
            html: errorMsg,
            confirmButtonText: 'OK'
          });
        }
      });
    });

    function loadCommoditiesForLicense() {
      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/getCommodities',
        method: 'GET',
        dataType: 'json',
        success: function(res) {
          if (res.success && res.data && res.data.length > 0) {
            $('#commodity').html('<option value="">-- Select Commodity --</option>');
            res.data.forEach(function(commodity) {
              $('#commodity').append(
                new Option(commodity.commodity_name, commodity.id)
              );
            });
          }
        },
        error: function() {
          console.error('Failed to load commodities');
        }
      });
    }

// ========================================
// PARTIELLE MANAGEMENT
// ========================================

let currentPartielleData = [];
let currentLicenseData = {
  subscriber_id: null,
  license_id: null,
  crf_reference: null,
  license_weight: 0,
  license_fob: 0,
  available_weight: 0,
  available_fob: 0
};

// Open Main PARTIELLE Modal
$('#addPartielleBtn').on('click', function() {
  const subscriberId = $('#subscriber_id').val();
  const clientName = $('#subscriber_id option:selected').text();
  const licenseId = $('#license_id').val();
  const licenseNumber = $('#license_id option:selected').text();
  const crfReference = $('#crf_reference').val();
  
  console.log('🔍 Opening PARTIELLE management:', {
    subscriber_id: subscriberId,
    client_name: clientName,
    license_id: licenseId,
    license_number: licenseNumber,
    crf_reference: crfReference
  });
  
  if (!subscriberId || subscriberId === '') {
    Swal.fire({
      icon: 'warning',
      title: 'Client Required',
      text: 'Please select a Client first.',
      confirmButtonText: 'OK',
      confirmButtonColor: '#f39c12'
    });
    return;
  }
  
  if (!licenseId || licenseId === '') {
    Swal.fire({
      icon: 'warning',
      title: 'License Required',
      text: 'Please select a License first.',
      confirmButtonText: 'OK',
      confirmButtonColor: '#f39c12'
    });
    return;
  }
  
  if (!crfReference || crfReference.trim() === '') {
    Swal.fire({
      icon: 'warning',
      title: 'CRF Reference Required',
      text: 'The selected license must have a CRF Reference.',
      confirmButtonText: 'OK',
      confirmButtonColor: '#f39c12'
    });
    return;
  }
  
  currentLicenseData.subscriber_id = subscriberId;
  currentLicenseData.license_id = licenseId;
  currentLicenseData.crf_reference = crfReference;
  
  $('#partielle_subscriber_id_hidden').val(subscriberId);
  $('#partielle_license_id_hidden').val(licenseId);
  $('#partielle_crf_reference_hidden').val(crfReference);
  $('#partielle_client_display_main').text(clientName);
  $('#partielle_license_display_main').text(licenseNumber);
  $('#partielle_crf_display_main').text(crfReference);
  
  loadPartielleManagementData(subscriberId, licenseId);
  
  $('#partielleModal').modal('show');
});

// Load PARTIELLE Data for License
function loadPartielleManagementData(subscriberId, licenseId) {
  console.log('📊 Loading PARTIELLE data:', {
    subscriber_id: subscriberId,
    license_id: licenseId
  });
  
  $('#partielleTableBody').html(`
    <tr>
      <td colspan="13" class="text-center">
        <div class="spinner-border spinner-border-sm text-primary" role="status">
          <span class="visually-hidden">Loading...</span>
        </div>
        <p class="mb-0 mt-2">Loading PARTIELLEs...</p>
      </td>
    </tr>
  `);
  
  $.ajax({
    url: '<?= APP_URL ?>/import/crudData/getPartielleManagement',
    method: 'GET',
    data: { 
      subscriber_id: subscriberId,
      license_id: licenseId 
    },
    dataType: 'json',
    success: function(res) {
      console.log('📥 PARTIELLE management response:', res);
      
      if (res.success && res.data) {
        currentLicenseData.license_weight = parseFloat(res.data.license_weight || 0);
        currentLicenseData.license_fob = parseFloat(res.data.license_fob || 0);
        currentLicenseData.available_weight = parseFloat(res.data.available_weight || 0);
        currentLicenseData.available_fob = parseFloat(res.data.available_fob || 0);
        
        $('#partielle_license_weight_display_main').text(
          currentLicenseData.license_weight.toLocaleString('en-US', { 
            minimumFractionDigits: 2, 
            maximumFractionDigits: 2 
          })
        );
        
        $('#partielle_license_fob_display_main').text(
          currentLicenseData.license_fob.toLocaleString('en-US', { 
            minimumFractionDigits: 2, 
            maximumFractionDigits: 2 
          })
        );
        
        $('#partielle_available_weight_display_main').text(
          currentLicenseData.available_weight.toLocaleString('en-US', { 
            minimumFractionDigits: 2, 
            maximumFractionDigits: 2 
          })
        );
        
        $('#partielle_available_fob_display_main').text(
          currentLicenseData.available_fob.toLocaleString('en-US', { 
            minimumFractionDigits: 2, 
            maximumFractionDigits: 2 
          })
        );
        
        currentPartielleData = res.data.partielles || [];
        renderPartielleTable(currentPartielleData);
      } else {
        $('#partielleTableBody').html(`
          <tr>
            <td colspan="13" class="text-center text-danger">
              <i class="ti ti-alert-circle me-1"></i>
              ${escapeHtml(res.message || 'Failed to load PARTIELLE data')}
            </td>
          </tr>
        `);
      }
    },
    error: function(xhr) {
      console.error('❌ Failed to load PARTIELLE management:', xhr);
      $('#partielleTableBody').html(`
        <tr>
          <td colspan="13" class="text-center text-danger">
            <i class="ti ti-alert-circle me-1"></i>
            Failed to load data. Please try again.
          </td>
        </tr>
      `);
    }
  });
}

// Render PARTIELLE Table
function renderPartielleTable(partielles) {
  console.log('📋 Rendering PARTIELLE table with', partielles.length, 'records');
  
  if (!partielles || partielles.length === 0) {
    $('#partielleTableBody').html(`
      <tr>
        <td colspan="13" class="text-center text-muted">
          <i class="ti ti-info-circle me-1"></i>
          No PARTIELLEs found. Click "Add New PARTIELLE" to create one.
        </td>
      </tr>
    `);
    return;
  }
  
  let html = '';
  partielles.forEach((p, index) => {
    const licenseWeight = parseFloat(p.license_weight || 0);
    const licenseFob = parseFloat(p.license_fob || 0);
    const partialWeight = parseFloat(p.partial_weight || 0);
    const partialFob = parseFloat(p.partial_fob || 0);
    const weightInFiles = parseFloat(p.weight_in_files || 0);
    const fobInFiles = parseFloat(p.fob_in_files || 0);
    const noOfFiles = parseInt(p.no_of_files || 0);
    
    const partialMinusUsedWeight = partialWeight - weightInFiles;
    const partialMinusUsedFob = partialFob - fobInFiles;
    
    const balanceWeightClass = partialMinusUsedWeight >= 0 ? 'text-balance-positive' : 'text-balance-negative';
    const balanceFobClass = partialMinusUsedFob >= 0 ? 'text-balance-positive' : 'text-balance-negative';
    
    html += `
      <tr data-partielle-id="${p.id}" data-partielle-name="${escapeHtml(p.partial_name)}">
        <td><span class="partielle-row-number">${index + 1}</span></td>
        <td><strong>${escapeHtml(p.crf_reference || '-')}</strong></td>
        <td><span class="badge bg-primary">${escapeHtml(p.partial_name || '-')}</span></td>
        <td>${licenseWeight.toFixed(2)}</td>
        <td>${licenseFob.toFixed(2)}</td>
        <td>
          <span class="badge-count view-files-btn" 
                data-partielle-id="${p.id}" 
                data-partial-name="${escapeHtml(p.partial_name)}"
                title="Click to view files">
            ${noOfFiles}
          </span>
        </td>
        <td><strong>${partialWeight.toFixed(2)}</strong></td>
        <td><strong>${partialFob.toFixed(2)}</strong></td>
        <td class="text-info"><strong>${weightInFiles.toFixed(2)}</strong></td>
        <td class="text-info"><strong>${fobInFiles.toFixed(2)}</strong></td>
        <td class="${balanceWeightClass}">${partialMinusUsedWeight.toFixed(2)}</td>
        <td class="${balanceFobClass}">${partialMinusUsedFob.toFixed(2)}</td>
        <td>
          <button type="button" class="btn btn-sm btn-warning edit-partielle-btn" 
                  data-partielle-id="${p.id}" 
                  data-partial-name="${escapeHtml(p.partial_name)}"
                  data-partial-weight="${partialWeight}"
                  data-partial-fob="${partialFob}"
                  title="Edit">
            <i class="ti ti-edit"></i>
          </button>
        </td>
      </tr>
    `;
  });
  
  $('#partielleTableBody').html(html);
}

// View Files Button Click
$(document).on('click', '.view-files-btn', function() {
  const partielleId = $(this).data('partielle-id');
  const partialName = $(this).data('partial-name');
  
  console.log('📂 Opening files detail for PARTIELLE:', {
    id: partielleId,
    name: partialName
  });
  
  $('#files_partielle_name').text(partialName);
  $('#filesDetailModal').modal('show');
  
  loadFilesForPartielle(partielleId, partialName);
});

// Load Files for PARTIELLE
function loadFilesForPartielle(partielleId, partialName) {
  $('#filesDetailTableBody').html(`
    <tr>
      <td colspan="11" class="text-center">
        <div class="spinner-border spinner-border-sm text-primary" role="status">
          <span class="visually-hidden">Loading...</span>
        </div>
        <p class="mb-0 mt-2">Loading files...</p>
      </td>
    </tr>
  `);
  
  $.ajax({
    url: '<?= APP_URL ?>/import/crudData/getFilesForPartielle',
    method: 'GET',
    data: { 
      partial_name: partialName
    },
    dataType: 'json',
    success: function(res) {
      console.log('📥 Files for PARTIELLE response:', res);
      
      if (res.success && res.data && res.data.files && res.data.files.length > 0) {
        const files = res.data.files;
        const totalWeight = parseFloat(res.data.total_weight || 0);
        const totalFob = parseFloat(res.data.total_fob || 0);
        
        $('#files_total_count').text(files.length);
        $('#files_total_weight').text(totalWeight.toFixed(2));
        $('#files_total_fob').text(totalFob.toFixed(2));
        
        let html = '';
        files.forEach((file, index) => {
          html += `
            <tr>
              <td>${index + 1}</td>
              <td><span class="badge bg-primary">${escapeHtml(file.mca_ref || '-')}</span></td>
              <td><small>${escapeHtml(file.inspection_reports || '-')}</small></td>
              <td><small>${escapeHtml(file.declaration_reference || '-')}</small></td>
              <td><small>${escapeHtml(formatDate(file.dgda_in_date) || '-')}</small></td>
              <td><small>${escapeHtml(file.liquidation_reference || '-')}</small></td>
              <td><small>${escapeHtml(formatDate(file.liquidation_date) || '-')}</small></td>
              <td><small>${escapeHtml(file.quittance_reference || '-')}</small></td>
              <td><small>${escapeHtml(formatDate(file.quittance_date) || '-')}</small></td>
              <td><strong>${parseFloat(file.weight || 0).toFixed(2)}</strong></td>
              <td><strong>${parseFloat(file.fob || 0).toFixed(2)}</strong></td>
            </tr>
          `;
        });
        
        $('#filesDetailTableBody').html(html);
      } else {
        $('#files_total_count').text('0');
        $('#files_total_weight').text('0.00');
        $('#files_total_fob').text('0.00');
        
        $('#filesDetailTableBody').html(`
          <tr>
            <td colspan="11" class="text-center text-muted">
              <i class="ti ti-info-circle me-1"></i>
              No files found using this PARTIELLE.
            </td>
          </tr>
        `);
      }
    },
    error: function(xhr) {
      console.error('❌ Failed to load files for PARTIELLE:', xhr);
      $('#filesDetailTableBody').html(`
        <tr>
          <td colspan="11" class="text-center text-danger">
            <i class="ti ti-alert-circle me-1"></i>
            Failed to load files. Please try again.
          </td>
        </tr>
      `);
    }
  });
}

// Edit PARTIELLE Button
$(document).on('click', '.edit-partielle-btn', function() {
  const partielleId = $(this).data('partielle-id');
  const partialName = $(this).data('partial-name');
  const partialWeight = parseFloat($(this).data('partial-weight'));
  const partialFob = parseFloat($(this).data('partial-fob'));
  
  console.log('✏️ Editing PARTIELLE:', {
    id: partielleId,
    name: partialName,
    weight: partialWeight,
    fob: partialFob
  });
  
  openAddPartielleSubModal(partielleId, partialName, partialWeight, partialFob);
});

// Open Sub-Modal to Add New PARTIELLE
$('#addNewPartielleBtn').on('click', function() {
  openAddPartielleSubModal();
});

// Open Add/Edit PARTIELLE Sub-Modal
function openAddPartielleSubModal(partielleId = null, partialName = '', partialWeight = 0, partialFob = 0) {
  $('#edit_partielle_id').val('');
  $('#sub_partielle_number').val('').removeClass('is-invalid');
  $('#sub_partial_weight').val('').removeClass('is-invalid');
  $('#sub_partial_fob').val('').removeClass('is-invalid');
  $('#sub_partielle_preview').hide();
  
  const crfRef = currentLicenseData.crf_reference;
  $('#sub_partielle_prefix').text(crfRef + '/');
  
  if (partielleId) {
    // Edit mode
    $('#subModalTitle').text('Edit PARTIELLE');
    $('#edit_partielle_id').val(partielleId);
    
    // Extract number from partial name (e.g., "CRF123/0001" -> "0001")
    const number = partialName.split('/').pop();
    $('#sub_partielle_number').val(number);
    
    // Set weights/FOB with adjustment for available capacity
    const availableWeight = currentLicenseData.available_weight + partialWeight;
    const availableFob = currentLicenseData.available_fob + partialFob;
    
    $('#sub_partial_weight').val(partialWeight.toFixed(2));
    $('#sub_partial_fob').val(partialFob.toFixed(2));
    
    $('#sub_available_weight_display').text(
      availableWeight.toLocaleString('en-US', { 
        minimumFractionDigits: 2, 
        maximumFractionDigits: 2 
      })
    );
    
    $('#sub_available_fob_display').text(
      availableFob.toLocaleString('en-US', { 
        minimumFractionDigits: 2, 
        maximumFractionDigits: 2 
      })
    );
    
    // Show preview
    $('#sub_partielle_preview_text').text(partialName);
    $('#sub_partielle_preview').show();
  } else {
    // Add mode
    $('#subModalTitle').text('Add New PARTIELLE');
    
    $('#sub_available_weight_display').text(
      currentLicenseData.available_weight.toLocaleString('en-US', { 
        minimumFractionDigits: 2, 
        maximumFractionDigits: 2 
      })
    );
    
    $('#sub_available_fob_display').text(
      currentLicenseData.available_fob.toLocaleString('en-US', { 
        minimumFractionDigits: 2, 
        maximumFractionDigits: 2 
      })
    );
  }
  
  $('#addPartielleSubModal').modal('show');
}

// Preview PARTIELLE Number
$('#sub_partielle_number').on('input', function() {
  const crfRef = currentLicenseData.crf_reference;
  const number = $(this).val().trim();
  
  if (number) {
    const fullReference = crfRef + '/' + number;
    $('#sub_partielle_preview_text').text(fullReference);
    $('#sub_partielle_preview').show();
  } else {
    $('#sub_partielle_preview').hide();
  }
});

// Validate Sub-Modal Inputs
$('#sub_partial_weight').on('input', function() {
  const editMode = $('#edit_partielle_id').val() !== '';
  const enteredWeight = parseFloat($(this).val()) || 0;
  let availableWeight = currentLicenseData.available_weight;
  
  // In edit mode, add back the current value to available capacity
  if (editMode) {
    const currentWeight = parseFloat($('#sub_partial_weight').data('original-value')) || 0;
    availableWeight += currentWeight;
  }
  
  if (enteredWeight > availableWeight) {
    $(this).addClass('is-invalid');
    $('#sub_partial_weight_error').text(
      `Weight cannot exceed available: ${availableWeight.toFixed(2)} KG`
    ).show();
  } else {
    $(this).removeClass('is-invalid');
    $('#sub_partial_weight_error').text('').hide();
  }
});

$('#sub_partial_fob').on('input', function() {
  const editMode = $('#edit_partielle_id').val() !== '';
  const enteredFob = parseFloat($(this).val()) || 0;
  let availableFob = currentLicenseData.available_fob;
  
  // In edit mode, add back the current value to available capacity
  if (editMode) {
    const currentFob = parseFloat($('#sub_partial_fob').data('original-value')) || 0;
    availableFob += currentFob;
  }
  
  if (enteredFob > availableFob) {
    $(this).addClass('is-invalid');
    $('#sub_partial_fob_error').text(
      `FOB cannot exceed available: ${availableFob.toFixed(2)}`
    ).show();
  } else {
    $(this).removeClass('is-invalid');
    $('#sub_partial_fob_error').text('').hide();
  }
});

// Save PARTIELLE from Sub-Modal
$('#saveSubPartielleBtn').on('click', function() {
  const crfRef = currentLicenseData.crf_reference;
  const number = $('#sub_partielle_number').val().trim();
  const subscriberId = currentLicenseData.subscriber_id;
  const licenseId = currentLicenseData.license_id;
  const partielleId = $('#edit_partielle_id').val();
  
  const partialWeight = parseFloat($('#sub_partial_weight').val()) || 0;
  const partialFob = parseFloat($('#sub_partial_fob').val()) || 0;
  
  let availableWeight = currentLicenseData.available_weight;
  let availableFob = currentLicenseData.available_fob;
  
  // In edit mode, add back current values
  if (partielleId) {
    const originalWeight = parseFloat($('#sub_partial_weight').data('original-value')) || 0;
    const originalFob = parseFloat($('#sub_partial_fob').data('original-value')) || 0;
    availableWeight += originalWeight;
    availableFob += originalFob;
  }
  
  console.log('💾 Saving PARTIELLE:', {
    id: partielleId || 'NEW',
    subscriber_id: subscriberId,
    license_id: licenseId,
    partial_name: crfRef + '/' + number,
    partial_weight: partialWeight,
    partial_fob: partialFob,
    available_weight: availableWeight,
    available_fob: availableFob
  });
  
  if (!number) {
    Swal.fire({
      icon: 'warning',
      title: 'Number Required',
      text: 'Please enter a number for the PARTIELLE reference.',
      confirmButtonText: 'OK',
      confirmButtonColor: '#f39c12'
    });
    return;
  }
  
  if (partialWeight > availableWeight) {
    $('#sub_partial_weight').addClass('is-invalid');
    $('#sub_partial_weight_error').text(
      `Weight cannot exceed available: ${availableWeight.toFixed(2)} KG`
    ).show();
    
    Swal.fire({
      icon: 'error',
      title: 'Weight Limit Exceeded',
      html: `Partial Weight cannot exceed available weight.<br><br><strong>Available:</strong> ${availableWeight.toFixed(2)} KG<br><strong>Entered:</strong> ${partialWeight.toFixed(2)} KG`,
      confirmButtonText: 'OK'
    });
    return;
  }
  
  if (partialFob > availableFob) {
    $('#sub_partial_fob').addClass('is-invalid');
    $('#sub_partial_fob_error').text(
      `FOB cannot exceed available: ${availableFob.toFixed(2)}`
    ).show();
    
    Swal.fire({
      icon: 'error',
      title: 'FOB Limit Exceeded',
      html: `Partial FOB cannot exceed available FOB.<br><br><strong>Available:</strong> ${availableFob.toFixed(2)}<br><strong>Entered:</strong> ${partialFob.toFixed(2)}`,
      confirmButtonText: 'OK'
    });
    return;
  }
  
  const fullReference = crfRef + '/' + number;
  
  const $saveBtn = $('#saveSubPartielleBtn');
  const originalText = $saveBtn.html();
  $saveBtn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm me-1"></i> Saving...');
  
  const requestData = {
    partial_name: fullReference,
    subscriber_id: subscriberId,
    license_id: licenseId,
    partial_weight: partialWeight,
    partial_fob: partialFob,
    csrf_token: csrfToken
  };
  
  if (partielleId) {
    requestData.id = partielleId;
  }
  
  const url = partielleId 
    ? '<?= APP_URL ?>/import/crudData/updatePartielle'
    : '<?= APP_URL ?>/import/crudData/createPartielle';
  
  $.ajax({
    url: url,
    method: 'POST',
    data: requestData,
    dataType: 'json',
    success: function(res) {
      $saveBtn.prop('disabled', false).html(originalText);
      
      console.log('📥 PARTIELLE save response:', res);
      
      if (res.success) {
        $('#addPartielleSubModal').modal('hide');
        
        Swal.fire({
          icon: 'success',
          title: partielleId ? 'Updated!' : 'Created!',
          text: res.message || 'PARTIELLE saved successfully!',
          timer: 1500,
          showConfirmButton: false
        });
        
        loadPartielleManagementData(subscriberId, licenseId);
        loadPartielleOptionsForLicense(licenseId);
      } else {
        Swal.fire({
          icon: 'error',
          title: 'Failed',
          html: res.message || 'Failed to save PARTIELLE',
          confirmButtonText: 'OK'
        });
      }
    },
    error: function(xhr) {
      $saveBtn.prop('disabled', false).html(originalText);
      
      console.error('❌ PARTIELLE save error:', xhr);
      
      let errorMsg = 'An error occurred while saving PARTIELLE';
      
      if (xhr.responseJSON && xhr.responseJSON.message) {
        errorMsg = xhr.responseJSON.message;
      } else if (xhr.status === 403) {
        errorMsg = 'Security token expired. Please refresh the page and try again.';
      }
      
      Swal.fire({
        icon: 'error',
        title: 'Error',
        html: errorMsg,
        confirmButtonText: 'OK'
      });
    }
  });
});

// Load PARTIELLE Options for Inspection Reports Dropdown
function loadPartielleOptionsForLicense(licenseId) {
  console.log('📋 Loading PARTIELLE options for dropdown - license_id:', licenseId);
  
  if (!licenseId) {
    $('#inspection_reports').html('<option value="">-- Select PARTIELLE --</option>');
    return;
  }
  
  $('#inspection_reports').html('<option value="">Loading...</option>').prop('disabled', true);
  
  $.ajax({
    url: '<?= APP_URL ?>/import/crudData/getPartielleOptions',
    method: 'GET',
    data: { license_id: licenseId },
    dataType: 'json',
    success: function(res) {
      console.log('📥 PARTIELLE options response:', res);
      
      $('#inspection_reports').html('<option value="">-- Select PARTIELLE --</option>').prop('disabled', false);
      
      if (res.success && res.data && res.data.length > 0) {
        res.data.forEach(function(partial) {
          const weightInfo = `(Alloc: ${parseFloat(partial.partial_weight || 0).toFixed(2)} KG)`;
          $('#inspection_reports').append(
            new Option(`${partial.partial_name} ${weightInfo}`, partial.partial_name)
          );
        });
        console.log('✅ Loaded', res.data.length, 'PARTIELLE options');
      } else {
        console.log('ℹ️ No PARTIELLE options found for this license');
      }
    },
    error: function(xhr) {
      console.error('❌ Failed to load PARTIELLE options:', xhr);
      $('#inspection_reports').html('<option value="">-- Error Loading --</option>').prop('disabled', false);
    }
  });
}

    // When PARTIELLE changes - show allocated weight/FOB
    $('#inspection_reports').on('change', function() {
      const partialName = $(this).val();
      
      console.log('🔄 PARTIELLE changed:', partialName);
      
      if (!partialName || partialName === '') {
        $('#available_partial_weight_display').val('');
        $('#available_partial_fob_display').val('');
        $('#available_partial_weight_hidden').val('');
        $('#available_partial_fob_hidden').val('');
        console.log('✅ PARTIELLE cleared');
        return;
      }

      console.log('🔍 Loading PARTIELLE capacity for:', partialName);

      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/getPartielleDetails',
        method: 'GET',
        data: { partial_name: partialName },
        dataType: 'json',
        success: function(res) {
          console.log('📥 PARTIELLE details response:', res);
          
          if (res.success && res.data) {
            const data = res.data;
            
            const partialWeight = parseFloat(data.partial_weight || 0);
            const partialFob = parseFloat(data.partial_fob || 0);
            
            console.log('📊 PARTIELLE capacity:', {
              partial_weight: partialWeight,
              partial_fob: partialFob
            });
            
            // Display the allocated amounts
            $('#available_partial_weight_display').val(
              partialWeight.toLocaleString('en-US', { 
                minimumFractionDigits: 2, 
                maximumFractionDigits: 2 
              }) + ' KG'
            );
            
            $('#available_partial_fob_display').val(
              partialFob.toLocaleString('en-US', { 
                minimumFractionDigits: 2, 
                maximumFractionDigits: 2 
              })
            );
            
            $('#available_partial_weight_hidden').val(partialWeight);
            $('#available_partial_fob_hidden').val(partialFob);
            
            console.log('✅ PARTIELLE capacity set:', {
              partial_weight: partialWeight,
              partial_fob: partialFob
            });
          } else {
            console.error('❌ PARTIELLE details failed:', res.message);
            $('#available_partial_weight_display').val('N/A');
            $('#available_partial_fob_display').val('N/A');
            $('#available_partial_weight_hidden').val('0');
            $('#available_partial_fob_hidden').val('0');
          }
        },
        error: function(xhr) {
          console.error('❌ Failed to load PARTIELLE details:', xhr);
          $('#available_partial_weight_display').val('Error');
          $('#available_partial_fob_display').val('Error');
        }
      });
    });

    // Validate Weight against PARTIELLE allocation
    $('#weight').on('input change', function() {
      const enteredWeight = parseFloat($(this).val()) || 0;
      const partialWeight = parseFloat($('#available_partial_weight_hidden').val()) || Infinity;
      const partialName = $('#inspection_reports').val();
      
      console.log('⚖️ Weight validation triggered:', {
        entered_weight: enteredWeight,
        partial_weight: partialWeight,
        partial_name: partialName,
        has_partielle: !!partialName
      });
      
      if (!partialName || partialName === '') {
        $(this).removeClass('is-invalid');
        $('#weight_error').text('').hide();
        console.log('✅ No PARTIELLE selected - skipping validation');
        return;
      }
      
      if (enteredWeight > partialWeight) {
        $(this).addClass('is-invalid');
        $('#weight_error').text(
          `Weight cannot exceed PARTIELLE allocation: ${partialWeight.toFixed(2)} KG`
        ).show();
        console.log('❌ Weight exceeds PARTIELLE allocation');
      } else {
        $(this).removeClass('is-invalid');
        $('#weight_error').text('').hide();
        console.log('✅ Weight within PARTIELLE allocation');
      }
    });

    // Validate FOB against PARTIELLE allocation
    $('#fob').on('input change', function() {
      const enteredFob = parseFloat($(this).val()) || 0;
      const partialFob = parseFloat($('#available_partial_fob_hidden').val()) || Infinity;
      const partialName = $('#inspection_reports').val();
      
      console.log('💰 FOB validation triggered:', {
        entered_fob: enteredFob,
        partial_fob: partialFob,
        partial_name: partialName
      });
      
      if (!partialName || partialName === '') {
        $(this).removeClass('is-invalid');
        $('#fob_error').text('').hide();
        console.log('✅ No PARTIELLE selected - skipping validation');
        return;
      }
      
      if (enteredFob > partialFob) {
        $(this).addClass('is-invalid');
        $('#fob_error').text(
          `FOB cannot exceed PARTIELLE allocation: ${partialFob.toFixed(2)}`
        ).show();
        console.log('❌ FOB exceeds PARTIELLE allocation');
      } else {
        $(this).removeClass('is-invalid');
        $('#fob_error').text('').hide();
        console.log('✅ FOB within PARTIELLE allocation');
      }
    });

    $('#license_id').on('change', function() {
      const licenseId = $(this).val();
      const licenseNumber = $(this).find('option:selected').text();
      
      console.log('🔄 License changed:', {
        license_id: licenseId,
        license_number: licenseNumber
      });
      
      if (!licenseId) {
        $('#inspection_reports').html('<option value="">-- Select PARTIELLE --</option>');
        clearLicenseFields();
        return;
      }
      
      $('#kind_display, #type_of_goods_display, #transport_mode_display, #currency_display, #supplier, #crf_reference').val('Loading...');

      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/getLicenseDetails',
        method: 'GET',
        data: { license_id: licenseId },
        dataType: 'json',
        success: function(res) {
          console.log('📥 License details response:', res);
          
          if (res.success && res.data) {
            const license = res.data;
            
            $('#kind_hidden').val(license.kind_id || '');
            $('#type_of_goods_hidden').val(license.type_of_goods_id || '');
            $('#transport_mode_hidden').val(license.transport_mode_id || '');
            $('#currency_hidden').val(license.currency_id || '');
            
            currentTypeOfGoodsId = license.type_of_goods_id || null;
            
            console.log('✅ Type of Goods ID captured:', currentTypeOfGoodsId);
            console.log('✅ License data:', {
              kind_id: license.kind_id,
              type_of_goods_id: license.type_of_goods_id,
              type_of_goods_name: license.type_of_goods_name,
              transport_mode_id: license.transport_mode_id,
              currency_id: license.currency_id
            });
            
            $('#kind_display').val(escapeHtml(license.kind_name || ''));
            $('#type_of_goods_display').val(escapeHtml(license.type_of_goods_name || ''));
            $('#transport_mode_display').val(escapeHtml(license.transport_mode_name || ''));
            $('#currency_display').val(escapeHtml(license.currency_name || ''));
            $('#supplier').val(escapeHtml(license.supplier || ''));
            $('#crf_reference').val(escapeHtml(license.ref_cod || ''));
            
            syncCurrencyFields(license.currency_id);
            generateMCAReference();
            handleTransportModeFields(license.transport_mode_id, license.transport_mode_name);
          } else {
            console.error('❌ License details failed:', res.message);
            clearLicenseFields();
            Swal.fire({
              icon: 'error',
              title: 'Error',
              html: res.message || 'Failed to load license details',
              confirmButtonText: 'OK'
            });
          }
        },
        error: function(xhr) {
          console.error('❌ License details AJAX error:', xhr);
          clearLicenseFields();
          
          let errorMsg = 'Failed to load license details';
          
          if (xhr.responseJSON && xhr.responseJSON.message) {
            errorMsg = xhr.responseJSON.message;
          }
          
          Swal.fire({
            icon: 'error',
            title: 'Error',
            html: errorMsg,
            confirmButtonText: 'OK'
          });
        }
      });
      
      loadPartielleOptionsForLicense(licenseId);
    });

    function loadPartielleForEdit(licenseId, selectedPartielle) {
      console.log('✏️ Loading PARTIELLE for edit:', {
        license_id: licenseId,
        selected: selectedPartielle
      });
      
      if (!licenseId) {
        return;
      }
      
      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/getPartielleOptions',
        method: 'GET',
        data: { license_id: licenseId },
        dataType: 'json',
        success: function(res) {
          $('#inspection_reports').html('<option value="">-- Select PARTIELLE --</option>');
          
          if (res.success && res.data && res.data.length > 0) {
            res.data.forEach(function(partial) {
              const weightInfo = `(Alloc: ${parseFloat(partial.partial_weight || 0).toFixed(2)} KG)`;
              $('#inspection_reports').append(
                new Option(`${partial.partial_name} ${weightInfo}`, partial.partial_name)
              );
            });
            
            if (selectedPartielle) {
              $('#inspection_reports').val(selectedPartielle);
              console.log('✅ Selected PARTIELLE:', selectedPartielle);
            }
          }
        },
        error: function(xhr) {
          console.error('❌ Failed to load PARTIELLE for edit:', xhr);
        }
      });
    }

    // ========================================
    // HELPER FUNCTIONS
    // ========================================

    function escapeHtml(text) {
      if (text === null || text === undefined) return '';
      const map = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#039;'
      };
      return String(text).replace(/[&<>"']/g, function(m) { return map[m]; });
    }

    let remarksArray = [];
    let remarkCounter = 0;
    let activeFilters = [];
    let bulkUpdateData = [];

    function updateDocumentStatus() {
      const crfDate = $('#crf_received_date').val();
      const adDate = $('#ad_date').val();
      const insuranceDate = $('#insurance_date').val();
      
      let statusId = 1;
      
      if (crfDate && adDate && insuranceDate) {
        statusId = 7;
      } else if (crfDate && insuranceDate) {
        statusId = 6;
      } else if (adDate && insuranceDate) {
        statusId = 4;
      } else if (crfDate && adDate) {
        statusId = 3;
      } else if (crfDate) {
        statusId = 2;
      }
      
      $('#document_status').val(statusId);
    }
    
    $('.document-status-trigger').on('change', function() {
      updateDocumentStatus();
    });

    // ✅ UPDATED: Clearing Status - Fully Automatic (No Manual Override)
    function suggestClearingStatus() {
      const borderWarehouseArrival = $('#border_warehouse_arrival_date').val();
      const quittanceDate = $('#quittance_date').val();
      
      let suggestedStatus = null;
      let suggestedStatusName = '';
      
      if (quittanceDate && clearingStatusIds.completed_id) {
        suggestedStatus = clearingStatusIds.completed_id;
        suggestedStatusName = 'COMPLETED';
      } else if (borderWarehouseArrival && clearingStatusIds.in_progress_id) {
        suggestedStatus = clearingStatusIds.in_progress_id;
        suggestedStatusName = 'IN PROGRESS';
      } else if (clearingStatusIds.in_transit_id) {
        suggestedStatus = clearingStatusIds.in_transit_id;
        suggestedStatusName = 'IN TRANSIT';
      }
      
      if (suggestedStatus) {
        $('#clearing_status').val(suggestedStatus);
        $('#clearing_status').addClass('border-success');
        setTimeout(() => {
          $('#clearing_status').removeClass('border-success');
        }, 1000);
        
        console.log(`🤖 Auto-suggested: ${suggestedStatusName}`);
      }
    }
    
    $('.clearing-status-trigger').on('change', function() {
      suggestClearingStatus();
    });

    function adjustLogisticsLayout() {
      const clearanceId = parseInt($('#types_of_clearance').val());
      const transportMode = $('#transport_mode_display').val().toUpperCase();
      
      if (clearanceId === 3 && !transportMode.includes('AIR')) {
        $('#t1_number_col, #t1_date_col').show();
        $('#border_arrival_col_row1, #border_dispatch_col_row1').hide();
        console.log('✅ T1 shown - 5 fields: T1 Number, T1 Date, Arrival, Dispatch, DRC Entry');
      } else {
        $('#t1_number_col, #t1_date_col').hide();
        $('#t1_number, #t1_date').val('');
        $('#border_arrival_col_row1, #border_dispatch_col_row1').show();
        console.log('✅ T1 hidden - 5 fields: Arrival, Dispatch, DRC Entry, Border Arrival, Border Dispatch');
      }
    }

    $('#types_of_clearance').on('change', function() {
      adjustLogisticsLayout();
    });

    $('.date-after-prealert').on('change', function() {
      validateDateAgainstPreAlert($(this));
    });

    $('#pre_alert_date').on('change', function() {
      $('.date-after-prealert').each(function() {
        if ($(this).val()) {
          validateDateAgainstPreAlert($(this));
        }
      });
    });

    function validateDateAgainstPreAlert($field) {
      const preAlertDate = $('#pre_alert_date').val();
      const fieldValue = $field.val();
      const fieldId = $field.attr('id');
      const fieldLabel = $field.closest('.mb-3').find('label').first().text().replace('*', '').trim();

      if (!fieldValue || !preAlertDate) {
        $field.removeClass('is-invalid date-sequence-error');
        $(`#${fieldId}_error`).text('').hide();
        return true;
      }

      if (fieldValue < preAlertDate) {
        $field.addClass('is-invalid date-sequence-error');
        $(`#${fieldId}_error`).text(`${fieldLabel} cannot be before Pre-Alert Date (${formatDate(preAlertDate)})`).show();

        Swal.fire({
          icon: 'warning',
          title: 'Date Validation Error',
          html: `<strong>${escapeHtml(fieldLabel)}</strong> cannot be before <strong>Pre-Alert Date</strong>.<br><br>Pre-Alert Date: <strong>${escapeHtml(formatDate(preAlertDate))}</strong><br>Please select a date on or after the Pre-Alert Date.`,
          confirmButtonText: 'OK',
          confirmButtonColor: '#f39c12'
        });

        $field.val('');

        setTimeout(() => {
          $field.removeClass('date-sequence-error is-invalid');
          $(`#${fieldId}_error`).text('').hide();
        }, 3000);

        return false;
      }

      $field.removeClass('is-invalid date-sequence-error');
      $(`#${fieldId}_error`).text('').hide();
      return true;
    }

    $('#dispatch_from_airport').on('change', function() {
      validateAirportDateSequence();
    });

    $('#airport_arrival_date').on('change', function() {
      if ($('#dispatch_from_airport').val()) {
        validateAirportDateSequence();
      }
    });

    function validateAirportDateSequence() {
      const arrivalDate = $('#airport_arrival_date').val();
      const dispatchDate = $('#dispatch_from_airport').val();

      if (!dispatchDate || !arrivalDate) {
        $('#dispatch_from_airport').removeClass('is-invalid date-sequence-error');
        $('#dispatch_from_airport_error').text('').hide();
        return true;
      }

      if (dispatchDate < arrivalDate) {
        $('#dispatch_from_airport').addClass('is-invalid date-sequence-error');
        $('#dispatch_from_airport_error').text(`Dispatch from Airport cannot be before Airport Arrival Date (${formatDate(arrivalDate)})`).show();

        Swal.fire({
          icon: 'warning',
          title: 'Airport Date Validation Error',
          html: `<strong>Dispatch from Airport</strong> cannot be before <strong>Airport Arrival Date</strong>.<br><br>Airport Arrival Date: <strong>${escapeHtml(formatDate(arrivalDate))}</strong><br>Please select a valid dispatch date.`,
          confirmButtonText: 'OK',
          confirmButtonColor: '#f39c12'
        });

        $('#dispatch_from_airport').val('');

        setTimeout(() => {
          $('#dispatch_from_airport').removeClass('date-sequence-error is-invalid');
          $('#dispatch_from_airport_error').text('').hide();
        }, 3000);

        return false;
      }

      $('#dispatch_from_airport').removeClass('is-invalid date-sequence-error');
      $('#dispatch_from_airport_error').text('').hide();
      return true;
    }

    function handleTransportModeFields(transportModeId, transportModeName) {
      $('#air_fields, #air_entry_point_row, #wagon_field_row, #road_fields, #road_manifest_field, #logistics_fields').hide();
      $('#t1_number_col, #t1_date_col, #border_arrival_col_row1, #border_dispatch_col_row1').hide();
      
      const modeId = parseInt(transportModeId);
      const modeName = (transportModeName || '').toUpperCase();
      
      console.log('🚚 Transport Mode ID:', modeId, 'Name:', modeName);
      
      $('#entry_point_id, #entry_point_id_air').on('change', function() {
        const val = $(this).val();
        if (val) {
          $('#entry_point_id').val(val);
          $('#entry_point_id_air').val(val);
        }
      });
      
      if (modeId === 2 || modeName.includes('AIR')) {
        $('#air_fields').show();
        $('#air_entry_point_row').show();
        console.log('✈️ AIR mode: Air fields + Entry Point in Documentation');
      }
      else if (modeId === 3 || modeName.includes('RAIL') || modeName.includes('WAGON')) {
        $('#road_manifest_field').show();
        $('#wagon_field_row').show();
        $('#road_fields').show();
        $('#logistics_fields').show();
        adjustLogisticsLayout();
        console.log('🚂 RAIL/WAGON mode: Road Manifest + Wagon + Horse/Trailers/Container/Entry Point + all logistics');
      }
      else if (modeName.includes('ROAD')) {
        $('#road_manifest_field').show();
        $('#road_fields').show();
        $('#logistics_fields').show();
        adjustLogisticsLayout();
        console.log('🚛 ROAD mode: Road Manifest + Horse/Trailers/Container/Entry Point + all logistics');
      }
      else {
        $('#logistics_fields').show();
        adjustLogisticsLayout();
        console.log('📦 DEFAULT mode: Showing all logistics');
      }
    }

    const dateSequenceFields = [
      'arrival_date_zambia',
      'dispatch_from_zambia',
      'drc_entry_date',
      'border_warehouse_arrival_date',
      'dispatch_from_border'
    ];

    $('.date-sequence-field').on('change', function() {
      validateDateSequence($(this));
    });

    function validateDateSequence($field) {
      const fieldId = $field.attr('id');
      const sequence = parseInt($field.data('seq'));
      const currentValue = $field.val();

      if (!currentValue) {
        $field.removeClass('date-sequence-error is-invalid');
        $(`#${fieldId}_error`).text('').hide();
        return true;
      }

      const currentDate = new Date(currentValue);

      if (sequence > 1) {
        const prevFieldId = dateSequenceFields[sequence - 2];
        const prevValue = $(`#${prevFieldId}`).val();

        if (prevValue) {
          const prevDate = new Date(prevValue);

          if (currentDate < prevDate) {
            $field.val(prevValue);
            $field.addClass('date-sequence-error is-invalid');
            $(`#${fieldId}_error`).text(`Date cannot be before ${getFieldLabel(prevFieldId)} (${formatDate(prevValue)}). Auto-adjusted.`).show();

            $('html, body').animate({
              scrollTop: $field.offset().top - 100
            }, 500);

            Swal.fire({
              icon: 'warning',
              title: 'Date Sequence Error',
              html: `<strong>${escapeHtml(getFieldLabel(fieldId))}</strong> cannot be before <strong>${escapeHtml(getFieldLabel(prevFieldId))}</strong>.<br><br>Date auto-adjusted to: <strong>${escapeHtml(formatDate(prevValue))}</strong>`,
              confirmButtonText: 'OK',
              confirmButtonColor: '#f39c12',
              timer: 5000
            });

            setTimeout(() => {
              $field.removeClass('date-sequence-error is-invalid');
              $(`#${fieldId}_error`).text('').hide();
            }, 3000);

            return false;
          }
        }
      }

      $field.removeClass('date-sequence-error is-invalid');
      $(`#${fieldId}_error`).text('').hide();
      return true;
    }

    function getFieldLabel(fieldId) {
      const labels = {
        'arrival_date_zambia': 'Arrival Date Zambia',
        'dispatch_from_zambia': 'Dispatch from Zambia',
        'drc_entry_date': 'DRC Entry Date',
        'border_warehouse_arrival_date': 'Border Warehouse Arrival',
        'dispatch_from_border': 'Dispatch from Border'
      };
      return labels[fieldId] || fieldId;
    }

    function formatDate(dateStr) {
      if (!dateStr) return '';
      const date = new Date(dateStr);
      return date.toLocaleDateString('en-GB', { day: '2-digit', month: '2-digit', year: 'numeric' });
    }

    $('#subscriber_id').on('change', function() {
      const subscriberId = $(this).val();
      const selectedOption = $(this).find('option:selected');
      const liquidationPaidBy = selectedOption.data('liquidation');

      $('#license_id').html('<option value="">-- Select License --</option>');
      
      if (!subscriberId) {
        clearLicenseFields();
        $('#liquidation_paid_by').val('');
        return;
      }

      if (liquidationPaidBy == 1) {
        $('#liquidation_paid_by').val('Client');
      } else if (liquidationPaidBy == 2) {
        $('#liquidation_paid_by').val('Malabar');
      } else {
        $('#liquidation_paid_by').val('');
      }

      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/getLicenses',
        method: 'GET',
        data: { subscriber_id: subscriberId },
        dataType: 'json',
        success: function(res) {
          if (res.success && res.data.length > 0) {
            res.data.forEach(function(license) {
              $('#license_id').append(`<option value="${license.id}">${escapeHtml(license.license_number)}</option>`);
            });
          } else {
            Swal.fire({
              icon: 'info',
              title: 'No Import Licenses',
              text: 'No active import licenses found for this client.',
              timer: 3000,
              showConfirmButton: false
            });
          }
        },
        error: function() {
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Failed to load licenses',
            confirmButtonText: 'OK'
          });
        }
      });
    });

    function syncCurrencyFields(currencyId) {
      if (currencyId) {
        $('#fret_currency').val(currencyId);
        $('#other_charges_currency').val(currencyId);
        $('#fob_currency').val(currencyId);
        $('#insurance_amount_currency').val(currencyId);
      }
    }

    function clearLicenseFields() {
      $('#kind_hidden, #type_of_goods_hidden, #transport_mode_hidden, #currency_hidden').val('');
      $('#kind_display, #type_of_goods_display, #transport_mode_display, #currency_display').val('');
      $('#supplier, #crf_reference').val('');
      $('#commodity').html('<option value="">-- Select Commodity --</option>');
      $('#mca_ref').val('');
      $('#fret_currency, #other_charges_currency, #fob_currency, #insurance_amount_currency').val('');
      $('#liquidation_paid_by').val('');
      $('#air_fields, #air_entry_point_row, #wagon_field_row, #road_fields, #road_manifest_field, #logistics_fields').hide();
      $('#t1_number_col, #t1_date_col, #border_arrival_col_row1, #border_dispatch_col_row1').hide();
      $('#inspection_reports').html('<option value="">-- Select PARTIELLE --</option>');
      
      $('#available_partial_weight_display').val('');
      $('#available_partial_fob_display').val('');
      $('#available_partial_weight_hidden').val('');
      $('#available_partial_fob_hidden').val('');
      
      currentTypeOfGoodsId = null;
      console.log('🔄 License fields cleared, Type of Goods ID reset');
    }

    function generateMCAReference() {
      const formAction = $('#formAction').val();
      if (formAction === 'update') return;

      const subscriberId = $('#subscriber_id').val();
      const licenseId = $('#license_id').val();
      
      if (!subscriberId || !licenseId) {
        $('#mca_ref').val('');
        return;
      }

      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/getNextMCASequence',
        method: 'POST',
        data: { csrf_token: csrfToken, subscriber_id: subscriberId, license_id: licenseId },
        dataType: 'json',
        success: function(res) {
          if (res.success) {
            $('#mca_ref').val(res.mca_ref);
          }
        },
        error: function() {
          console.error('Failed to generate MCA reference');
        }
      });
    }

    function exportToExcel(importId) {
      window.location.href = '<?= APP_URL ?>/import/crudData/exportImport?id=' + importId;
      
      Swal.fire({
        icon: 'success',
        title: 'Exporting...',
        text: 'Your export will download shortly',
        timer: 2000,
        showConfirmButton: false
      });
    }

    $('#exportAllBtn').on('click', function() {
      let url = '<?= APP_URL ?>/import/crudData/exportAll';
      const params = new URLSearchParams();
      
      if (activeFilters.length > 0) {
        activeFilters.forEach(filter => {
          params.append('filters[]', filter);
        });
      }
      
      if (selectedClientId) {
        params.append('client_id', selectedClientId);
      }
      
      if (selectedTransportModeId) {
        params.append('transport_mode_id', selectedTransportModeId);
      }
      
      if (selectedStartDate) {
        params.append('start_date', selectedStartDate);
      }
      
      if (selectedEndDate) {
        params.append('end_date', selectedEndDate);
      }
      
      if (params.toString()) {
        url += '?' + params.toString();
      }
      
      window.location.href = url;
      
      Swal.fire({
        icon: 'success',
        title: 'Exporting All Imports...',
        text: 'Exporting with your filters',
        timer: 2000,
        showConfirmButton: false
      });
    });

    $('#addRemarkBtn').on('click', () => addRemarkEntry());

    function addRemarkEntry(date = '', text = '') {
      remarkCounter++;
      const remarkId = `remark_${remarkCounter}`;
      const remarkHtml = `
        <div class="remarks-entry" id="${remarkId}">
          <button type="button" class="btn btn-sm btn-danger btn-remove" onclick="$('#${remarkId}').remove(); updateRemarksHidden();">
            <i class="ti ti-x"></i>
          </button>
          <div class="row">
            <div class="col-md-3 mb-2">
              <label>Date</label>
              <input type="date" class="form-control remark-date" value="${escapeHtml(date)}">
            </div>
            <div class="col-md-9 mb-2">
              <label>Remark Text</label>
              <textarea class="form-control remark-text" rows="2">${escapeHtml(text)}</textarea>
            </div>
          </div>
        </div>
      `;
      $('#remarksContainer').append(remarkHtml);
      updateRemarksHidden();
    }

    function updateRemarksHidden() {
      const remarks = [];
      $('.remarks-entry').each(function() {
        const date = $(this).find('.remark-date').val();
        const text = $(this).find('.remark-text').val();
        if (date || text) remarks.push({ date, text });
      });
      $('#remarks_hidden').val(JSON.stringify(remarks));
    }

    $(document).on('change input', '.remark-date, .remark-text', updateRemarksHidden);

    function validateForm() {
      console.log('🔍 Starting form validation...');
      
      clearValidationErrors();
      let errors = [];
      
      const requiredFields = [
        { id: 'subscriber_id', label: 'Client' },
        { id: 'license_id', label: 'License Number' },
        { id: 'regime', label: 'Regime' },
        { id: 'types_of_clearance', label: 'Types of Clearance' },
        { id: 'pre_alert_date', label: 'Pre-Alert Date' },
        { id: 'invoice', label: 'Invoice' },
        { id: 'commodity', label: 'Commodity' },
        { id: 'weight', label: 'Weight' },
        { id: 'fob', label: 'FOB' },
        { id: 'entry_point_id', label: 'Entry Point' },
        { id: 'clearing_status', label: 'Clearing Status' }
      ];
      
      const transportMode = $('#transport_mode_display').val().toUpperCase();
      if (transportMode.includes('AIR')) {
        requiredFields.push({ id: 'entry_point_id_air', label: 'Entry Point' });
      } else {
        requiredFields.push({ id: 'entry_point_id', label: 'Entry Point' });
      }

      requiredFields.forEach(field => {
        const value = $(`#${field.id}`).val();
        if (!value || value === '') {
          showFieldError(field.id, `${field.label} is required`);
          errors.push(`${field.label} is required`);
        }
      });

      const weight = parseFloat($('#weight').val());
      const fob = parseFloat($('#fob').val());
      
      console.log('📊 Validating numeric values:', { weight, fob });
      
      if (isNaN(weight) || weight < 0) {
        showFieldError('weight', 'Weight must be a positive number or zero');
        errors.push('Invalid weight');
      }
      
      if (isNaN(fob) || fob < 0) {
        showFieldError('fob', 'FOB must be a positive number');
        errors.push('Invalid FOB');
      }

      const partialName = $('#inspection_reports').val();
      
      if (partialName && partialName !== '') {
        const partialWeight = parseFloat($('#available_partial_weight_hidden').val()) || 0;
        const partialFob = parseFloat($('#available_partial_fob_hidden').val()) || 0;
        
        console.log('📊 PARTIELLE validation:', {
          partial_weight: partialWeight,
          partial_fob: partialFob,
          entered_weight: weight,
          entered_fob: fob
        });
        
        if (weight > partialWeight) {
          showFieldError('weight', `Weight exceeds PARTIELLE allocation: ${partialWeight.toFixed(2)} KG`);
          errors.push(`Weight exceeds PARTIELLE allocation`);
          console.log('❌ Weight validation failed');
        }
        
        if (fob > partialFob) {
          showFieldError('fob', `FOB exceeds PARTIELLE allocation: ${partialFob.toFixed(2)}`);
          errors.push(`FOB exceeds PARTIELLE allocation`);
          console.log('❌ FOB validation failed');
        }
      }

      const preAlertDate = $('#pre_alert_date').val();
      if (preAlertDate) {
        $('.date-after-prealert').each(function() {
          const fieldVal = $(this).val();
          if (fieldVal && fieldVal < preAlertDate) {
            const fieldId = $(this).attr('id');
            const label = $(this).closest('.mb-3').find('label').first().text().replace('*', '').trim();
            showFieldError(fieldId, `${label} cannot be before Pre-Alert Date`);
            errors.push(`${label} cannot be before Pre-Alert Date`);
          }
        });
      }

      $('.date-sequence-field').each(function() {
        validateDateSequence($(this));
      });

      validateAirportDateSequence();

      console.log('🏁 Form validation complete:', {
        is_valid: errors.length === 0,
        error_count: errors.length,
        errors: errors
      });

      return { isValid: errors.length === 0, errors };
    }

    function clearValidationErrors() {
      $('.form-control, .form-select').removeClass('is-invalid');
      $('.invalid-feedback').text('').hide();
    }

    function showFieldError(fieldId, errorMessage) {
      $('#' + fieldId).addClass('is-invalid');
      $('#' + fieldId + '_error').text(errorMessage).show();
    }

    $('#importForm').on('submit', function (e) {
      e.preventDefault();
      
      console.log('📝 Form submission triggered');
      console.log('📊 Current form state:', {
        type_of_goods_id: currentTypeOfGoodsId,
        type_of_goods_hidden: $('#type_of_goods_hidden').val(),
        license_id: $('#license_id').val(),
        partielle: $('#inspection_reports').val(),
        weight: $('#weight').val(),
        fob: $('#fob').val()
      });
      
      updateDocumentStatus();
      
      if ($('#air_entry_point_row').is(':visible')) {
        $('#entry_point_id').val($('#entry_point_id_air').val());
      }
      
      const validation = validateForm();
      
      if (!validation.isValid) {
        $('#importTracking').collapse('show');
        
        Swal.fire({
          icon: 'error',
          title: 'Validation Error',
          html: '<ul style="text-align:left;"><li>' + validation.errors.map(err => escapeHtml(err)).join('</li><li>') + '</li></ul>',
          confirmButtonText: 'OK'
        });
        
        const firstError = $('.is-invalid').first();
        if (firstError.length) {
          $('html, body').animate({
            scrollTop: firstError.offset().top - 100
          }, 300);
        }
        
        console.log('❌ Form validation failed - submission cancelled');
        return false;
      }

      console.log('✅ Form validation passed - proceeding with AJAX submission');

      const submitBtn = $('#submitBtn');
      const originalText = submitBtn.html();
      submitBtn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm me-1"></i> Saving...');

      const formData = new FormData(this);
      formData.set('csrf_token', csrfToken);
      
      if (currentTypeOfGoodsId !== null) {
        formData.set('type_of_goods', currentTypeOfGoodsId);
      }
      
      console.log('📤 Submitting form data:');
      for (let pair of formData.entries()) {
        if (pair[0] === 'type_of_goods' || pair[0] === 'weight' || pair[0] === 'fob' || pair[0] === 'inspection_reports') {
          console.log(`  ${pair[0]}: ${pair[1]}`);
        }
      }
      
      $('#document_status').prop('disabled', false);

      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/' + $('#formAction').val(),
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function (res) {
          console.log('📥 Form submission response:', res);
          
          submitBtn.prop('disabled', false).html(originalText);
          $('#document_status').prop('disabled', true);
          
          if (res.success) {
            Swal.fire({ 
              icon: 'success', 
              title: 'Success!', 
              text: res.message, 
              timer: 1500, 
              showConfirmButton: false 
            });
            
            resetForm();
            $('#importTracking').collapse('hide');
            
            if (typeof importsTable !== 'undefined') {
              importsTable.ajax.reload(null, false);
            }
            updateStatistics();
          } else {
            console.error('❌ Server returned error:', res.message);
            Swal.fire({ 
              icon: 'error', 
              title: 'Error!', 
              html: res.message,
              confirmButtonText: 'OK'
            });
          }
        },
        error: function (xhr) {
          console.error('❌ AJAX submission error:', xhr);
          
          submitBtn.prop('disabled', false).html(originalText);
          $('#document_status').prop('disabled', true);
          
          let errorMsg = 'An error occurred while processing your request';
          
          if (xhr.responseJSON && xhr.responseJSON.message) {
            errorMsg = xhr.responseJSON.message;
          } else if (xhr.status === 403) {
            errorMsg = 'Security token expired. Please refresh the page and try again.';
          }
          
          Swal.fire({ 
            icon: 'error', 
            title: 'Server Error', 
            html: errorMsg,
            confirmButtonText: 'OK'
          });
        }
      });
    });

    function resetForm() {
      $('#importForm')[0].reset();
      clearValidationErrors();
      $('#import_id, #mca_ref, #crf_reference').val('');
      $('#formAction').val('insert');
      $('#formTitle').text('Add New Import');
      $('#submitBtnText').text('Save Import');
      $('#resetFormBtn').hide();
      $('#remarksContainer').empty();
      clearLicenseFields();
      
      $('#types_of_clearance').val('1');
      $('#document_status').val('1');
      
      if (clearingStatusIds.in_transit_id) {
        $('#clearing_status').val(clearingStatusIds.in_transit_id);
      }
      
      $('#liquidation_paid_by').val('');
      
      $('#importTracking').collapse('hide');
      
      loadCommoditiesForLicense();
      
      console.log('🔄 Form reset complete');
    }

    $('#cancelBtn, #resetFormBtn').on('click', (e) => { 
      e.preventDefault(); 
      resetForm(); 
    });

    $('.stats-card').on('click', function() {
      const filter = $(this).data('filter');
      
      if (filter === 'all') {
        $('.stats-card').removeClass('active');
        $(this).addClass('active');
        activeFilters = [];
      } else {
        $('.stats-card[data-filter="all"]').removeClass('active');
        
        if ($(this).hasClass('active')) {
          $(this).removeClass('active');
          activeFilters = activeFilters.filter(f => f !== filter);
        } else {
          $(this).addClass('active');
          if (!activeFilters.includes(filter)) {
            activeFilters.push(filter);
          }
        }
      }
      
      updateActiveFiltersDisplay();
      applyFiltersToTable();
      updateBulkUpdateButton();
    });

    function updateActiveFiltersDisplay() {
      const totalFilters = activeFilters.length + 
                          (selectedClientId ? 1 : 0) + 
                          (selectedTransportModeId ? 1 : 0) + 
                          (selectedStartDate ? 1 : 0) + 
                          (selectedEndDate ? 1 : 0);
      
      if (totalFilters > 0) {
        $('#activeFiltersBadge').show().text(totalFilters + ' Filter' + (totalFilters > 1 ? 's' : '') + ' Active');
      } else {
        $('#activeFiltersBadge').hide();
      }
    }

    function applyFiltersToTable() {
      if (typeof importsTable !== 'undefined') {
        importsTable.ajax.reload();
      }
    }

    function updateBulkUpdateButton() {
      const hasFilters = activeFilters.length > 0 || 
                        selectedClientId || 
                        selectedTransportModeId || 
                        selectedStartDate || 
                        selectedEndDate;
      
      if (hasFilters) {
        $('#bulkUpdateBtn').prop('disabled', false);
      } else {
        $('#bulkUpdateBtn').prop('disabled', true);
      }
    }

    $('#bulkUpdateBtn').on('click', function() {
      const hasFilters = activeFilters.length > 0 || 
                        selectedClientId || 
                        selectedTransportModeId || 
                        selectedStartDate || 
                        selectedEndDate;
      
      if (!hasFilters) {
        Swal.fire({
          icon: 'warning',
          title: 'No Filter Selected',
          text: 'Please select at least one filter before bulk updating.',
          confirmButtonText: 'OK',
          confirmButtonColor: '#f39c12'
        });
        return;
      }

      $('#bulkUpdateModal').modal('show');
      
      $('#bulkUpdateContent').html('<div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-3">Loading import records...</p></div>');

      const filterNames = {
        'completed': 'Completed',
        'in_progress': 'In Progress',
        'in_transit': 'In Transit',
        'crf_missing': 'CRF Missing',
        'ad_missing': 'AD Missing',
        'insurance_missing': 'Insurance Missing',
        'audited_pending': 'Audited Pending',
        'archived_pending': 'Archived Pending',
        'dgda_in_pending': 'DGDA In Pending',
        'liquidation_pending': 'Liquidation Pending',
        'quittance_pending': 'Quittance Pending',
        'client_filter': 'Client Filter'
      };
      
      let summaryParts = [];
      
      if (activeFilters.length > 0) {
        const activeFilterNames = activeFilters.map(f => filterNames[f] || f).join(', ');
        summaryParts.push('<strong>Card Filters:</strong> ' + escapeHtml(activeFilterNames));
      }
      
      if (selectedClientId) {
        const clientName = $('#filterClientSelect option:selected').text();
        summaryParts.push('<strong>Client:</strong> ' + escapeHtml(clientName));
      }
      
      if (selectedTransportModeId) {
        const transportName = $('#filterTransportModeSelect option:selected').text();
        summaryParts.push('<strong>Transport Mode:</strong> ' + escapeHtml(transportName));
      }
      
      if (selectedStartDate || selectedEndDate) {
        const dateRange = (selectedStartDate || 'Beginning') + ' to ' + (selectedEndDate || 'Today');
        summaryParts.push('<strong>Date Range:</strong> ' + escapeHtml(dateRange));
      }
      
      $('#bulkFilterSummary').html(summaryParts.join('<br>'));

      const requestData = { 
        filters: activeFilters
      };
      
      if (selectedClientId) {
        requestData.client_id = selectedClientId;
      }
      
      if (selectedTransportModeId) {
        requestData.transport_mode_id = selectedTransportModeId;
      }
      
      if (selectedStartDate) {
        requestData.start_date = selectedStartDate;
      }
      
      if (selectedEndDate) {
        requestData.end_date = selectedEndDate;
      }

      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/getBulkUpdateData',
        method: 'GET',
        data: requestData,
        dataType: 'json',
        success: function(res) {
          if (res.success && res.data) {
            bulkUpdateData = res.data;
            renderBulkUpdateTable(res.data, res.relevant_fields || []);
          } else {
            $('#bulkUpdateContent').html(`
              <div class="alert alert-info">
                <i class="ti ti-info-circle me-2"></i>
                ${escapeHtml(res.message || 'No records found matching the selected filters.')}
              </div>
            `);
            $('#saveBulkUpdateBtn').prop('disabled', true);
          }
        },
        error: function(xhr) {
          let errorMsg = 'Failed to load bulk update data. Please try again.';
          
          if (xhr.responseJSON && xhr.responseJSON.message) {
            errorMsg = xhr.responseJSON.message;
          }
          
          $('#bulkUpdateContent').html(`
            <div class="alert alert-danger">
              <i class="ti ti-alert-circle me-2"></i>
              ${escapeHtml(errorMsg)}
            </div>
          `);
          $('#saveBulkUpdateBtn').prop('disabled', true);
        }
      });
    });

    function renderBulkUpdateTable(data, relevantFields) {
      if (!data || data.length === 0) {
        $('#bulkUpdateContent').html(`
          <div class="alert alert-info">
            <i class="ti ti-info-circle me-2"></i>
            No records found for bulk update.
          </div>
        `);
        $('#saveBulkUpdateBtn').prop('disabled', true);
        return;
      }

      let tableHtml = `
        <div class="bulk-table-container">
          <table class="bulk-update-table">
            <thead>
              <tr>
                <th style="width: 40px;">
                  <input type="checkbox" class="form-check-input" id="selectAllBulk">
                </th>
                <th style="width: 120px;">MCA Ref</th>
                <th style="width: 100px;">Client</th>
                <th style="width: 100px;">Pre-Alert</th>
      `;

      const fieldConfig = {
        'weight': { label: 'Weight', type: 'number' },
        'fob': { label: 'FOB', type: 'number' },
        'crf_reference': { label: 'CRF Reference', type: 'text' },
        'crf_received_date': { label: 'CRF Date', type: 'date' },
        'ad_date': { label: 'AD Date', type: 'date' },
        'insurance_date': { label: 'Insurance Date', type: 'date' },
        'insurance_amount': { label: 'Insurance Amount', type: 'number' },
        'audited_date': { label: 'Audited Date', type: 'date' },
        'archived_date': { label: 'Archived Date', type: 'date' },
        'dgda_in_date': { label: 'DGDA In Date', type: 'date' },
        'liquidation_date': { label: 'Liquidation Date', type: 'date' },
        'quittance_date': { label: 'Quittance Date', type: 'date' }
      };

      relevantFields.forEach(field => {
        const config = fieldConfig[field];
        if (config) {
          tableHtml += `<th style="width: 140px;">${escapeHtml(config.label)}</th>`;
        }
      });

      tableHtml += `</tr></thead><tbody>`;

      data.forEach((row, index) => {
        tableHtml += `
          <tr data-import-id="${parseInt(row.id)}">
            <td>
              <input type="checkbox" class="form-check-input bulk-row-checkbox" data-index="${index}">
            </td>
            <td>
              <span class="mca-ref-badge">${escapeHtml(row.mca_ref || '')}</span>
            </td>
            <td><small>${escapeHtml(row.subscriber_name || '')}</small></td>
            <td>
              <small class="pre-alert-date-text">${escapeHtml(formatDate(row.pre_alert_date) || '')}</small>
            </td>
        `;

        relevantFields.forEach(field => {
          const config = fieldConfig[field];
          if (config) {
            const currentValue = row[field] || '';
            
            if (config.type === 'text') {
              tableHtml += `
                <td>
                  <input type="text" 
                         class="form-control bulk-field" 
                         data-field="${field}" 
                         data-import-id="${parseInt(row.id)}"
                         value="${escapeHtml(currentValue)}" 
                         maxlength="100">
                </td>
              `;
            } else if (config.type === 'date') {
              tableHtml += `
                <td>
                  <input type="date" 
                         class="form-control bulk-field" 
                         data-field="${field}" 
                         data-import-id="${parseInt(row.id)}"
                         value="${escapeHtml(currentValue)}">
                </td>
              `;
            } else if (config.type === 'number') {
              tableHtml += `
                <td>
                  <input type="number" 
                         step="0.01" 
                         class="form-control bulk-field" 
                         data-field="${field}" 
                         data-import-id="${parseInt(row.id)}"
                         value="${escapeHtml(currentValue)}" 
                         min="0">
                </td>
              `;
            }
          }
        });

        tableHtml += `</tr>`;
      });

      tableHtml += `</tbody></table></div>`;

      $('#bulkUpdateContent').html(tableHtml);
      $('#saveBulkUpdateBtn').prop('disabled', false);

      attachBulkUpdateHandlers();
    }

    function attachBulkUpdateHandlers() {
      $('#selectAllBulk').on('change', function() {
        const isChecked = $(this).prop('checked');
        $('.bulk-row-checkbox').prop('checked', isChecked);
        
        if (isChecked) {
          $('.bulk-update-table tbody tr').addClass('selected');
        } else {
          $('.bulk-update-table tbody tr').removeClass('selected');
        }
      });

      $('.bulk-row-checkbox').on('change', function() {
        const $row = $(this).closest('tr');
        
        if ($(this).prop('checked')) {
          $row.addClass('selected');
        } else {
          $row.removeClass('selected');
        }

        const totalRows = $('.bulk-row-checkbox').length;
        const checkedRows = $('.bulk-row-checkbox:checked').length;
        $('#selectAllBulk').prop('checked', totalRows === checkedRows);
      });

      $('.bulk-field').on('change', function() {
        const $row = $(this).closest('tr');
        $row.find('.bulk-row-checkbox').prop('checked', true).trigger('change');
        $(this).addClass('border-warning');
      });
    }

    $('#saveBulkUpdateBtn').on('click', function() {
      const selectedRows = $('.bulk-row-checkbox:checked');
      
      if (selectedRows.length === 0) {
        Swal.fire({
          icon: 'warning',
          title: 'No Records Selected',
          text: 'Please select at least one record to update by checking the checkbox.',
          confirmButtonText: 'OK',
          confirmButtonColor: '#f39c12'
        });
        return;
      }

      const updateData = [];
      
      selectedRows.each(function() {
        const $row = $(this).closest('tr');
        const importId = parseInt($row.data('import-id'));
        const rowData = { import_id: importId };
        
        $row.find('.bulk-field').each(function() {
          const field = $(this).data('field');
          const value = $(this).val();
          
          if (value !== null && value !== undefined && value !== '') {
            rowData[field] = value;
          } else {
            rowData[field] = null;
          }
        });
        
        if (Object.keys(rowData).length > 1) {
          updateData.push(rowData);
        }
      });

      if (updateData.length === 0) {
        Swal.fire({
          icon: 'info',
          title: 'No Changes Detected',
          text: 'No field changes detected in the selected records.',
          confirmButtonText: 'OK',
          confirmButtonColor: '#3085d6'
        });
        return;
      }

      Swal.fire({
        title: 'Confirm Bulk Update',
        html: `You are about to update <strong>${updateData.length}</strong> record(s).<br><br>Are you sure you want to proceed?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Yes, Update',
        cancelButtonText: 'Cancel',
        confirmButtonColor: '#28a745'
      }).then((result) => {
        if (result.isConfirmed) {
          performBulkUpdate(updateData);
        }
      });
    });

    function performBulkUpdate(updateData) {
      const $saveBtn = $('#saveBulkUpdateBtn');
      const originalText = $saveBtn.html();
      $saveBtn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm me-1"></i> Updating...');

      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/bulkUpdate',
        method: 'POST',
        data: {
          csrf_token: csrfToken,
          update_data: JSON.stringify(updateData)
        },
        dataType: 'json',
        success: function(res) {
          $saveBtn.prop('disabled', false).html(originalText);
          
          if (res.success) {
            let message = res.message || 'Bulk update completed successfully!';
            
            if (res.error_count > 0) {
              message += `<br><br><strong>Errors:</strong><br>`;
              message += '<ul style="text-align:left; max-height:200px; overflow-y:auto;">';
              (res.errors || []).forEach(error => {
                message += `<li>${escapeHtml(error)}</li>`;
              });
              message += '</ul>';
            }

            Swal.fire({
              icon: res.error_count > 0 ? 'warning' : 'success',
              title: 'Bulk Update Complete',
              html: message,
              confirmButtonText: 'OK'
            }).then(() => {
              $('#bulkUpdateModal').modal('hide');
              
              if (typeof importsTable !== 'undefined') {
                importsTable.ajax.reload(null, false);
              }
              updateStatistics();
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Update Failed',
              html: res.message || 'Bulk update failed. Please try again.',
              confirmButtonText: 'OK'
            });
          }
        },
        error: function(xhr) {
          $saveBtn.prop('disabled', false).html(originalText);
          
          let errorMsg = 'Failed to perform bulk update. Please try again.';
          
          if (xhr.responseJSON && xhr.responseJSON.message) {
            errorMsg = xhr.responseJSON.message;
          } else if (xhr.status === 403) {
            errorMsg = 'Security token expired. Please refresh the page and try again.';
          }
          
          Swal.fire({
            icon: 'error',
            title: 'Server Error',
            html: errorMsg,
            confirmButtonText: 'OK'
          });
        }
      });
    }

    // ========================================
    // ✅ UPDATED: DATATABLES INITIALIZATION (ID COLUMN REMOVED)
    // ========================================

    var importsTable;
    function initDataTable() {
      if ($.fn.DataTable.isDataTable('#importsTable')) {
        $('#importsTable').DataTable().destroy();
      }

      importsTable = $('#importsTable').DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        ajax: { 
          url: '<?= APP_URL ?>/import/crudData/listing', 
          type: 'GET',
          data: function(d) {
            d.filters = activeFilters;
            
            if (selectedClientId) {
              d.client_id = selectedClientId;
            }
            
            if (selectedTransportModeId) {
              d.transport_mode_id = selectedTransportModeId;
            }
            
            if (selectedStartDate) {
              d.start_date = selectedStartDate;
            }
            
            if (selectedEndDate) {
              d.end_date = selectedEndDate;
            }
            
            console.log('🔍 DataTables Request:', d);
            
            return d;
          },
          error: function(xhr, error, code) {
            console.error('❌ DataTable Error:', error, code);
            console.error('❌ Response:', xhr.responseText);
          },
          dataSrc: function(json) {
            console.log('📥 DataTables Response:', json);
            return json.data;
          }
        },
        columns: [
          { data: 'mca_ref', render: function(data) { return escapeHtml(data); } },
          { data: 'subscriber_name', render: function(data) { return escapeHtml(data); } },
          { data: 'license_number', render: function(data) { return escapeHtml(data); } },
          { data: 'invoice', render: function(data) { return escapeHtml(data); } },
          { 
            data: 'pre_alert_date',
            render: function(data) {
              return data ? escapeHtml(formatDate(data)) : '';
            }
          },
          { 
            data: 'weight', 
            render: (data) => data ? parseFloat(data).toFixed(2) : '0.00' 
          },
          { 
            data: 'fob', 
            render: (data) => data ? parseFloat(data).toFixed(2) : '0.00' 
          },
          { data: 'clearing_status', render: function(data) { return escapeHtml(data); } },
          {
            data: null, 
            orderable: false, 
            searchable: false,
            render: (data, type, row) => `
              <button class="btn btn-sm btn-primary editBtn" data-id="${parseInt(row.id)}" title="Edit">
                <i class="ti ti-edit"></i>
              </button>
              <button class="btn btn-sm btn-export exportBtn" data-id="${parseInt(row.id)}" title="Export to Excel">
                <i class="ti ti-file-spreadsheet"></i>
              </button>
              <button class="btn btn-sm btn-danger deleteBtn" data-id="${parseInt(row.id)}" title="Delete">
                <i class="ti ti-trash"></i>
              </button>
            `
          }
        ],
        order: [[0, 'desc']],
        pageLength: 25,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
        responsive: false,
        language: {
          search: "Search:",
          searchPlaceholder: "MCA, Client, License, Invoice, Horse, Trailer...",
          processing: '<div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div>',
          emptyTable: "No imports found",
          zeroRecords: "No matching imports found"
        },
        dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rt<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>'
      });
    }

    function updateStatistics() {
      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/statistics',
        method: 'GET',
        dataType: 'json',
        success: function(res) {
          if (res.success) {
            $('#totalTrackings').text(res.data.total_imports || 0);
            $('#totalCompleted').text(res.data.total_completed || 0);
            $('#totalInProgress').text(res.data.in_progress || 0);
            $('#totalInTransit').text(res.data.in_transit || 0);
            $('#totalCRFMissing').text(res.data.crf_missing || 0);
            $('#totalADMissing').text(res.data.ad_missing || 0);
            $('#totalInsuranceMissing').text(res.data.insurance_missing || 0);
            $('#totalAuditedPending').text(res.data.audited_pending || 0);
            $('#totalArchivedPending').text(res.data.archived_pending || 0);
            $('#totalDgdaInPending').text(res.data.dgda_in_pending || 0);
            $('#totalLiquidationPending').text(res.data.liquidation_pending || 0);
            $('#totalQuittancePending').text(res.data.quittance_pending || 0);
          }
        },
        error: function() {
          console.error('Failed to load statistics');
        }
      });
    }

    $(document).on('click', '.exportBtn', function () {
      const id = parseInt($(this).data('id'));
      exportToExcel(id);
    });

    $(document).on('click', '.editBtn', function () {
      const id = parseInt($(this).data('id'));
      
      $.ajax({
        url: '<?= APP_URL ?>/import/crudData/details',
        method: 'GET',
        data: { id: id },
        dataType: 'json',
        success: function(res) {
          if (res.success && res.data) {
            populateEditForm(res.data);
            $('#importTracking').collapse('show');
            $('html, body').animate({ scrollTop: 0 }, 300);
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error',
              html: res.message || 'Failed to load import details',
              confirmButtonText: 'OK'
            });
          }
        },
        error: function(xhr) {
          let errorMsg = 'Failed to load import details';
          
          if (xhr.responseJSON && xhr.responseJSON.message) {
            errorMsg = xhr.responseJSON.message;
          }
          
          Swal.fire({
            icon: 'error',
            title: 'Error',
            html: errorMsg,
            confirmButtonText: 'OK'
          });
        }
      });
    });

    function populateEditForm(data) {
      console.log('✏️ Populating edit form with data:', data);
      
      $('#import_id').val(data.id);
      $('#formAction').val('update');
      $('#formTitle').text('Edit Import');
      $('#submitBtnText').text('Update Import');
      $('#resetFormBtn').show();

      $('#subscriber_id').val(data.subscriber_id).trigger('change');
      
      setTimeout(() => {
        $('#license_id').val(data.license_id);
        
        $('#kind_hidden').val(data.kind || '');
        $('#type_of_goods_hidden').val(data.type_of_goods || '');
        $('#transport_mode_hidden').val(data.transport_mode || '');
        $('#currency_hidden').val(data.currency || '');
        
        currentTypeOfGoodsId = data.type_of_goods || null;
        console.log('✅ Edit mode - Type of Goods ID set:', currentTypeOfGoodsId);
        
        $('#kind_display').val(data.kind_name || '');
        $('#type_of_goods_display').val(data.type_of_goods_name || '');
        $('#transport_mode_display').val(data.transport_mode_name || '');
        $('#currency_display').val(data.currency_name || '');
        
        handleTransportModeFields(data.transport_mode, data.transport_mode_name);
        
        if (data.license_id) {
          loadPartielleForEdit(data.license_id, data.inspection_reports);
          
          if (data.inspection_reports && data.inspection_reports !== '') {
            setTimeout(() => {
              $('#inspection_reports').val(data.inspection_reports);
              
              $.ajax({
                url: '<?= APP_URL ?>/import/crudData/getPartielleDetails',
                method: 'GET',
                data: { partial_name: data.inspection_reports },
                dataType: 'json',
                success: function(res) {
                  if (res.success && res.data) {
                    const partial = res.data;
                    
                    const partialWeight = parseFloat(partial.partial_weight || 0);
                    const partialFob = parseFloat(partial.partial_fob || 0);
                    
                    $('#available_partial_weight_display').val(
                      partialWeight.toLocaleString('en-US', { 
                        minimumFractionDigits: 2, 
                        maximumFractionDigits: 2 
                      }) + ' KG'
                    );
                    
                    $('#available_partial_fob_display').val(
                      partialFob.toLocaleString('en-US', { 
                        minimumFractionDigits: 2, 
                        maximumFractionDigits: 2 
                      })
                    );
                    
                    $('#available_partial_weight_hidden').val(partialWeight);
                    $('#available_partial_fob_hidden').val(partialFob);
                    
                    console.log('✅ EDIT MODE: PARTIELLE capacity:', {
                      partial_weight: partialWeight,
                      partial_fob: partialFob
                    });
                  }
                },
                error: function(xhr) {
                  console.error('❌ Failed to load PARTIELLE for edit:', xhr);
                }
              });
            }, 800);
          }
        }
      }, 300);

      $('#mca_ref').val(data.mca_ref || '');
      $('#supplier').val(data.supplier || '');
      $('#regime').val(data.regime || '');
      $('#types_of_clearance').val(data.types_of_clearance || '');
      $('#declaration_office_id').val(data.declaration_office_id || '');
      $('#pre_alert_date').val(data.pre_alert_date || '');
      $('#invoice').val(data.invoice || '');
      $('#commodity').val(data.commodity || '');
      $('#po_ref').val(data.po_ref || '');
      
      $('#fret').val(data.fret || '');
      $('#fret_currency').val(data.fret_currency || '');
      $('#other_charges').val(data.other_charges || '');
      $('#other_charges_currency').val(data.other_charges_currency || '');
      $('#weight').val(data.weight || '');
      $('#fob').val(data.fob || '');
      $('#fob_currency').val(data.fob_currency || '');
      
      $('#crf_reference').val(data.crf_reference || '');
      $('#crf_received_date').val(data.crf_received_date || '');
      $('#clearing_based_on').val(data.clearing_based_on || '');
      $('#ad_date').val(data.ad_date || '');
      $('#insurance_date').val(data.insurance_date || '');
      $('#insurance_amount').val(data.insurance_amount || '');
      $('#insurance_amount_currency').val(data.insurance_amount_currency || '');
      $('#insurance_reference').val(data.insurance_reference || '');
      
      $('#archive_reference').val(data.archive_reference || '');
      $('#audited_date').val(data.audited_date || '');
      $('#archived_date').val(data.archived_date || '');
      
      $('#road_manif').val(data.road_manif || '');
      $('#wagon').val(data.wagon || '');
      $('#horse').val(data.horse || '');
      $('#trailer_1').val(data.trailer_1 || '');
      $('#trailer_2').val(data.trailer_2 || '');
      $('#container').val(data.container || '');
      $('#entry_point_id').val(data.entry_point_id || '');
      $('#entry_point_id_air').val(data.entry_point_id || '');
      
      $('#dgda_in_date').val(data.dgda_in_date || '');
      $('#declaration_reference').val(data.declaration_reference || '');
      $('#segues_rcv_ref').val(data.segues_rcv_ref || '');
      $('#segues_payment_date').val(data.segues_payment_date || '');
      $('#customs_manifest_number').val(data.customs_manifest_number || '');
      $('#customs_manifest_date').val(data.customs_manifest_date || '');
      $('#liquidation_reference').val(data.liquidation_reference || '');
      $('#liquidation_date').val(data.liquidation_date || '');
      $('#liquidation_paid_by').val(data.liquidation_paid_by || '');
      $('#liquidation_amount').val(data.liquidation_amount || '');
      $('#quittance_reference').val(data.quittance_reference || '');
      $('#quittance_date').val(data.quittance_date || '');
      $('#dgda_out_date').val(data.dgda_out_date || '');
      $('#document_status').val(data.document_status || '');
      $('#customs_clearance_code').val(data.customs_clearance_code || '');
      
      $('#airway_bill').val(data.airway_bill || '');
      $('#airway_bill_weight').val(data.airway_bill_weight || '');
      $('#airport_arrival_date').val(data.airport_arrival_date || '');
      $('#dispatch_from_airport').val(data.dispatch_from_airport || '');
      $('#declaration_validity').val(data.declaration_validity || '');
      
      $('#t1_number').val(data.t1_number || '');
      $('#t1_date').val(data.t1_date || '');
      $('#arrival_date_zambia').val(data.arrival_date_zambia || '');
      $('#dispatch_from_zambia').val(data.dispatch_from_zambia || '');
      $('#drc_entry_date').val(data.drc_entry_date || '');
      $('#border_warehouse_arrival_date').val(data.border_warehouse_arrival_date || '');
      $('#dispatch_from_border').val(data.dispatch_from_border || '');
      $('#ibs_coupon_reference').val(data.ibs_coupon_reference || '');
      $('#border_warehouse_id').val(data.border_warehouse_id || '');
      $('#entry_coupon').val(data.entry_coupon || '');
      $('#bonded_warehouse_id').val(data.bonded_warehouse_id || '');
      $('#truck_status').val(data.truck_status || '');
      $('#kanyaka_arrival_date').val(data.kanyaka_arrival_date || '');
      $('#kanyaka_dispatch_date').val(data.kanyaka_dispatch_date || '');
      $('#warehouse_arrival_date').val(data.warehouse_arrival_date || '');
      $('#warehouse_departure_date').val(data.warehouse_departure_date || '');
      $('#dispatch_deliver_date').val(data.dispatch_deliver_date || '');
      
      $('#clearing_status').val(data.clearing_status || '');
      
      $('#remarksContainer').empty();
      if (data.remarks) {
        let remarks = [];
        try {
          remarks = typeof data.remarks === 'string' ? JSON.parse(data.remarks) : data.remarks;
        } catch (e) {
          console.error('Failed to parse remarks:', e);
        }
        
        if (Array.isArray(remarks) && remarks.length > 0) {
          remarks.forEach(remark => {
            addRemarkEntry(remark.date || '', remark.text || '');
          });
        }
      }
      
      adjustLogisticsLayout();
      
      console.log('✅ Form populated successfully');
      console.log('📋 PARTIELLE selected:', data.inspection_reports || 'None');
    }

    $(document).on('click', '.deleteBtn', function () {
      const id = parseInt($(this).data('id'));
      
      Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel'
      }).then((result) => {
        if (result.isConfirmed) {
          $.ajax({
            url: '<?= APP_URL ?>/import/crudData/delete',
            method: 'POST',
            data: { id: id, csrf_token: csrfToken },
            dataType: 'json',
            success: function(res) {
              if (res.success) {
                Swal.fire({ 
                  icon: 'success', 
                  title: 'Deleted!', 
                  text: res.message, 
                  timer: 1500, 
                  showConfirmButton: false 
                });
                
                if (typeof importsTable !== 'undefined') {
                  importsTable.ajax.reload(null, false);
                }
                updateStatistics();
              } else {
                Swal.fire({ 
                  icon: 'error', 
                  title: 'Error!', 
                  html: res.message,
                  confirmButtonText: 'OK'
                });
              }
            },
            error: function(xhr) {
              let errorMsg = 'Failed to delete import';
              
              if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMsg = xhr.responseJSON.message;
              } else if (xhr.status === 403) {
                errorMsg = 'Security token expired. Please refresh the page and try again.';
              }
              
              Swal.fire({ 
                icon: 'error', 
                title: 'Error', 
                html: errorMsg,
                confirmButtonText: 'OK'
              });
            }
          });
        }
      });
    });

    initDataTable();
    updateStatistics();
    loadCommoditiesForLicense();

    console.log('✅ Import Tracking System initialized - FULLY AUTOMATIC Clearing Status');
    console.log('✅ ID column removed from DataTable');
    console.log('✅ Features: PARTIELLE allocation validation, automatic status updates');
  });
</script>